<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SPKIDataType StructType
 * @subpackage Structs
 */
class SPKIDataType extends AbstractStructBase
{
    /**
     * The SPKISexp
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SPKISexp;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SPKIDataType
     * @uses SPKIDataType::setSPKISexp()
     * @uses SPKIDataType::setAny()
     * @param string[] $sPKISexp
     * @param \DOMDocument $any
     */
    public function __construct(array $sPKISexp = array(), \DOMDocument $any = null)
    {
        $this
            ->setSPKISexp($sPKISexp)
            ->setAny($any);
    }
    /**
     * Get SPKISexp value
     * @return string[]|null
     */
    public function getSPKISexp()
    {
        return $this->SPKISexp;
    }
    /**
     * This method is responsible for validating the values passed to the setSPKISexp method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSPKISexp method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSPKISexpForArrayConstraintsFromSetSPKISexp(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sPKIDataTypeSPKISexpItem) {
            // validation for constraint: itemType
            if (!is_string($sPKIDataTypeSPKISexpItem)) {
                $invalidValues[] = is_object($sPKIDataTypeSPKISexpItem) ? get_class($sPKIDataTypeSPKISexpItem) : sprintf('%s(%s)', gettype($sPKIDataTypeSPKISexpItem), var_export($sPKIDataTypeSPKISexpItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SPKISexp property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SPKISexp value
     * @throws \InvalidArgumentException
     * @param string[] $sPKISexp
     * @return \Gek\UyumBahce\StructType\SPKIDataType
     */
    public function setSPKISexp(array $sPKISexp = array())
    {
        // validation for constraint: array
        if ('' !== ($sPKISexpArrayErrorMessage = self::validateSPKISexpForArrayConstraintsFromSetSPKISexp($sPKISexp))) {
            throw new \InvalidArgumentException($sPKISexpArrayErrorMessage, __LINE__);
        }
        $this->SPKISexp = $sPKISexp;
        return $this;
    }
    /**
     * Add item to SPKISexp value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Gek\UyumBahce\StructType\SPKIDataType
     */
    public function addToSPKISexp($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SPKISexp property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SPKISexp[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Gek\UyumBahce\StructType\SPKIDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
