<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestDef StructType
 * @subpackage Structs
 */
class RequestDef extends MasterFields
{
    /**
     * The DocTraId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DocTraId;
    /**
     * The AllocationsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AllocationsId;
    /**
     * The CostCenterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CostCenterId;
    /**
     * The WhouseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WhouseId;
    /**
     * The RequestUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RequestUserId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UserId;
    /**
     * The RequestStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RequestStatus;
    /**
     * The DocTraCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocTraCode;
    /**
     * The RequestUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestUserName;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The AllocationsCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllocationsCode;
    /**
     * The CostCenterCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostCenterCode;
    /**
     * The WhouseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WhouseCode;
    /**
     * The details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\ArrayType\ArrayOfRequestDetailDef
     */
    public $details;
    /**
     * The OpenCloseNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpenCloseNote;
    /**
     * The NoteLarge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteLarge;
    /**
     * Constructor method for RequestDef
     * @uses RequestDef::setDocTraId()
     * @uses RequestDef::setAllocationsId()
     * @uses RequestDef::setCostCenterId()
     * @uses RequestDef::setWhouseId()
     * @uses RequestDef::setRequestUserId()
     * @uses RequestDef::setUserId()
     * @uses RequestDef::setRequestStatus()
     * @uses RequestDef::setDocTraCode()
     * @uses RequestDef::setRequestUserName()
     * @uses RequestDef::setUserName()
     * @uses RequestDef::setAllocationsCode()
     * @uses RequestDef::setCostCenterCode()
     * @uses RequestDef::setWhouseCode()
     * @uses RequestDef::setDetails()
     * @uses RequestDef::setOpenCloseNote()
     * @uses RequestDef::setNoteLarge()
     * @param int $docTraId
     * @param int $allocationsId
     * @param int $costCenterId
     * @param int $whouseId
     * @param int $requestUserId
     * @param int $userId
     * @param string $requestStatus
     * @param string $docTraCode
     * @param string $requestUserName
     * @param string $userName
     * @param string $allocationsCode
     * @param string $costCenterCode
     * @param string $whouseCode
     * @param \Gek\UyumBahce\ArrayType\ArrayOfRequestDetailDef $details
     * @param string $openCloseNote
     * @param string $noteLarge
     */
    public function __construct($docTraId = null, $allocationsId = null, $costCenterId = null, $whouseId = null, $requestUserId = null, $userId = null, $requestStatus = null, $docTraCode = null, $requestUserName = null, $userName = null, $allocationsCode = null, $costCenterCode = null, $whouseCode = null, \Gek\UyumBahce\ArrayType\ArrayOfRequestDetailDef $details = null, $openCloseNote = null, $noteLarge = null)
    {
        $this
            ->setDocTraId($docTraId)
            ->setAllocationsId($allocationsId)
            ->setCostCenterId($costCenterId)
            ->setWhouseId($whouseId)
            ->setRequestUserId($requestUserId)
            ->setUserId($userId)
            ->setRequestStatus($requestStatus)
            ->setDocTraCode($docTraCode)
            ->setRequestUserName($requestUserName)
            ->setUserName($userName)
            ->setAllocationsCode($allocationsCode)
            ->setCostCenterCode($costCenterCode)
            ->setWhouseCode($whouseCode)
            ->setDetails($details)
            ->setOpenCloseNote($openCloseNote)
            ->setNoteLarge($noteLarge);
    }
    /**
     * Get DocTraId value
     * @return int
     */
    public function getDocTraId()
    {
        return $this->DocTraId;
    }
    /**
     * Set DocTraId value
     * @param int $docTraId
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setDocTraId($docTraId = null)
    {
        // validation for constraint: int
        if (!is_null($docTraId) && !(is_int($docTraId) || ctype_digit($docTraId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docTraId, true), gettype($docTraId)), __LINE__);
        }
        $this->DocTraId = $docTraId;
        return $this;
    }
    /**
     * Get AllocationsId value
     * @return int
     */
    public function getAllocationsId()
    {
        return $this->AllocationsId;
    }
    /**
     * Set AllocationsId value
     * @param int $allocationsId
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setAllocationsId($allocationsId = null)
    {
        // validation for constraint: int
        if (!is_null($allocationsId) && !(is_int($allocationsId) || ctype_digit($allocationsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocationsId, true), gettype($allocationsId)), __LINE__);
        }
        $this->AllocationsId = $allocationsId;
        return $this;
    }
    /**
     * Get CostCenterId value
     * @return int
     */
    public function getCostCenterId()
    {
        return $this->CostCenterId;
    }
    /**
     * Set CostCenterId value
     * @param int $costCenterId
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setCostCenterId($costCenterId = null)
    {
        // validation for constraint: int
        if (!is_null($costCenterId) && !(is_int($costCenterId) || ctype_digit($costCenterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($costCenterId, true), gettype($costCenterId)), __LINE__);
        }
        $this->CostCenterId = $costCenterId;
        return $this;
    }
    /**
     * Get WhouseId value
     * @return int
     */
    public function getWhouseId()
    {
        return $this->WhouseId;
    }
    /**
     * Set WhouseId value
     * @param int $whouseId
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setWhouseId($whouseId = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId) && !(is_int($whouseId) || ctype_digit($whouseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId, true), gettype($whouseId)), __LINE__);
        }
        $this->WhouseId = $whouseId;
        return $this;
    }
    /**
     * Get RequestUserId value
     * @return int
     */
    public function getRequestUserId()
    {
        return $this->RequestUserId;
    }
    /**
     * Set RequestUserId value
     * @param int $requestUserId
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setRequestUserId($requestUserId = null)
    {
        // validation for constraint: int
        if (!is_null($requestUserId) && !(is_int($requestUserId) || ctype_digit($requestUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestUserId, true), gettype($requestUserId)), __LINE__);
        }
        $this->RequestUserId = $requestUserId;
        return $this;
    }
    /**
     * Get UserId value
     * @return int
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !(is_int($userId) || ctype_digit($userId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get RequestStatus value
     * @return string
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }
    /**
     * Set RequestStatus value
     * @uses \Gek\UyumBahce\EnumType\RequestStatus::valueIsValid()
     * @uses \Gek\UyumBahce\EnumType\RequestStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestStatus
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Gek\UyumBahce\EnumType\RequestStatus::valueIsValid($requestStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\RequestStatus', is_array($requestStatus) ? implode(', ', $requestStatus) : var_export($requestStatus, true), implode(', ', \Gek\UyumBahce\EnumType\RequestStatus::getValidValues())), __LINE__);
        }
        $this->RequestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get DocTraCode value
     * @return string|null
     */
    public function getDocTraCode()
    {
        return $this->DocTraCode;
    }
    /**
     * Set DocTraCode value
     * @param string $docTraCode
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setDocTraCode($docTraCode = null)
    {
        // validation for constraint: string
        if (!is_null($docTraCode) && !is_string($docTraCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docTraCode, true), gettype($docTraCode)), __LINE__);
        }
        $this->DocTraCode = $docTraCode;
        return $this;
    }
    /**
     * Get RequestUserName value
     * @return string|null
     */
    public function getRequestUserName()
    {
        return $this->RequestUserName;
    }
    /**
     * Set RequestUserName value
     * @param string $requestUserName
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setRequestUserName($requestUserName = null)
    {
        // validation for constraint: string
        if (!is_null($requestUserName) && !is_string($requestUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestUserName, true), gettype($requestUserName)), __LINE__);
        }
        $this->RequestUserName = $requestUserName;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get AllocationsCode value
     * @return string|null
     */
    public function getAllocationsCode()
    {
        return $this->AllocationsCode;
    }
    /**
     * Set AllocationsCode value
     * @param string $allocationsCode
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setAllocationsCode($allocationsCode = null)
    {
        // validation for constraint: string
        if (!is_null($allocationsCode) && !is_string($allocationsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationsCode, true), gettype($allocationsCode)), __LINE__);
        }
        $this->AllocationsCode = $allocationsCode;
        return $this;
    }
    /**
     * Get CostCenterCode value
     * @return string|null
     */
    public function getCostCenterCode()
    {
        return $this->CostCenterCode;
    }
    /**
     * Set CostCenterCode value
     * @param string $costCenterCode
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setCostCenterCode($costCenterCode = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterCode) && !is_string($costCenterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenterCode, true), gettype($costCenterCode)), __LINE__);
        }
        $this->CostCenterCode = $costCenterCode;
        return $this;
    }
    /**
     * Get WhouseCode value
     * @return string|null
     */
    public function getWhouseCode()
    {
        return $this->WhouseCode;
    }
    /**
     * Set WhouseCode value
     * @param string $whouseCode
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setWhouseCode($whouseCode = null)
    {
        // validation for constraint: string
        if (!is_null($whouseCode) && !is_string($whouseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whouseCode, true), gettype($whouseCode)), __LINE__);
        }
        $this->WhouseCode = $whouseCode;
        return $this;
    }
    /**
     * Get details value
     * @return \Gek\UyumBahce\ArrayType\ArrayOfRequestDetailDef|null
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * Set details value
     * @param \Gek\UyumBahce\ArrayType\ArrayOfRequestDetailDef $details
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setDetails(\Gek\UyumBahce\ArrayType\ArrayOfRequestDetailDef $details = null)
    {
        $this->details = $details;
        return $this;
    }
    /**
     * Get OpenCloseNote value
     * @return string|null
     */
    public function getOpenCloseNote()
    {
        return $this->OpenCloseNote;
    }
    /**
     * Set OpenCloseNote value
     * @param string $openCloseNote
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setOpenCloseNote($openCloseNote = null)
    {
        // validation for constraint: string
        if (!is_null($openCloseNote) && !is_string($openCloseNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openCloseNote, true), gettype($openCloseNote)), __LINE__);
        }
        $this->OpenCloseNote = $openCloseNote;
        return $this;
    }
    /**
     * Get NoteLarge value
     * @return string|null
     */
    public function getNoteLarge()
    {
        return $this->NoteLarge;
    }
    /**
     * Set NoteLarge value
     * @param string $noteLarge
     * @return \Gek\UyumBahce\StructType\RequestDef
     */
    public function setNoteLarge($noteLarge = null)
    {
        // validation for constraint: string
        if (!is_null($noteLarge) && !is_string($noteLarge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteLarge, true), gettype($noteLarge)), __LINE__);
        }
        $this->NoteLarge = $noteLarge;
        return $this;
    }
}
