<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTermsType StructType
 * @subpackage Structs
 */
class PaymentTermsType extends AbstractStructBase
{
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Note
     * @var \Gek\UyumBahce\StructType\NoteType
     */
    public $Note;
    /**
     * The PenaltySurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PenaltySurchargePercent
     * @var \Gek\UyumBahce\StructType\PenaltySurchargePercentType
     */
    public $PenaltySurchargePercent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Amount
     * @var \Gek\UyumBahce\StructType\AmountType
     */
    public $Amount;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PenaltyAmount
     * @var \Gek\UyumBahce\StructType\PenaltyAmountType
     */
    public $PenaltyAmount;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentDueDate
     * @var \Gek\UyumBahce\StructType\PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The SettlementPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PeriodType
     */
    public $SettlementPeriod;
    /**
     * Constructor method for PaymentTermsType
     * @uses PaymentTermsType::setNote()
     * @uses PaymentTermsType::setPenaltySurchargePercent()
     * @uses PaymentTermsType::setAmount()
     * @uses PaymentTermsType::setPenaltyAmount()
     * @uses PaymentTermsType::setPaymentDueDate()
     * @uses PaymentTermsType::setSettlementPeriod()
     * @param \Gek\UyumBahce\StructType\NoteType $note
     * @param \Gek\UyumBahce\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @param \Gek\UyumBahce\StructType\AmountType $amount
     * @param \Gek\UyumBahce\StructType\PenaltyAmountType $penaltyAmount
     * @param \Gek\UyumBahce\StructType\PaymentDueDateType $paymentDueDate
     * @param \Gek\UyumBahce\StructType\PeriodType $settlementPeriod
     */
    public function __construct(\Gek\UyumBahce\StructType\NoteType $note = null, \Gek\UyumBahce\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null, \Gek\UyumBahce\StructType\AmountType $amount = null, \Gek\UyumBahce\StructType\PenaltyAmountType $penaltyAmount = null, \Gek\UyumBahce\StructType\PaymentDueDateType $paymentDueDate = null, \Gek\UyumBahce\StructType\PeriodType $settlementPeriod = null)
    {
        $this
            ->setNote($note)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setAmount($amount)
            ->setPenaltyAmount($penaltyAmount)
            ->setPaymentDueDate($paymentDueDate)
            ->setSettlementPeriod($settlementPeriod);
    }
    /**
     * Get Note value
     * @return \Gek\UyumBahce\StructType\NoteType|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param \Gek\UyumBahce\StructType\NoteType $note
     * @return \Gek\UyumBahce\StructType\PaymentTermsType
     */
    public function setNote(\Gek\UyumBahce\StructType\NoteType $note = null)
    {
        $this->Note = $note;
        return $this;
    }
    /**
     * Get PenaltySurchargePercent value
     * @return \Gek\UyumBahce\StructType\PenaltySurchargePercentType|null
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }
    /**
     * Set PenaltySurchargePercent value
     * @param \Gek\UyumBahce\StructType\PenaltySurchargePercentType $penaltySurchargePercent
     * @return \Gek\UyumBahce\StructType\PaymentTermsType
     */
    public function setPenaltySurchargePercent(\Gek\UyumBahce\StructType\PenaltySurchargePercentType $penaltySurchargePercent = null)
    {
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Gek\UyumBahce\StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Gek\UyumBahce\StructType\AmountType $amount
     * @return \Gek\UyumBahce\StructType\PaymentTermsType
     */
    public function setAmount(\Gek\UyumBahce\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return \Gek\UyumBahce\StructType\PenaltyAmountType|null
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * Set PenaltyAmount value
     * @param \Gek\UyumBahce\StructType\PenaltyAmountType $penaltyAmount
     * @return \Gek\UyumBahce\StructType\PaymentTermsType
     */
    public function setPenaltyAmount(\Gek\UyumBahce\StructType\PenaltyAmountType $penaltyAmount = null)
    {
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return \Gek\UyumBahce\StructType\PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param \Gek\UyumBahce\StructType\PaymentDueDateType $paymentDueDate
     * @return \Gek\UyumBahce\StructType\PaymentTermsType
     */
    public function setPaymentDueDate(\Gek\UyumBahce\StructType\PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get SettlementPeriod value
     * @return \Gek\UyumBahce\StructType\PeriodType|null
     */
    public function getSettlementPeriod()
    {
        return $this->SettlementPeriod;
    }
    /**
     * Set SettlementPeriod value
     * @param \Gek\UyumBahce\StructType\PeriodType $settlementPeriod
     * @return \Gek\UyumBahce\StructType\PaymentTermsType
     */
    public function setSettlementPeriod(\Gek\UyumBahce\StructType\PeriodType $settlementPeriod = null)
    {
        $this->SettlementPeriod = $settlementPeriod;
        return $this;
    }
}
