<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The WebsiteURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:WebsiteURI
     * @var \Gek\UyumBahce\StructType\WebsiteURIType
     */
    public $WebsiteURI;
    /**
     * The EndpointID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:EndpointID
     * @var \Gek\UyumBahce\StructType\EndpointIDType
     */
    public $EndpointID;
    /**
     * The IndustryClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IndustryClassificationCode
     * @var \Gek\UyumBahce\StructType\IndustryClassificationCodeType
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyIdentificationType[]
     */
    public $PartyIdentification;
    /**
     * The PartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyNameType
     */
    public $PartyName;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\AddressType
     */
    public $PostalAddress;
    /**
     * The PhysicalLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\LocationType
     */
    public $PhysicalLocation;
    /**
     * The PartyTaxScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyTaxSchemeType
     */
    public $PartyTaxScheme;
    /**
     * The PartyLegalEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyLegalEntityType[]
     */
    public $PartyLegalEntity;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ContactType
     */
    public $Contact;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PersonType
     */
    public $Person;
    /**
     * The AgentParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyType
     */
    public $AgentParty;
    /**
     * Constructor method for PartyType
     * @uses PartyType::setWebsiteURI()
     * @uses PartyType::setEndpointID()
     * @uses PartyType::setIndustryClassificationCode()
     * @uses PartyType::setPartyIdentification()
     * @uses PartyType::setPartyName()
     * @uses PartyType::setPostalAddress()
     * @uses PartyType::setPhysicalLocation()
     * @uses PartyType::setPartyTaxScheme()
     * @uses PartyType::setPartyLegalEntity()
     * @uses PartyType::setContact()
     * @uses PartyType::setPerson()
     * @uses PartyType::setAgentParty()
     * @param \Gek\UyumBahce\StructType\WebsiteURIType $websiteURI
     * @param \Gek\UyumBahce\StructType\EndpointIDType $endpointID
     * @param \Gek\UyumBahce\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @param \Gek\UyumBahce\StructType\PartyIdentificationType[] $partyIdentification
     * @param \Gek\UyumBahce\StructType\PartyNameType $partyName
     * @param \Gek\UyumBahce\StructType\AddressType $postalAddress
     * @param \Gek\UyumBahce\StructType\LocationType $physicalLocation
     * @param \Gek\UyumBahce\StructType\PartyTaxSchemeType $partyTaxScheme
     * @param \Gek\UyumBahce\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @param \Gek\UyumBahce\StructType\ContactType $contact
     * @param \Gek\UyumBahce\StructType\PersonType $person
     * @param \Gek\UyumBahce\StructType\PartyType $agentParty
     */
    public function __construct(\Gek\UyumBahce\StructType\WebsiteURIType $websiteURI = null, \Gek\UyumBahce\StructType\EndpointIDType $endpointID = null, \Gek\UyumBahce\StructType\IndustryClassificationCodeType $industryClassificationCode = null, array $partyIdentification = array(), \Gek\UyumBahce\StructType\PartyNameType $partyName = null, \Gek\UyumBahce\StructType\AddressType $postalAddress = null, \Gek\UyumBahce\StructType\LocationType $physicalLocation = null, \Gek\UyumBahce\StructType\PartyTaxSchemeType $partyTaxScheme = null, array $partyLegalEntity = array(), \Gek\UyumBahce\StructType\ContactType $contact = null, \Gek\UyumBahce\StructType\PersonType $person = null, \Gek\UyumBahce\StructType\PartyType $agentParty = null)
    {
        $this
            ->setWebsiteURI($websiteURI)
            ->setEndpointID($endpointID)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentification($partyIdentification)
            ->setPartyName($partyName)
            ->setPostalAddress($postalAddress)
            ->setPhysicalLocation($physicalLocation)
            ->setPartyTaxScheme($partyTaxScheme)
            ->setPartyLegalEntity($partyLegalEntity)
            ->setContact($contact)
            ->setPerson($person)
            ->setAgentParty($agentParty);
    }
    /**
     * Get WebsiteURI value
     * @return \Gek\UyumBahce\StructType\WebsiteURIType|null
     */
    public function getWebsiteURI()
    {
        return $this->WebsiteURI;
    }
    /**
     * Set WebsiteURI value
     * @param \Gek\UyumBahce\StructType\WebsiteURIType $websiteURI
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setWebsiteURI(\Gek\UyumBahce\StructType\WebsiteURIType $websiteURI = null)
    {
        $this->WebsiteURI = $websiteURI;
        return $this;
    }
    /**
     * Get EndpointID value
     * @return \Gek\UyumBahce\StructType\EndpointIDType|null
     */
    public function getEndpointID()
    {
        return $this->EndpointID;
    }
    /**
     * Set EndpointID value
     * @param \Gek\UyumBahce\StructType\EndpointIDType $endpointID
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setEndpointID(\Gek\UyumBahce\StructType\EndpointIDType $endpointID = null)
    {
        $this->EndpointID = $endpointID;
        return $this;
    }
    /**
     * Get IndustryClassificationCode value
     * @return \Gek\UyumBahce\StructType\IndustryClassificationCodeType|null
     */
    public function getIndustryClassificationCode()
    {
        return $this->IndustryClassificationCode;
    }
    /**
     * Set IndustryClassificationCode value
     * @param \Gek\UyumBahce\StructType\IndustryClassificationCodeType $industryClassificationCode
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setIndustryClassificationCode(\Gek\UyumBahce\StructType\IndustryClassificationCodeType $industryClassificationCode = null)
    {
        $this->IndustryClassificationCode = $industryClassificationCode;
        return $this;
    }
    /**
     * Get PartyIdentification value
     * @return \Gek\UyumBahce\StructType\PartyIdentificationType[]|null
     */
    public function getPartyIdentification()
    {
        return $this->PartyIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyIdentificationItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyIdentificationItem instanceof \Gek\UyumBahce\StructType\PartyIdentificationType) {
                $invalidValues[] = is_object($partyTypePartyIdentificationItem) ? get_class($partyTypePartyIdentificationItem) : sprintf('%s(%s)', gettype($partyTypePartyIdentificationItem), var_export($partyTypePartyIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyIdentification property can only contain items of type \Gek\UyumBahce\StructType\PartyIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PartyIdentificationType[] $partyIdentification
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setPartyIdentification(array $partyIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($partyIdentificationArrayErrorMessage = self::validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification($partyIdentification))) {
            throw new \InvalidArgumentException($partyIdentificationArrayErrorMessage, __LINE__);
        }
        $this->PartyIdentification = $partyIdentification;
        return $this;
    }
    /**
     * Add item to PartyIdentification value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PartyIdentificationType $item
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function addToPartyIdentification(\Gek\UyumBahce\StructType\PartyIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\PartyIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The PartyIdentification property can only contain items of type \Gek\UyumBahce\StructType\PartyIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyIdentification[] = $item;
        return $this;
    }
    /**
     * Get PartyName value
     * @return \Gek\UyumBahce\StructType\PartyNameType|null
     */
    public function getPartyName()
    {
        return $this->PartyName;
    }
    /**
     * Set PartyName value
     * @param \Gek\UyumBahce\StructType\PartyNameType $partyName
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setPartyName(\Gek\UyumBahce\StructType\PartyNameType $partyName = null)
    {
        $this->PartyName = $partyName;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \Gek\UyumBahce\StructType\AddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \Gek\UyumBahce\StructType\AddressType $postalAddress
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setPostalAddress(\Gek\UyumBahce\StructType\AddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get PhysicalLocation value
     * @return \Gek\UyumBahce\StructType\LocationType|null
     */
    public function getPhysicalLocation()
    {
        return $this->PhysicalLocation;
    }
    /**
     * Set PhysicalLocation value
     * @param \Gek\UyumBahce\StructType\LocationType $physicalLocation
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setPhysicalLocation(\Gek\UyumBahce\StructType\LocationType $physicalLocation = null)
    {
        $this->PhysicalLocation = $physicalLocation;
        return $this;
    }
    /**
     * Get PartyTaxScheme value
     * @return \Gek\UyumBahce\StructType\PartyTaxSchemeType|null
     */
    public function getPartyTaxScheme()
    {
        return $this->PartyTaxScheme;
    }
    /**
     * Set PartyTaxScheme value
     * @param \Gek\UyumBahce\StructType\PartyTaxSchemeType $partyTaxScheme
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setPartyTaxScheme(\Gek\UyumBahce\StructType\PartyTaxSchemeType $partyTaxScheme = null)
    {
        $this->PartyTaxScheme = $partyTaxScheme;
        return $this;
    }
    /**
     * Get PartyLegalEntity value
     * @return \Gek\UyumBahce\StructType\PartyLegalEntityType[]|null
     */
    public function getPartyLegalEntity()
    {
        return $this->PartyLegalEntity;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyLegalEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyLegalEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyLegalEntityItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyLegalEntityItem instanceof \Gek\UyumBahce\StructType\PartyLegalEntityType) {
                $invalidValues[] = is_object($partyTypePartyLegalEntityItem) ? get_class($partyTypePartyLegalEntityItem) : sprintf('%s(%s)', gettype($partyTypePartyLegalEntityItem), var_export($partyTypePartyLegalEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyLegalEntity property can only contain items of type \Gek\UyumBahce\StructType\PartyLegalEntityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PartyLegalEntityType[] $partyLegalEntity
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setPartyLegalEntity(array $partyLegalEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($partyLegalEntityArrayErrorMessage = self::validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity($partyLegalEntity))) {
            throw new \InvalidArgumentException($partyLegalEntityArrayErrorMessage, __LINE__);
        }
        $this->PartyLegalEntity = $partyLegalEntity;
        return $this;
    }
    /**
     * Add item to PartyLegalEntity value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PartyLegalEntityType $item
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function addToPartyLegalEntity(\Gek\UyumBahce\StructType\PartyLegalEntityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\PartyLegalEntityType) {
            throw new \InvalidArgumentException(sprintf('The PartyLegalEntity property can only contain items of type \Gek\UyumBahce\StructType\PartyLegalEntityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyLegalEntity[] = $item;
        return $this;
    }
    /**
     * Get Contact value
     * @return \Gek\UyumBahce\StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \Gek\UyumBahce\StructType\ContactType $contact
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setContact(\Gek\UyumBahce\StructType\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Person value
     * @return \Gek\UyumBahce\StructType\PersonType|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \Gek\UyumBahce\StructType\PersonType $person
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setPerson(\Gek\UyumBahce\StructType\PersonType $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get AgentParty value
     * @return \Gek\UyumBahce\StructType\PartyType|null
     */
    public function getAgentParty()
    {
        return $this->AgentParty;
    }
    /**
     * Set AgentParty value
     * @param \Gek\UyumBahce\StructType\PartyType $agentParty
     * @return \Gek\UyumBahce\StructType\PartyType
     */
    public function setAgentParty(\Gek\UyumBahce\StructType\PartyType $agentParty = null)
    {
        $this->AgentParty = $agentParty;
        return $this;
    }
}
