<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageType StructType
 * @subpackage Structs
 */
class PackageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Quantity
     * @var \Gek\UyumBahce\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ReturnableMaterialIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ReturnableMaterialIndicator
     * @var \Gek\UyumBahce\StructType\ReturnableMaterialIndicatorType
     */
    public $ReturnableMaterialIndicator;
    /**
     * The PackageLevelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PackageLevelCode
     * @var \Gek\UyumBahce\StructType\PackageLevelCodeType
     */
    public $PackageLevelCode;
    /**
     * The PackagingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PackagingTypeCode
     * @var \Gek\UyumBahce\StructType\PackagingTypeCodeType
     */
    public $PackagingTypeCode;
    /**
     * The PackingMaterial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:PackingMaterial
     * @var \Gek\UyumBahce\StructType\PackingMaterialType[]
     */
    public $PackingMaterial;
    /**
     * The ContainedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PackageType[]
     */
    public $ContainedPackage;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for PackageType
     * @uses PackageType::setID()
     * @uses PackageType::setQuantity()
     * @uses PackageType::setReturnableMaterialIndicator()
     * @uses PackageType::setPackageLevelCode()
     * @uses PackageType::setPackagingTypeCode()
     * @uses PackageType::setPackingMaterial()
     * @uses PackageType::setContainedPackage()
     * @uses PackageType::setGoodsItem()
     * @uses PackageType::setMeasurementDimension()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\QuantityType $quantity
     * @param \Gek\UyumBahce\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @param \Gek\UyumBahce\StructType\PackageLevelCodeType $packageLevelCode
     * @param \Gek\UyumBahce\StructType\PackagingTypeCodeType $packagingTypeCode
     * @param \Gek\UyumBahce\StructType\PackingMaterialType[] $packingMaterial
     * @param \Gek\UyumBahce\StructType\PackageType[] $containedPackage
     * @param \Gek\UyumBahce\StructType\GoodsItemType[] $goodsItem
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\QuantityType $quantity = null, \Gek\UyumBahce\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null, \Gek\UyumBahce\StructType\PackageLevelCodeType $packageLevelCode = null, \Gek\UyumBahce\StructType\PackagingTypeCodeType $packagingTypeCode = null, array $packingMaterial = array(), array $containedPackage = array(), array $goodsItem = array(), array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setReturnableMaterialIndicator($returnableMaterialIndicator)
            ->setPackageLevelCode($packageLevelCode)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setPackingMaterial($packingMaterial)
            ->setContainedPackage($containedPackage)
            ->setGoodsItem($goodsItem)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Gek\UyumBahce\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Gek\UyumBahce\StructType\QuantityType $quantity
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setQuantity(\Gek\UyumBahce\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReturnableMaterialIndicator value
     * @return \Gek\UyumBahce\StructType\ReturnableMaterialIndicatorType|null
     */
    public function getReturnableMaterialIndicator()
    {
        return $this->ReturnableMaterialIndicator;
    }
    /**
     * Set ReturnableMaterialIndicator value
     * @param \Gek\UyumBahce\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setReturnableMaterialIndicator(\Gek\UyumBahce\StructType\ReturnableMaterialIndicatorType $returnableMaterialIndicator = null)
    {
        $this->ReturnableMaterialIndicator = $returnableMaterialIndicator;
        return $this;
    }
    /**
     * Get PackageLevelCode value
     * @return \Gek\UyumBahce\StructType\PackageLevelCodeType|null
     */
    public function getPackageLevelCode()
    {
        return $this->PackageLevelCode;
    }
    /**
     * Set PackageLevelCode value
     * @param \Gek\UyumBahce\StructType\PackageLevelCodeType $packageLevelCode
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setPackageLevelCode(\Gek\UyumBahce\StructType\PackageLevelCodeType $packageLevelCode = null)
    {
        $this->PackageLevelCode = $packageLevelCode;
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * @return \Gek\UyumBahce\StructType\PackagingTypeCodeType|null
     */
    public function getPackagingTypeCode()
    {
        return $this->PackagingTypeCode;
    }
    /**
     * Set PackagingTypeCode value
     * @param \Gek\UyumBahce\StructType\PackagingTypeCodeType $packagingTypeCode
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setPackagingTypeCode(\Gek\UyumBahce\StructType\PackagingTypeCodeType $packagingTypeCode = null)
    {
        $this->PackagingTypeCode = $packagingTypeCode;
        return $this;
    }
    /**
     * Get PackingMaterial value
     * @return \Gek\UyumBahce\StructType\PackingMaterialType[]|null
     */
    public function getPackingMaterial()
    {
        return $this->PackingMaterial;
    }
    /**
     * This method is responsible for validating the values passed to the setPackingMaterial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackingMaterial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackingMaterialForArrayConstraintsFromSetPackingMaterial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypePackingMaterialItem) {
            // validation for constraint: itemType
            if (!$packageTypePackingMaterialItem instanceof \Gek\UyumBahce\StructType\PackingMaterialType) {
                $invalidValues[] = is_object($packageTypePackingMaterialItem) ? get_class($packageTypePackingMaterialItem) : sprintf('%s(%s)', gettype($packageTypePackingMaterialItem), var_export($packageTypePackingMaterialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackingMaterial property can only contain items of type \Gek\UyumBahce\StructType\PackingMaterialType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PackingMaterialType[] $packingMaterial
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setPackingMaterial(array $packingMaterial = array())
    {
        // validation for constraint: array
        if ('' !== ($packingMaterialArrayErrorMessage = self::validatePackingMaterialForArrayConstraintsFromSetPackingMaterial($packingMaterial))) {
            throw new \InvalidArgumentException($packingMaterialArrayErrorMessage, __LINE__);
        }
        $this->PackingMaterial = $packingMaterial;
        return $this;
    }
    /**
     * Add item to PackingMaterial value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PackingMaterialType $item
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function addToPackingMaterial(\Gek\UyumBahce\StructType\PackingMaterialType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\PackingMaterialType) {
            throw new \InvalidArgumentException(sprintf('The PackingMaterial property can only contain items of type \Gek\UyumBahce\StructType\PackingMaterialType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackingMaterial[] = $item;
        return $this;
    }
    /**
     * Get ContainedPackage value
     * @return \Gek\UyumBahce\StructType\PackageType[]|null
     */
    public function getContainedPackage()
    {
        return $this->ContainedPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setContainedPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContainedPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContainedPackageForArrayConstraintsFromSetContainedPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeContainedPackageItem) {
            // validation for constraint: itemType
            if (!$packageTypeContainedPackageItem instanceof \Gek\UyumBahce\StructType\PackageType) {
                $invalidValues[] = is_object($packageTypeContainedPackageItem) ? get_class($packageTypeContainedPackageItem) : sprintf('%s(%s)', gettype($packageTypeContainedPackageItem), var_export($packageTypeContainedPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContainedPackage property can only contain items of type \Gek\UyumBahce\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PackageType[] $containedPackage
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setContainedPackage(array $containedPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($containedPackageArrayErrorMessage = self::validateContainedPackageForArrayConstraintsFromSetContainedPackage($containedPackage))) {
            throw new \InvalidArgumentException($containedPackageArrayErrorMessage, __LINE__);
        }
        $this->ContainedPackage = $containedPackage;
        return $this;
    }
    /**
     * Add item to ContainedPackage value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PackageType $item
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function addToContainedPackage(\Gek\UyumBahce\StructType\PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\PackageType) {
            throw new \InvalidArgumentException(sprintf('The ContainedPackage property can only contain items of type \Gek\UyumBahce\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContainedPackage[] = $item;
        return $this;
    }
    /**
     * Get GoodsItem value
     * @return \Gek\UyumBahce\StructType\GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$packageTypeGoodsItemItem instanceof \Gek\UyumBahce\StructType\GoodsItemType) {
                $invalidValues[] = is_object($packageTypeGoodsItemItem) ? get_class($packageTypeGoodsItemItem) : sprintf('%s(%s)', gettype($packageTypeGoodsItemItem), var_export($packageTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahce\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\GoodsItemType[] $goodsItem
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new \InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }
    /**
     * Add item to GoodsItem value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\GoodsItemType $item
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function addToGoodsItem(\Gek\UyumBahce\StructType\GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\GoodsItemType) {
            throw new \InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahce\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Gek\UyumBahce\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$packageTypeMeasurementDimensionItem instanceof \Gek\UyumBahce\StructType\DimensionType) {
                $invalidValues[] = is_object($packageTypeMeasurementDimensionItem) ? get_class($packageTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($packageTypeMeasurementDimensionItem), var_export($packageTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType $item
     * @return \Gek\UyumBahce\StructType\PackageType
     */
    public function addToMeasurementDimension(\Gek\UyumBahce\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
