<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PGPDataType StructType
 * @subpackage Structs
 */
class PGPDataType extends AbstractStructBase
{
    /**
     * The PGPKeyID
     * Meta information extracted from the WSDL
     * - choice: PGPKeyID | PGPKeyPacket |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $PGPKeyID;
    /**
     * The PGPKeyPacket
     * Meta information extracted from the WSDL
     * - choice: PGPKeyID | PGPKeyPacket |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $PGPKeyPacket;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PGPDataType
     * @uses PGPDataType::setPGPKeyID()
     * @uses PGPDataType::setPGPKeyPacket()
     * @uses PGPDataType::setAny()
     * @param string[] $pGPKeyID
     * @param string[] $pGPKeyPacket
     * @param \DOMDocument $any
     */
    public function __construct(array $pGPKeyID = array(), array $pGPKeyPacket = array(), \DOMDocument $any = null)
    {
        $this
            ->setPGPKeyID($pGPKeyID)
            ->setPGPKeyPacket($pGPKeyPacket)
            ->setAny($any);
    }
    /**
     * Get PGPKeyID value
     * @return string[]|null
     */
    public function getPGPKeyID()
    {
        return isset($this->PGPKeyID) ? $this->PGPKeyID : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPGPKeyID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPKeyID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePGPKeyIDForArrayConstraintsFromSetPGPKeyID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pGPDataTypePGPKeyIDItem) {
            // validation for constraint: itemType
            if (!is_string($pGPDataTypePGPKeyIDItem)) {
                $invalidValues[] = is_object($pGPDataTypePGPKeyIDItem) ? get_class($pGPDataTypePGPKeyIDItem) : sprintf('%s(%s)', gettype($pGPDataTypePGPKeyIDItem), var_export($pGPDataTypePGPKeyIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PGPKeyID property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPGPKeyID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPKeyID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePGPKeyIDForChoiceConstraintsFromSetPGPKeyID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PGPKeyPacket',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PGPKeyID can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPKeyID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PGPKeyID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $pGPKeyID
     * @return \Gek\UyumBahce\StructType\PGPDataType
     */
    public function setPGPKeyID(array $pGPKeyID = array())
    {
        // validation for constraint: array
        if ('' !== ($pGPKeyIDArrayErrorMessage = self::validatePGPKeyIDForArrayConstraintsFromSetPGPKeyID($pGPKeyID))) {
            throw new \InvalidArgumentException($pGPKeyIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(PGPKeyID, PGPKeyPacket, )
        if ('' !== ($pGPKeyIDChoiceErrorMessage = self::validatePGPKeyIDForChoiceConstraintsFromSetPGPKeyID($pGPKeyID))) {
            throw new \InvalidArgumentException($pGPKeyIDChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($pGPKeyID) && count($pGPKeyID) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($pGPKeyID)), __LINE__);
        }
        if (is_null($pGPKeyID) || (is_array($pGPKeyID) && empty($pGPKeyID))) {
            unset($this->PGPKeyID);
        } else {
            $this->PGPKeyID = $pGPKeyID;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPGPKeyID method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPGPKeyID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPGPKeyID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PGPKeyPacket',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PGPKeyID can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPKeyID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PGPKeyID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Gek\UyumBahce\StructType\PGPDataType
     */
    public function addToPGPKeyID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PGPKeyID property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(PGPKeyID, PGPKeyPacket, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPGPKeyID($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->PGPKeyID) && count($this->PGPKeyID) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->PGPKeyID)), __LINE__);
        }
        $this->PGPKeyID[] = $item;
        return $this;
    }
    /**
     * Get PGPKeyPacket value
     * @return string[]|null
     */
    public function getPGPKeyPacket()
    {
        return isset($this->PGPKeyPacket) ? $this->PGPKeyPacket : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPGPKeyPacket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPKeyPacket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePGPKeyPacketForArrayConstraintsFromSetPGPKeyPacket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pGPDataTypePGPKeyPacketItem) {
            // validation for constraint: itemType
            if (!is_string($pGPDataTypePGPKeyPacketItem)) {
                $invalidValues[] = is_object($pGPDataTypePGPKeyPacketItem) ? get_class($pGPDataTypePGPKeyPacketItem) : sprintf('%s(%s)', gettype($pGPDataTypePGPKeyPacketItem), var_export($pGPDataTypePGPKeyPacketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PGPKeyPacket property can only contain items of type base64Binary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPGPKeyPacket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPKeyPacket method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePGPKeyPacketForChoiceConstraintsFromSetPGPKeyPacket($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PGPKeyID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PGPKeyPacket can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPKeyPacket, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PGPKeyPacket value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $pGPKeyPacket
     * @return \Gek\UyumBahce\StructType\PGPDataType
     */
    public function setPGPKeyPacket(array $pGPKeyPacket = array())
    {
        // validation for constraint: array
        if ('' !== ($pGPKeyPacketArrayErrorMessage = self::validatePGPKeyPacketForArrayConstraintsFromSetPGPKeyPacket($pGPKeyPacket))) {
            throw new \InvalidArgumentException($pGPKeyPacketArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(PGPKeyID, PGPKeyPacket, )
        if ('' !== ($pGPKeyPacketChoiceErrorMessage = self::validatePGPKeyPacketForChoiceConstraintsFromSetPGPKeyPacket($pGPKeyPacket))) {
            throw new \InvalidArgumentException($pGPKeyPacketChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($pGPKeyPacket) && count($pGPKeyPacket) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($pGPKeyPacket)), __LINE__);
        }
        if (is_null($pGPKeyPacket) || (is_array($pGPKeyPacket) && empty($pGPKeyPacket))) {
            unset($this->PGPKeyPacket);
        } else {
            $this->PGPKeyPacket = $pGPKeyPacket;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPGPKeyPacket method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPGPKeyPacket method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPGPKeyPacket($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PGPKeyID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PGPKeyPacket can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPKeyPacket, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PGPKeyPacket value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Gek\UyumBahce\StructType\PGPDataType
     */
    public function addToPGPKeyPacket($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PGPKeyPacket property can only contain items of type base64Binary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(PGPKeyID, PGPKeyPacket, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPGPKeyPacket($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->PGPKeyPacket) && count($this->PGPKeyPacket) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->PGPKeyPacket)), __LINE__);
        }
        $this->PGPKeyPacket[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \Gek\UyumBahce\StructType\PGPDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
