<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailInfo StructType
 * @subpackage Structs
 */
class OrderDetailInfo extends AbstractStructBase
{
    /**
     * The OrderDetailId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderDetailId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The WhouseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WhouseId;
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The ItemAttr1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemAttr1Id;
    /**
     * The ItemAttr2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemAttr2Id;
    /**
     * The ItemAttr3Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemAttr3Id;
    /**
     * The QualityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QualityId;
    /**
     * The LotId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LotId;
    /**
     * The PackageTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PackageTypeId;
    /**
     * The OrderMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderMId;
    /**
     * The UnitId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitId;
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The OrderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNo;
    /**
     * Constructor method for OrderDetailInfo
     * @uses OrderDetailInfo::setOrderDetailId()
     * @uses OrderDetailInfo::setItemId()
     * @uses OrderDetailInfo::setQty()
     * @uses OrderDetailInfo::setWhouseId()
     * @uses OrderDetailInfo::setArrivalDate()
     * @uses OrderDetailInfo::setItemAttr1Id()
     * @uses OrderDetailInfo::setItemAttr2Id()
     * @uses OrderDetailInfo::setItemAttr3Id()
     * @uses OrderDetailInfo::setQualityId()
     * @uses OrderDetailInfo::setLotId()
     * @uses OrderDetailInfo::setPackageTypeId()
     * @uses OrderDetailInfo::setOrderMId()
     * @uses OrderDetailInfo::setUnitId()
     * @uses OrderDetailInfo::setItemCode()
     * @uses OrderDetailInfo::setItemName()
     * @uses OrderDetailInfo::setOrderNo()
     * @param int $orderDetailId
     * @param int $itemId
     * @param float $qty
     * @param int $whouseId
     * @param string|GekDateTime $arrivalDate
     * @param int $itemAttr1Id
     * @param int $itemAttr2Id
     * @param int $itemAttr3Id
     * @param int $qualityId
     * @param int $lotId
     * @param int $packageTypeId
     * @param int $orderMId
     * @param int $unitId
     * @param string $itemCode
     * @param string $itemName
     * @param string $orderNo
     */
    public function __construct($orderDetailId = null, $itemId = null, $qty = null, $whouseId = null, $arrivalDate = null, $itemAttr1Id = null, $itemAttr2Id = null, $itemAttr3Id = null, $qualityId = null, $lotId = null, $packageTypeId = null, $orderMId = null, $unitId = null, $itemCode = null, $itemName = null, $orderNo = null)
    {
        $this
            ->setOrderDetailId($orderDetailId)
            ->setItemId($itemId)
            ->setQty($qty)
            ->setWhouseId($whouseId)
            ->setArrivalDate($arrivalDate)
            ->setItemAttr1Id($itemAttr1Id)
            ->setItemAttr2Id($itemAttr2Id)
            ->setItemAttr3Id($itemAttr3Id)
            ->setQualityId($qualityId)
            ->setLotId($lotId)
            ->setPackageTypeId($packageTypeId)
            ->setOrderMId($orderMId)
            ->setUnitId($unitId)
            ->setItemCode($itemCode)
            ->setItemName($itemName)
            ->setOrderNo($orderNo);
    }
    /**
     * Get OrderDetailId value
     * @return int
     */
    public function getOrderDetailId()
    {
        return $this->OrderDetailId;
    }
    /**
     * Set OrderDetailId value
     * @param int $orderDetailId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setOrderDetailId($orderDetailId = null)
    {
        // validation for constraint: int
        if (!is_null($orderDetailId) && !(is_int($orderDetailId) || ctype_digit($orderDetailId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderDetailId, true), gettype($orderDetailId)), __LINE__);
        }
        $this->OrderDetailId = $orderDetailId;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get WhouseId value
     * @return int
     */
    public function getWhouseId()
    {
        return $this->WhouseId;
    }
    /**
     * Set WhouseId value
     * @param int $whouseId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setWhouseId($whouseId = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId) && !(is_int($whouseId) || ctype_digit($whouseId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId, true), gettype($whouseId)), __LINE__);
        }
        $this->WhouseId = $whouseId;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate) && !($arrivalDate instanceof GekDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        if($arrivalDate instanceof GekDateTime){
            $arrivalDate = $arrivalDate->toServiceString();
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get ItemAttr1Id value
     * @return int
     */
    public function getItemAttr1Id()
    {
        return $this->ItemAttr1Id;
    }
    /**
     * Set ItemAttr1Id value
     * @param int $itemAttr1Id
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setItemAttr1Id($itemAttr1Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttr1Id) && !(is_int($itemAttr1Id) || ctype_digit($itemAttr1Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttr1Id, true), gettype($itemAttr1Id)), __LINE__);
        }
        $this->ItemAttr1Id = $itemAttr1Id;
        return $this;
    }
    /**
     * Get ItemAttr2Id value
     * @return int
     */
    public function getItemAttr2Id()
    {
        return $this->ItemAttr2Id;
    }
    /**
     * Set ItemAttr2Id value
     * @param int $itemAttr2Id
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setItemAttr2Id($itemAttr2Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttr2Id) && !(is_int($itemAttr2Id) || ctype_digit($itemAttr2Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttr2Id, true), gettype($itemAttr2Id)), __LINE__);
        }
        $this->ItemAttr2Id = $itemAttr2Id;
        return $this;
    }
    /**
     * Get ItemAttr3Id value
     * @return int
     */
    public function getItemAttr3Id()
    {
        return $this->ItemAttr3Id;
    }
    /**
     * Set ItemAttr3Id value
     * @param int $itemAttr3Id
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setItemAttr3Id($itemAttr3Id = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttr3Id) && !(is_int($itemAttr3Id) || ctype_digit($itemAttr3Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttr3Id, true), gettype($itemAttr3Id)), __LINE__);
        }
        $this->ItemAttr3Id = $itemAttr3Id;
        return $this;
    }
    /**
     * Get QualityId value
     * @return int
     */
    public function getQualityId()
    {
        return $this->QualityId;
    }
    /**
     * Set QualityId value
     * @param int $qualityId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setQualityId($qualityId = null)
    {
        // validation for constraint: int
        if (!is_null($qualityId) && !(is_int($qualityId) || ctype_digit($qualityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qualityId, true), gettype($qualityId)), __LINE__);
        }
        $this->QualityId = $qualityId;
        return $this;
    }
    /**
     * Get LotId value
     * @return int
     */
    public function getLotId()
    {
        return $this->LotId;
    }
    /**
     * Set LotId value
     * @param int $lotId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setLotId($lotId = null)
    {
        // validation for constraint: int
        if (!is_null($lotId) && !(is_int($lotId) || ctype_digit($lotId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lotId, true), gettype($lotId)), __LINE__);
        }
        $this->LotId = $lotId;
        return $this;
    }
    /**
     * Get PackageTypeId value
     * @return int
     */
    public function getPackageTypeId()
    {
        return $this->PackageTypeId;
    }
    /**
     * Set PackageTypeId value
     * @param int $packageTypeId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setPackageTypeId($packageTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($packageTypeId) && !(is_int($packageTypeId) || ctype_digit($packageTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageTypeId, true), gettype($packageTypeId)), __LINE__);
        }
        $this->PackageTypeId = $packageTypeId;
        return $this;
    }
    /**
     * Get OrderMId value
     * @return int
     */
    public function getOrderMId()
    {
        return $this->OrderMId;
    }
    /**
     * Set OrderMId value
     * @param int $orderMId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setOrderMId($orderMId = null)
    {
        // validation for constraint: int
        if (!is_null($orderMId) && !(is_int($orderMId) || ctype_digit($orderMId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderMId, true), gettype($orderMId)), __LINE__);
        }
        $this->OrderMId = $orderMId;
        return $this;
    }
    /**
     * Get UnitId value
     * @return int
     */
    public function getUnitId()
    {
        return $this->UnitId;
    }
    /**
     * Set UnitId value
     * @param int $unitId
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setUnitId($unitId = null)
    {
        // validation for constraint: int
        if (!is_null($unitId) && !(is_int($unitId) || ctype_digit($unitId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitId, true), gettype($unitId)), __LINE__);
        }
        $this->UnitId = $unitId;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }
    /**
     * Set ItemName value
     * @param string $itemName
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }
    /**
     * Get OrderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->OrderNo;
    }
    /**
     * Set OrderNo value
     * @param string $orderNo
     * @return \Gek\UyumBahce\StructType\OrderDetailInfo
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNo, true), gettype($orderNo)), __LINE__);
        }
        $this->OrderNo = $orderNo;
        return $this;
    }
}
