<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDef StructType
 * @subpackage Structs
 */
class OrderDef extends TransactionalMasterFields
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EntityId;
    /**
     * The OrderStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OrderStatus;
    /**
     * The IsApproveByMaster
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsApproveByMaster;
    /**
     * The FormContractMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FormContractMId;
    /**
     * The EntityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityCode;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\ArrayType\ArrayOfOrderDetailDef
     */
    public $Details;
    /**
     * Constructor method for OrderDef
     * @uses OrderDef::setEntityId()
     * @uses OrderDef::setOrderStatus()
     * @uses OrderDef::setIsApproveByMaster()
     * @uses OrderDef::setFormContractMId()
     * @uses OrderDef::setEntityCode()
     * @uses OrderDef::setDetails()
     * @param int $entityId
     * @param string $orderStatus
     * @param bool $isApproveByMaster
     * @param int $formContractMId
     * @param string $entityCode
     * @param \Gek\UyumBahce\ArrayType\ArrayOfOrderDetailDef $details
     */
    public function __construct($entityId = null, $orderStatus = null, $isApproveByMaster = null, $formContractMId = null, $entityCode = null, \Gek\UyumBahce\ArrayType\ArrayOfOrderDetailDef $details = null)
    {
        $this
            ->setEntityId($entityId)
            ->setOrderStatus($orderStatus)
            ->setIsApproveByMaster($isApproveByMaster)
            ->setFormContractMId($formContractMId)
            ->setEntityCode($entityCode)
            ->setDetails($details);
    }
    /**
     * Get EntityId value
     * @return int
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \Gek\UyumBahce\StructType\OrderDef
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get OrderStatus value
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @uses \Gek\UyumBahce\EnumType\OrderStatus::valueIsValid()
     * @uses \Gek\UyumBahce\EnumType\OrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \Gek\UyumBahce\StructType\OrderDef
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Gek\UyumBahce\EnumType\OrderStatus::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\OrderStatus', is_array($orderStatus) ? implode(', ', $orderStatus) : var_export($orderStatus, true), implode(', ', \Gek\UyumBahce\EnumType\OrderStatus::getValidValues())), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get IsApproveByMaster value
     * @return bool
     */
    public function getIsApproveByMaster()
    {
        return $this->IsApproveByMaster;
    }
    /**
     * Set IsApproveByMaster value
     * @param bool $isApproveByMaster
     * @return \Gek\UyumBahce\StructType\OrderDef
     */
    public function setIsApproveByMaster($isApproveByMaster = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproveByMaster) && !is_bool($isApproveByMaster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApproveByMaster, true), gettype($isApproveByMaster)), __LINE__);
        }
        $this->IsApproveByMaster = $isApproveByMaster;
        return $this;
    }
    /**
     * Get FormContractMId value
     * @return int
     */
    public function getFormContractMId()
    {
        return $this->FormContractMId;
    }
    /**
     * Set FormContractMId value
     * @param int $formContractMId
     * @return \Gek\UyumBahce\StructType\OrderDef
     */
    public function setFormContractMId($formContractMId = null)
    {
        // validation for constraint: int
        if (!is_null($formContractMId) && !(is_int($formContractMId) || ctype_digit($formContractMId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formContractMId, true), gettype($formContractMId)), __LINE__);
        }
        $this->FormContractMId = $formContractMId;
        return $this;
    }
    /**
     * Get EntityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->EntityCode;
    }
    /**
     * Set EntityCode value
     * @param string $entityCode
     * @return \Gek\UyumBahce\StructType\OrderDef
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->EntityCode = $entityCode;
        return $this;
    }
    /**
     * Get Details value
     * @return \Gek\UyumBahce\ArrayType\ArrayOfOrderDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \Gek\UyumBahce\ArrayType\ArrayOfOrderDetailDef $details
     * @return \Gek\UyumBahce\StructType\OrderDef
     */
    public function setDetails(\Gek\UyumBahce\ArrayType\ArrayOfOrderDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
