<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryTotalType StructType
 * @subpackage Structs
 */
class MonetaryTotalType extends AbstractStructBase
{
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineExtensionAmount
     * @var \Gek\UyumBahce\StructType\LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxExclusiveAmount
     * @var \Gek\UyumBahce\StructType\TaxExclusiveAmountType
     */
    public $TaxExclusiveAmount;
    /**
     * The TaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxInclusiveAmount
     * @var \Gek\UyumBahce\StructType\TaxInclusiveAmountType
     */
    public $TaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AllowanceTotalAmount
     * @var \Gek\UyumBahce\StructType\AllowanceTotalAmountType
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ChargeTotalAmount
     * @var \Gek\UyumBahce\StructType\ChargeTotalAmountType
     */
    public $ChargeTotalAmount;
    /**
     * The PayableRoundingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PayableRoundingAmount
     * @var \Gek\UyumBahce\StructType\PayableRoundingAmountType
     */
    public $PayableRoundingAmount;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PayableAmount
     * @var \Gek\UyumBahce\StructType\PayableAmountType
     */
    public $PayableAmount;
    /**
     * Constructor method for MonetaryTotalType
     * @uses MonetaryTotalType::setLineExtensionAmount()
     * @uses MonetaryTotalType::setTaxExclusiveAmount()
     * @uses MonetaryTotalType::setTaxInclusiveAmount()
     * @uses MonetaryTotalType::setAllowanceTotalAmount()
     * @uses MonetaryTotalType::setChargeTotalAmount()
     * @uses MonetaryTotalType::setPayableRoundingAmount()
     * @uses MonetaryTotalType::setPayableAmount()
     * @param \Gek\UyumBahce\StructType\LineExtensionAmountType $lineExtensionAmount
     * @param \Gek\UyumBahce\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @param \Gek\UyumBahce\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @param \Gek\UyumBahce\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @param \Gek\UyumBahce\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @param \Gek\UyumBahce\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @param \Gek\UyumBahce\StructType\PayableAmountType $payableAmount
     */
    public function __construct(\Gek\UyumBahce\StructType\LineExtensionAmountType $lineExtensionAmount = null, \Gek\UyumBahce\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null, \Gek\UyumBahce\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null, \Gek\UyumBahce\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null, \Gek\UyumBahce\StructType\ChargeTotalAmountType $chargeTotalAmount = null, \Gek\UyumBahce\StructType\PayableRoundingAmountType $payableRoundingAmount = null, \Gek\UyumBahce\StructType\PayableAmountType $payableAmount = null)
    {
        $this
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setTaxInclusiveAmount($taxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setPayableRoundingAmount($payableRoundingAmount)
            ->setPayableAmount($payableAmount);
    }
    /**
     * Get LineExtensionAmount value
     * @return \Gek\UyumBahce\StructType\LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param \Gek\UyumBahce\StructType\LineExtensionAmountType $lineExtensionAmount
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public function setLineExtensionAmount(\Gek\UyumBahce\StructType\LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get TaxExclusiveAmount value
     * @return \Gek\UyumBahce\StructType\TaxExclusiveAmountType|null
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }
    /**
     * Set TaxExclusiveAmount value
     * @param \Gek\UyumBahce\StructType\TaxExclusiveAmountType $taxExclusiveAmount
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public function setTaxExclusiveAmount(\Gek\UyumBahce\StructType\TaxExclusiveAmountType $taxExclusiveAmount = null)
    {
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }
    /**
     * Get TaxInclusiveAmount value
     * @return \Gek\UyumBahce\StructType\TaxInclusiveAmountType|null
     */
    public function getTaxInclusiveAmount()
    {
        return $this->TaxInclusiveAmount;
    }
    /**
     * Set TaxInclusiveAmount value
     * @param \Gek\UyumBahce\StructType\TaxInclusiveAmountType $taxInclusiveAmount
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public function setTaxInclusiveAmount(\Gek\UyumBahce\StructType\TaxInclusiveAmountType $taxInclusiveAmount = null)
    {
        $this->TaxInclusiveAmount = $taxInclusiveAmount;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return \Gek\UyumBahce\StructType\AllowanceTotalAmountType|null
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param \Gek\UyumBahce\StructType\AllowanceTotalAmountType $allowanceTotalAmount
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public function setAllowanceTotalAmount(\Gek\UyumBahce\StructType\AllowanceTotalAmountType $allowanceTotalAmount = null)
    {
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get ChargeTotalAmount value
     * @return \Gek\UyumBahce\StructType\ChargeTotalAmountType|null
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }
    /**
     * Set ChargeTotalAmount value
     * @param \Gek\UyumBahce\StructType\ChargeTotalAmountType $chargeTotalAmount
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public function setChargeTotalAmount(\Gek\UyumBahce\StructType\ChargeTotalAmountType $chargeTotalAmount = null)
    {
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }
    /**
     * Get PayableRoundingAmount value
     * @return \Gek\UyumBahce\StructType\PayableRoundingAmountType|null
     */
    public function getPayableRoundingAmount()
    {
        return $this->PayableRoundingAmount;
    }
    /**
     * Set PayableRoundingAmount value
     * @param \Gek\UyumBahce\StructType\PayableRoundingAmountType $payableRoundingAmount
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public function setPayableRoundingAmount(\Gek\UyumBahce\StructType\PayableRoundingAmountType $payableRoundingAmount = null)
    {
        $this->PayableRoundingAmount = $payableRoundingAmount;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return \Gek\UyumBahce\StructType\PayableAmountType|null
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param \Gek\UyumBahce\StructType\PayableAmountType $payableAmount
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public function setPayableAmount(\Gek\UyumBahce\StructType\PayableAmountType $payableAmount = null)
    {
        $this->PayableAmount = $payableAmount;
        return $this;
    }
}
