<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaritimeTransportType StructType
 * @subpackage Structs
 */
class MaritimeTransportType extends AbstractStructBase
{
    /**
     * The VesselID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:VesselID
     * @var \Gek\UyumBahce\StructType\VesselIDType
     */
    public $VesselID;
    /**
     * The VesselName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:VesselName
     * @var \Gek\UyumBahce\StructType\VesselNameType
     */
    public $VesselName;
    /**
     * The RadioCallSignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RadioCallSignID
     * @var \Gek\UyumBahce\StructType\RadioCallSignIDType
     */
    public $RadioCallSignID;
    /**
     * The ShipsRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:ShipsRequirements
     * @var \Gek\UyumBahce\StructType\ShipsRequirementsType[]
     */
    public $ShipsRequirements;
    /**
     * The GrossTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossTonnageMeasure
     * @var \Gek\UyumBahce\StructType\GrossTonnageMeasureType
     */
    public $GrossTonnageMeasure;
    /**
     * The NetTonnageMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetTonnageMeasure
     * @var \Gek\UyumBahce\StructType\NetTonnageMeasureType
     */
    public $NetTonnageMeasure;
    /**
     * The RegistryCertificateDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public $RegistryCertificateDocumentReference;
    /**
     * The RegistryPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\LocationType
     */
    public $RegistryPortLocation;
    /**
     * Constructor method for MaritimeTransportType
     * @uses MaritimeTransportType::setVesselID()
     * @uses MaritimeTransportType::setVesselName()
     * @uses MaritimeTransportType::setRadioCallSignID()
     * @uses MaritimeTransportType::setShipsRequirements()
     * @uses MaritimeTransportType::setGrossTonnageMeasure()
     * @uses MaritimeTransportType::setNetTonnageMeasure()
     * @uses MaritimeTransportType::setRegistryCertificateDocumentReference()
     * @uses MaritimeTransportType::setRegistryPortLocation()
     * @param \Gek\UyumBahce\StructType\VesselIDType $vesselID
     * @param \Gek\UyumBahce\StructType\VesselNameType $vesselName
     * @param \Gek\UyumBahce\StructType\RadioCallSignIDType $radioCallSignID
     * @param \Gek\UyumBahce\StructType\ShipsRequirementsType[] $shipsRequirements
     * @param \Gek\UyumBahce\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @param \Gek\UyumBahce\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @param \Gek\UyumBahce\StructType\LocationType $registryPortLocation
     */
    public function __construct(\Gek\UyumBahce\StructType\VesselIDType $vesselID = null, \Gek\UyumBahce\StructType\VesselNameType $vesselName = null, \Gek\UyumBahce\StructType\RadioCallSignIDType $radioCallSignID = null, array $shipsRequirements = array(), \Gek\UyumBahce\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null, \Gek\UyumBahce\StructType\NetTonnageMeasureType $netTonnageMeasure = null, \Gek\UyumBahce\StructType\DocumentReferenceType $registryCertificateDocumentReference = null, \Gek\UyumBahce\StructType\LocationType $registryPortLocation = null)
    {
        $this
            ->setVesselID($vesselID)
            ->setVesselName($vesselName)
            ->setRadioCallSignID($radioCallSignID)
            ->setShipsRequirements($shipsRequirements)
            ->setGrossTonnageMeasure($grossTonnageMeasure)
            ->setNetTonnageMeasure($netTonnageMeasure)
            ->setRegistryCertificateDocumentReference($registryCertificateDocumentReference)
            ->setRegistryPortLocation($registryPortLocation);
    }
    /**
     * Get VesselID value
     * @return \Gek\UyumBahce\StructType\VesselIDType|null
     */
    public function getVesselID()
    {
        return $this->VesselID;
    }
    /**
     * Set VesselID value
     * @param \Gek\UyumBahce\StructType\VesselIDType $vesselID
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setVesselID(\Gek\UyumBahce\StructType\VesselIDType $vesselID = null)
    {
        $this->VesselID = $vesselID;
        return $this;
    }
    /**
     * Get VesselName value
     * @return \Gek\UyumBahce\StructType\VesselNameType|null
     */
    public function getVesselName()
    {
        return $this->VesselName;
    }
    /**
     * Set VesselName value
     * @param \Gek\UyumBahce\StructType\VesselNameType $vesselName
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setVesselName(\Gek\UyumBahce\StructType\VesselNameType $vesselName = null)
    {
        $this->VesselName = $vesselName;
        return $this;
    }
    /**
     * Get RadioCallSignID value
     * @return \Gek\UyumBahce\StructType\RadioCallSignIDType|null
     */
    public function getRadioCallSignID()
    {
        return $this->RadioCallSignID;
    }
    /**
     * Set RadioCallSignID value
     * @param \Gek\UyumBahce\StructType\RadioCallSignIDType $radioCallSignID
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setRadioCallSignID(\Gek\UyumBahce\StructType\RadioCallSignIDType $radioCallSignID = null)
    {
        $this->RadioCallSignID = $radioCallSignID;
        return $this;
    }
    /**
     * Get ShipsRequirements value
     * @return \Gek\UyumBahce\StructType\ShipsRequirementsType[]|null
     */
    public function getShipsRequirements()
    {
        return $this->ShipsRequirements;
    }
    /**
     * This method is responsible for validating the values passed to the setShipsRequirements method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipsRequirements method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maritimeTransportTypeShipsRequirementsItem) {
            // validation for constraint: itemType
            if (!$maritimeTransportTypeShipsRequirementsItem instanceof \Gek\UyumBahce\StructType\ShipsRequirementsType) {
                $invalidValues[] = is_object($maritimeTransportTypeShipsRequirementsItem) ? get_class($maritimeTransportTypeShipsRequirementsItem) : sprintf('%s(%s)', gettype($maritimeTransportTypeShipsRequirementsItem), var_export($maritimeTransportTypeShipsRequirementsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipsRequirements property can only contain items of type \Gek\UyumBahce\StructType\ShipsRequirementsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ShipsRequirementsType[] $shipsRequirements
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setShipsRequirements(array $shipsRequirements = array())
    {
        // validation for constraint: array
        if ('' !== ($shipsRequirementsArrayErrorMessage = self::validateShipsRequirementsForArrayConstraintsFromSetShipsRequirements($shipsRequirements))) {
            throw new \InvalidArgumentException($shipsRequirementsArrayErrorMessage, __LINE__);
        }
        $this->ShipsRequirements = $shipsRequirements;
        return $this;
    }
    /**
     * Add item to ShipsRequirements value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ShipsRequirementsType $item
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function addToShipsRequirements(\Gek\UyumBahce\StructType\ShipsRequirementsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ShipsRequirementsType) {
            throw new \InvalidArgumentException(sprintf('The ShipsRequirements property can only contain items of type \Gek\UyumBahce\StructType\ShipsRequirementsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipsRequirements[] = $item;
        return $this;
    }
    /**
     * Get GrossTonnageMeasure value
     * @return \Gek\UyumBahce\StructType\GrossTonnageMeasureType|null
     */
    public function getGrossTonnageMeasure()
    {
        return $this->GrossTonnageMeasure;
    }
    /**
     * Set GrossTonnageMeasure value
     * @param \Gek\UyumBahce\StructType\GrossTonnageMeasureType $grossTonnageMeasure
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setGrossTonnageMeasure(\Gek\UyumBahce\StructType\GrossTonnageMeasureType $grossTonnageMeasure = null)
    {
        $this->GrossTonnageMeasure = $grossTonnageMeasure;
        return $this;
    }
    /**
     * Get NetTonnageMeasure value
     * @return \Gek\UyumBahce\StructType\NetTonnageMeasureType|null
     */
    public function getNetTonnageMeasure()
    {
        return $this->NetTonnageMeasure;
    }
    /**
     * Set NetTonnageMeasure value
     * @param \Gek\UyumBahce\StructType\NetTonnageMeasureType $netTonnageMeasure
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setNetTonnageMeasure(\Gek\UyumBahce\StructType\NetTonnageMeasureType $netTonnageMeasure = null)
    {
        $this->NetTonnageMeasure = $netTonnageMeasure;
        return $this;
    }
    /**
     * Get RegistryCertificateDocumentReference value
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType|null
     */
    public function getRegistryCertificateDocumentReference()
    {
        return $this->RegistryCertificateDocumentReference;
    }
    /**
     * Set RegistryCertificateDocumentReference value
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $registryCertificateDocumentReference
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setRegistryCertificateDocumentReference(\Gek\UyumBahce\StructType\DocumentReferenceType $registryCertificateDocumentReference = null)
    {
        $this->RegistryCertificateDocumentReference = $registryCertificateDocumentReference;
        return $this;
    }
    /**
     * Get RegistryPortLocation value
     * @return \Gek\UyumBahce\StructType\LocationType|null
     */
    public function getRegistryPortLocation()
    {
        return $this->RegistryPortLocation;
    }
    /**
     * Set RegistryPortLocation value
     * @param \Gek\UyumBahce\StructType\LocationType $registryPortLocation
     * @return \Gek\UyumBahce\StructType\MaritimeTransportType
     */
    public function setRegistryPortLocation(\Gek\UyumBahce\StructType\LocationType $registryPortLocation = null)
    {
        $this->RegistryPortLocation = $registryPortLocation;
        return $this;
    }
}
