<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailingInformation StructType
 * @subpackage Structs
 */
class MailingInformation extends AbstractStructBase
{
    /**
     * The EnableNotification
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $EnableNotification;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\MailAttachmentInformation
     */
    public $Attachment;
    /**
     * The BodyXsltIdentifier
     * @var string
     */
    public $BodyXsltIdentifier;
    /**
     * The EmailAccountIdentifier
     * @var string
     */
    public $EmailAccountIdentifier;
    /**
     * The To
     * @var string
     */
    public $To;
    /**
     * Constructor method for MailingInformation
     * @uses MailingInformation::setEnableNotification()
     * @uses MailingInformation::setSubject()
     * @uses MailingInformation::setAttachment()
     * @uses MailingInformation::setBodyXsltIdentifier()
     * @uses MailingInformation::setEmailAccountIdentifier()
     * @uses MailingInformation::setTo()
     * @param bool $enableNotification
     * @param string $subject
     * @param \Gek\UyumBahce\StructType\MailAttachmentInformation $attachment
     * @param string $bodyXsltIdentifier
     * @param string $emailAccountIdentifier
     * @param string $to
     */
    public function __construct($enableNotification = null, $subject = null, \Gek\UyumBahce\StructType\MailAttachmentInformation $attachment = null, $bodyXsltIdentifier = null, $emailAccountIdentifier = null, $to = null)
    {
        $this
            ->setEnableNotification($enableNotification)
            ->setSubject($subject)
            ->setAttachment($attachment)
            ->setBodyXsltIdentifier($bodyXsltIdentifier)
            ->setEmailAccountIdentifier($emailAccountIdentifier)
            ->setTo($to);
    }
    /**
     * Get EnableNotification value
     * @return bool
     */
    public function getEnableNotification()
    {
        return $this->EnableNotification;
    }
    /**
     * Set EnableNotification value
     * @param bool $enableNotification
     * @return \Gek\UyumBahce\StructType\MailingInformation
     */
    public function setEnableNotification($enableNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableNotification) && !is_bool($enableNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableNotification, true), gettype($enableNotification)), __LINE__);
        }
        $this->EnableNotification = $enableNotification;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \Gek\UyumBahce\StructType\MailingInformation
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \Gek\UyumBahce\StructType\MailAttachmentInformation|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \Gek\UyumBahce\StructType\MailAttachmentInformation $attachment
     * @return \Gek\UyumBahce\StructType\MailingInformation
     */
    public function setAttachment(\Gek\UyumBahce\StructType\MailAttachmentInformation $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get BodyXsltIdentifier value
     * @return string|null
     */
    public function getBodyXsltIdentifier()
    {
        return $this->BodyXsltIdentifier;
    }
    /**
     * Set BodyXsltIdentifier value
     * @param string $bodyXsltIdentifier
     * @return \Gek\UyumBahce\StructType\MailingInformation
     */
    public function setBodyXsltIdentifier($bodyXsltIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($bodyXsltIdentifier) && !is_string($bodyXsltIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bodyXsltIdentifier, true), gettype($bodyXsltIdentifier)), __LINE__);
        }
        $this->BodyXsltIdentifier = $bodyXsltIdentifier;
        return $this;
    }
    /**
     * Get EmailAccountIdentifier value
     * @return string|null
     */
    public function getEmailAccountIdentifier()
    {
        return $this->EmailAccountIdentifier;
    }
    /**
     * Set EmailAccountIdentifier value
     * @param string $emailAccountIdentifier
     * @return \Gek\UyumBahce\StructType\MailingInformation
     */
    public function setEmailAccountIdentifier($emailAccountIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($emailAccountIdentifier) && !is_string($emailAccountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAccountIdentifier, true), gettype($emailAccountIdentifier)), __LINE__);
        }
        $this->EmailAccountIdentifier = $emailAccountIdentifier;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \Gek\UyumBahce\StructType\MailingInformation
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
}
