<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Description
     * @var \Gek\UyumBahce\StructType\DescriptionType
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Name
     * @var \Gek\UyumBahce\StructType\NameType
     */
    public $Name;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Keyword
     * @var \Gek\UyumBahce\StructType\KeywordType
     */
    public $Keyword;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:BrandName
     * @var \Gek\UyumBahce\StructType\BrandNameType
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ModelName
     * @var \Gek\UyumBahce\StructType\ModelNameType
     */
    public $ModelName;
    /**
     * The BuyersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemIdentificationType
     */
    public $BuyersItemIdentification;
    /**
     * The SellersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemIdentificationType
     */
    public $SellersItemIdentification;
    /**
     * The ManufacturersItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemIdentificationType
     */
    public $ManufacturersItemIdentification;
    /**
     * The AdditionalItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemIdentificationType[]
     */
    public $AdditionalItemIdentification;
    /**
     * The OriginCountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\CountryType
     */
    public $OriginCountry;
    /**
     * The CommodityClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\CommodityClassificationType[]
     */
    public $CommodityClassification;
    /**
     * The ItemInstance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemInstanceType[]
     */
    public $ItemInstance;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setDescription()
     * @uses ItemType::setName()
     * @uses ItemType::setKeyword()
     * @uses ItemType::setBrandName()
     * @uses ItemType::setModelName()
     * @uses ItemType::setBuyersItemIdentification()
     * @uses ItemType::setSellersItemIdentification()
     * @uses ItemType::setManufacturersItemIdentification()
     * @uses ItemType::setAdditionalItemIdentification()
     * @uses ItemType::setOriginCountry()
     * @uses ItemType::setCommodityClassification()
     * @uses ItemType::setItemInstance()
     * @param \Gek\UyumBahce\StructType\DescriptionType $description
     * @param \Gek\UyumBahce\StructType\NameType $name
     * @param \Gek\UyumBahce\StructType\KeywordType $keyword
     * @param \Gek\UyumBahce\StructType\BrandNameType $brandName
     * @param \Gek\UyumBahce\StructType\ModelNameType $modelName
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType $buyersItemIdentification
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType $sellersItemIdentification
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @param \Gek\UyumBahce\StructType\CountryType $originCountry
     * @param \Gek\UyumBahce\StructType\CommodityClassificationType[] $commodityClassification
     * @param \Gek\UyumBahce\StructType\ItemInstanceType[] $itemInstance
     */
    public function __construct(\Gek\UyumBahce\StructType\DescriptionType $description = null, \Gek\UyumBahce\StructType\NameType $name = null, \Gek\UyumBahce\StructType\KeywordType $keyword = null, \Gek\UyumBahce\StructType\BrandNameType $brandName = null, \Gek\UyumBahce\StructType\ModelNameType $modelName = null, \Gek\UyumBahce\StructType\ItemIdentificationType $buyersItemIdentification = null, \Gek\UyumBahce\StructType\ItemIdentificationType $sellersItemIdentification = null, \Gek\UyumBahce\StructType\ItemIdentificationType $manufacturersItemIdentification = null, array $additionalItemIdentification = array(), \Gek\UyumBahce\StructType\CountryType $originCountry = null, array $commodityClassification = array(), array $itemInstance = array())
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setKeyword($keyword)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setBuyersItemIdentification($buyersItemIdentification)
            ->setSellersItemIdentification($sellersItemIdentification)
            ->setManufacturersItemIdentification($manufacturersItemIdentification)
            ->setAdditionalItemIdentification($additionalItemIdentification)
            ->setOriginCountry($originCountry)
            ->setCommodityClassification($commodityClassification)
            ->setItemInstance($itemInstance);
    }
    /**
     * Get Description value
     * @return \Gek\UyumBahce\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \Gek\UyumBahce\StructType\DescriptionType $description
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setDescription(\Gek\UyumBahce\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Name value
     * @return \Gek\UyumBahce\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Gek\UyumBahce\StructType\NameType $name
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setName(\Gek\UyumBahce\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Keyword value
     * @return \Gek\UyumBahce\StructType\KeywordType|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param \Gek\UyumBahce\StructType\KeywordType $keyword
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setKeyword(\Gek\UyumBahce\StructType\KeywordType $keyword = null)
    {
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get BrandName value
     * @return \Gek\UyumBahce\StructType\BrandNameType|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param \Gek\UyumBahce\StructType\BrandNameType $brandName
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setBrandName(\Gek\UyumBahce\StructType\BrandNameType $brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return \Gek\UyumBahce\StructType\ModelNameType|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param \Gek\UyumBahce\StructType\ModelNameType $modelName
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setModelName(\Gek\UyumBahce\StructType\ModelNameType $modelName = null)
    {
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get BuyersItemIdentification value
     * @return \Gek\UyumBahce\StructType\ItemIdentificationType|null
     */
    public function getBuyersItemIdentification()
    {
        return $this->BuyersItemIdentification;
    }
    /**
     * Set BuyersItemIdentification value
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType $buyersItemIdentification
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setBuyersItemIdentification(\Gek\UyumBahce\StructType\ItemIdentificationType $buyersItemIdentification = null)
    {
        $this->BuyersItemIdentification = $buyersItemIdentification;
        return $this;
    }
    /**
     * Get SellersItemIdentification value
     * @return \Gek\UyumBahce\StructType\ItemIdentificationType|null
     */
    public function getSellersItemIdentification()
    {
        return $this->SellersItemIdentification;
    }
    /**
     * Set SellersItemIdentification value
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType $sellersItemIdentification
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setSellersItemIdentification(\Gek\UyumBahce\StructType\ItemIdentificationType $sellersItemIdentification = null)
    {
        $this->SellersItemIdentification = $sellersItemIdentification;
        return $this;
    }
    /**
     * Get ManufacturersItemIdentification value
     * @return \Gek\UyumBahce\StructType\ItemIdentificationType|null
     */
    public function getManufacturersItemIdentification()
    {
        return $this->ManufacturersItemIdentification;
    }
    /**
     * Set ManufacturersItemIdentification value
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType $manufacturersItemIdentification
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setManufacturersItemIdentification(\Gek\UyumBahce\StructType\ItemIdentificationType $manufacturersItemIdentification = null)
    {
        $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        return $this;
    }
    /**
     * Get AdditionalItemIdentification value
     * @return \Gek\UyumBahce\StructType\ItemIdentificationType[]|null
     */
    public function getAdditionalItemIdentification()
    {
        return $this->AdditionalItemIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalItemIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeAdditionalItemIdentificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeAdditionalItemIdentificationItem instanceof \Gek\UyumBahce\StructType\ItemIdentificationType) {
                $invalidValues[] = is_object($itemTypeAdditionalItemIdentificationItem) ? get_class($itemTypeAdditionalItemIdentificationItem) : sprintf('%s(%s)', gettype($itemTypeAdditionalItemIdentificationItem), var_export($itemTypeAdditionalItemIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemIdentification property can only contain items of type \Gek\UyumBahce\StructType\ItemIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType[] $additionalItemIdentification
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setAdditionalItemIdentification(array $additionalItemIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemIdentificationArrayErrorMessage = self::validateAdditionalItemIdentificationForArrayConstraintsFromSetAdditionalItemIdentification($additionalItemIdentification))) {
            throw new \InvalidArgumentException($additionalItemIdentificationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemIdentification = $additionalItemIdentification;
        return $this;
    }
    /**
     * Add item to AdditionalItemIdentification value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemIdentificationType $item
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function addToAdditionalItemIdentification(\Gek\UyumBahce\StructType\ItemIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ItemIdentificationType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalItemIdentification property can only contain items of type \Gek\UyumBahce\StructType\ItemIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemIdentification[] = $item;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return \Gek\UyumBahce\StructType\CountryType|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param \Gek\UyumBahce\StructType\CountryType $originCountry
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setOriginCountry(\Gek\UyumBahce\StructType\CountryType $originCountry = null)
    {
        $this->OriginCountry = $originCountry;
        return $this;
    }
    /**
     * Get CommodityClassification value
     * @return \Gek\UyumBahce\StructType\CommodityClassificationType[]|null
     */
    public function getCommodityClassification()
    {
        return $this->CommodityClassification;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodityClassification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodityClassification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeCommodityClassificationItem) {
            // validation for constraint: itemType
            if (!$itemTypeCommodityClassificationItem instanceof \Gek\UyumBahce\StructType\CommodityClassificationType) {
                $invalidValues[] = is_object($itemTypeCommodityClassificationItem) ? get_class($itemTypeCommodityClassificationItem) : sprintf('%s(%s)', gettype($itemTypeCommodityClassificationItem), var_export($itemTypeCommodityClassificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommodityClassification property can only contain items of type \Gek\UyumBahce\StructType\CommodityClassificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\CommodityClassificationType[] $commodityClassification
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setCommodityClassification(array $commodityClassification = array())
    {
        // validation for constraint: array
        if ('' !== ($commodityClassificationArrayErrorMessage = self::validateCommodityClassificationForArrayConstraintsFromSetCommodityClassification($commodityClassification))) {
            throw new \InvalidArgumentException($commodityClassificationArrayErrorMessage, __LINE__);
        }
        $this->CommodityClassification = $commodityClassification;
        return $this;
    }
    /**
     * Add item to CommodityClassification value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\CommodityClassificationType $item
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function addToCommodityClassification(\Gek\UyumBahce\StructType\CommodityClassificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\CommodityClassificationType) {
            throw new \InvalidArgumentException(sprintf('The CommodityClassification property can only contain items of type \Gek\UyumBahce\StructType\CommodityClassificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommodityClassification[] = $item;
        return $this;
    }
    /**
     * Get ItemInstance value
     * @return \Gek\UyumBahce\StructType\ItemInstanceType[]|null
     */
    public function getItemInstance()
    {
        return $this->ItemInstance;
    }
    /**
     * This method is responsible for validating the values passed to the setItemInstance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemInstance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemInstanceForArrayConstraintsFromSetItemInstance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeItemInstanceItem) {
            // validation for constraint: itemType
            if (!$itemTypeItemInstanceItem instanceof \Gek\UyumBahce\StructType\ItemInstanceType) {
                $invalidValues[] = is_object($itemTypeItemInstanceItem) ? get_class($itemTypeItemInstanceItem) : sprintf('%s(%s)', gettype($itemTypeItemInstanceItem), var_export($itemTypeItemInstanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemInstance property can only contain items of type \Gek\UyumBahce\StructType\ItemInstanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemInstance value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemInstanceType[] $itemInstance
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function setItemInstance(array $itemInstance = array())
    {
        // validation for constraint: array
        if ('' !== ($itemInstanceArrayErrorMessage = self::validateItemInstanceForArrayConstraintsFromSetItemInstance($itemInstance))) {
            throw new \InvalidArgumentException($itemInstanceArrayErrorMessage, __LINE__);
        }
        $this->ItemInstance = $itemInstance;
        return $this;
    }
    /**
     * Add item to ItemInstance value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemInstanceType $item
     * @return \Gek\UyumBahce\StructType\ItemType
     */
    public function addToItemInstance(\Gek\UyumBahce\StructType\ItemInstanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ItemInstanceType) {
            throw new \InvalidArgumentException(sprintf('The ItemInstance property can only contain items of type \Gek\UyumBahce\StructType\ItemInstanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemInstance[] = $item;
        return $this;
    }
}
