<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPropertyType StructType
 * @subpackage Structs
 */
class ItemPropertyType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Name
     * @var \Gek\UyumBahce\StructType\NameType
     */
    public $Name;
    /**
     * The NameCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NameCode
     * @var \Gek\UyumBahce\StructType\NameCodeType
     */
    public $NameCode;
    /**
     * The TestMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TestMethod
     * @var \Gek\UyumBahce\StructType\TestMethodType
     */
    public $TestMethod;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Value
     * @var \Gek\UyumBahce\StructType\ValueType
     */
    public $Value;
    /**
     * The ValueQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ValueQuantity
     * @var \Gek\UyumBahce\StructType\ValueQuantityType
     */
    public $ValueQuantity;
    /**
     * The ValueQualifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:ValueQualifier
     * @var \Gek\UyumBahce\StructType\ValueQualifierType[]
     */
    public $ValueQualifier;
    /**
     * The ImportanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ImportanceCode
     * @var \Gek\UyumBahce\StructType\ImportanceCodeType
     */
    public $ImportanceCode;
    /**
     * The ListValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:ListValue
     * @var \Gek\UyumBahce\StructType\ListValueType[]
     */
    public $ListValue;
    /**
     * The UsabilityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PeriodType
     */
    public $UsabilityPeriod;
    /**
     * The ItemPropertyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemPropertyGroupType[]
     */
    public $ItemPropertyGroup;
    /**
     * The RangeDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DimensionType
     */
    public $RangeDimension;
    /**
     * The ItemPropertyRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemPropertyRangeType
     */
    public $ItemPropertyRange;
    /**
     * Constructor method for ItemPropertyType
     * @uses ItemPropertyType::setID()
     * @uses ItemPropertyType::setName()
     * @uses ItemPropertyType::setNameCode()
     * @uses ItemPropertyType::setTestMethod()
     * @uses ItemPropertyType::setValue()
     * @uses ItemPropertyType::setValueQuantity()
     * @uses ItemPropertyType::setValueQualifier()
     * @uses ItemPropertyType::setImportanceCode()
     * @uses ItemPropertyType::setListValue()
     * @uses ItemPropertyType::setUsabilityPeriod()
     * @uses ItemPropertyType::setItemPropertyGroup()
     * @uses ItemPropertyType::setRangeDimension()
     * @uses ItemPropertyType::setItemPropertyRange()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\NameType $name
     * @param \Gek\UyumBahce\StructType\NameCodeType $nameCode
     * @param \Gek\UyumBahce\StructType\TestMethodType $testMethod
     * @param \Gek\UyumBahce\StructType\ValueType $value
     * @param \Gek\UyumBahce\StructType\ValueQuantityType $valueQuantity
     * @param \Gek\UyumBahce\StructType\ValueQualifierType[] $valueQualifier
     * @param \Gek\UyumBahce\StructType\ImportanceCodeType $importanceCode
     * @param \Gek\UyumBahce\StructType\ListValueType[] $listValue
     * @param \Gek\UyumBahce\StructType\PeriodType $usabilityPeriod
     * @param \Gek\UyumBahce\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @param \Gek\UyumBahce\StructType\DimensionType $rangeDimension
     * @param \Gek\UyumBahce\StructType\ItemPropertyRangeType $itemPropertyRange
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\NameType $name = null, \Gek\UyumBahce\StructType\NameCodeType $nameCode = null, \Gek\UyumBahce\StructType\TestMethodType $testMethod = null, \Gek\UyumBahce\StructType\ValueType $value = null, \Gek\UyumBahce\StructType\ValueQuantityType $valueQuantity = null, array $valueQualifier = array(), \Gek\UyumBahce\StructType\ImportanceCodeType $importanceCode = null, array $listValue = array(), \Gek\UyumBahce\StructType\PeriodType $usabilityPeriod = null, array $itemPropertyGroup = array(), \Gek\UyumBahce\StructType\DimensionType $rangeDimension = null, \Gek\UyumBahce\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setNameCode($nameCode)
            ->setTestMethod($testMethod)
            ->setValue($value)
            ->setValueQuantity($valueQuantity)
            ->setValueQualifier($valueQualifier)
            ->setImportanceCode($importanceCode)
            ->setListValue($listValue)
            ->setUsabilityPeriod($usabilityPeriod)
            ->setItemPropertyGroup($itemPropertyGroup)
            ->setRangeDimension($rangeDimension)
            ->setItemPropertyRange($itemPropertyRange);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return \Gek\UyumBahce\StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \Gek\UyumBahce\StructType\NameType $name
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setName(\Gek\UyumBahce\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameCode value
     * @return \Gek\UyumBahce\StructType\NameCodeType|null
     */
    public function getNameCode()
    {
        return $this->NameCode;
    }
    /**
     * Set NameCode value
     * @param \Gek\UyumBahce\StructType\NameCodeType $nameCode
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setNameCode(\Gek\UyumBahce\StructType\NameCodeType $nameCode = null)
    {
        $this->NameCode = $nameCode;
        return $this;
    }
    /**
     * Get TestMethod value
     * @return \Gek\UyumBahce\StructType\TestMethodType|null
     */
    public function getTestMethod()
    {
        return $this->TestMethod;
    }
    /**
     * Set TestMethod value
     * @param \Gek\UyumBahce\StructType\TestMethodType $testMethod
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setTestMethod(\Gek\UyumBahce\StructType\TestMethodType $testMethod = null)
    {
        $this->TestMethod = $testMethod;
        return $this;
    }
    /**
     * Get Value value
     * @return \Gek\UyumBahce\StructType\ValueType|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \Gek\UyumBahce\StructType\ValueType $value
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setValue(\Gek\UyumBahce\StructType\ValueType $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueQuantity value
     * @return \Gek\UyumBahce\StructType\ValueQuantityType|null
     */
    public function getValueQuantity()
    {
        return $this->ValueQuantity;
    }
    /**
     * Set ValueQuantity value
     * @param \Gek\UyumBahce\StructType\ValueQuantityType $valueQuantity
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setValueQuantity(\Gek\UyumBahce\StructType\ValueQuantityType $valueQuantity = null)
    {
        $this->ValueQuantity = $valueQuantity;
        return $this;
    }
    /**
     * Get ValueQualifier value
     * @return \Gek\UyumBahce\StructType\ValueQualifierType[]|null
     */
    public function getValueQualifier()
    {
        return $this->ValueQualifier;
    }
    /**
     * This method is responsible for validating the values passed to the setValueQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValueQualifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueQualifierForArrayConstraintsFromSetValueQualifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeValueQualifierItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeValueQualifierItem instanceof \Gek\UyumBahce\StructType\ValueQualifierType) {
                $invalidValues[] = is_object($itemPropertyTypeValueQualifierItem) ? get_class($itemPropertyTypeValueQualifierItem) : sprintf('%s(%s)', gettype($itemPropertyTypeValueQualifierItem), var_export($itemPropertyTypeValueQualifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValueQualifier property can only contain items of type \Gek\UyumBahce\StructType\ValueQualifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ValueQualifierType[] $valueQualifier
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setValueQualifier(array $valueQualifier = array())
    {
        // validation for constraint: array
        if ('' !== ($valueQualifierArrayErrorMessage = self::validateValueQualifierForArrayConstraintsFromSetValueQualifier($valueQualifier))) {
            throw new \InvalidArgumentException($valueQualifierArrayErrorMessage, __LINE__);
        }
        $this->ValueQualifier = $valueQualifier;
        return $this;
    }
    /**
     * Add item to ValueQualifier value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ValueQualifierType $item
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function addToValueQualifier(\Gek\UyumBahce\StructType\ValueQualifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ValueQualifierType) {
            throw new \InvalidArgumentException(sprintf('The ValueQualifier property can only contain items of type \Gek\UyumBahce\StructType\ValueQualifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValueQualifier[] = $item;
        return $this;
    }
    /**
     * Get ImportanceCode value
     * @return \Gek\UyumBahce\StructType\ImportanceCodeType|null
     */
    public function getImportanceCode()
    {
        return $this->ImportanceCode;
    }
    /**
     * Set ImportanceCode value
     * @param \Gek\UyumBahce\StructType\ImportanceCodeType $importanceCode
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setImportanceCode(\Gek\UyumBahce\StructType\ImportanceCodeType $importanceCode = null)
    {
        $this->ImportanceCode = $importanceCode;
        return $this;
    }
    /**
     * Get ListValue value
     * @return \Gek\UyumBahce\StructType\ListValueType[]|null
     */
    public function getListValue()
    {
        return $this->ListValue;
    }
    /**
     * This method is responsible for validating the values passed to the setListValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListValueForArrayConstraintsFromSetListValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeListValueItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeListValueItem instanceof \Gek\UyumBahce\StructType\ListValueType) {
                $invalidValues[] = is_object($itemPropertyTypeListValueItem) ? get_class($itemPropertyTypeListValueItem) : sprintf('%s(%s)', gettype($itemPropertyTypeListValueItem), var_export($itemPropertyTypeListValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListValue property can only contain items of type \Gek\UyumBahce\StructType\ListValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListValue value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ListValueType[] $listValue
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setListValue(array $listValue = array())
    {
        // validation for constraint: array
        if ('' !== ($listValueArrayErrorMessage = self::validateListValueForArrayConstraintsFromSetListValue($listValue))) {
            throw new \InvalidArgumentException($listValueArrayErrorMessage, __LINE__);
        }
        $this->ListValue = $listValue;
        return $this;
    }
    /**
     * Add item to ListValue value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ListValueType $item
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function addToListValue(\Gek\UyumBahce\StructType\ListValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ListValueType) {
            throw new \InvalidArgumentException(sprintf('The ListValue property can only contain items of type \Gek\UyumBahce\StructType\ListValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListValue[] = $item;
        return $this;
    }
    /**
     * Get UsabilityPeriod value
     * @return \Gek\UyumBahce\StructType\PeriodType|null
     */
    public function getUsabilityPeriod()
    {
        return $this->UsabilityPeriod;
    }
    /**
     * Set UsabilityPeriod value
     * @param \Gek\UyumBahce\StructType\PeriodType $usabilityPeriod
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setUsabilityPeriod(\Gek\UyumBahce\StructType\PeriodType $usabilityPeriod = null)
    {
        $this->UsabilityPeriod = $usabilityPeriod;
        return $this;
    }
    /**
     * Get ItemPropertyGroup value
     * @return \Gek\UyumBahce\StructType\ItemPropertyGroupType[]|null
     */
    public function getItemPropertyGroup()
    {
        return $this->ItemPropertyGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setItemPropertyGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemPropertyGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeItemPropertyGroupItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeItemPropertyGroupItem instanceof \Gek\UyumBahce\StructType\ItemPropertyGroupType) {
                $invalidValues[] = is_object($itemPropertyTypeItemPropertyGroupItem) ? get_class($itemPropertyTypeItemPropertyGroupItem) : sprintf('%s(%s)', gettype($itemPropertyTypeItemPropertyGroupItem), var_export($itemPropertyTypeItemPropertyGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemPropertyGroup property can only contain items of type \Gek\UyumBahce\StructType\ItemPropertyGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemPropertyGroupType[] $itemPropertyGroup
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setItemPropertyGroup(array $itemPropertyGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($itemPropertyGroupArrayErrorMessage = self::validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup($itemPropertyGroup))) {
            throw new \InvalidArgumentException($itemPropertyGroupArrayErrorMessage, __LINE__);
        }
        $this->ItemPropertyGroup = $itemPropertyGroup;
        return $this;
    }
    /**
     * Add item to ItemPropertyGroup value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemPropertyGroupType $item
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function addToItemPropertyGroup(\Gek\UyumBahce\StructType\ItemPropertyGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ItemPropertyGroupType) {
            throw new \InvalidArgumentException(sprintf('The ItemPropertyGroup property can only contain items of type \Gek\UyumBahce\StructType\ItemPropertyGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemPropertyGroup[] = $item;
        return $this;
    }
    /**
     * Get RangeDimension value
     * @return \Gek\UyumBahce\StructType\DimensionType|null
     */
    public function getRangeDimension()
    {
        return $this->RangeDimension;
    }
    /**
     * Set RangeDimension value
     * @param \Gek\UyumBahce\StructType\DimensionType $rangeDimension
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setRangeDimension(\Gek\UyumBahce\StructType\DimensionType $rangeDimension = null)
    {
        $this->RangeDimension = $rangeDimension;
        return $this;
    }
    /**
     * Get ItemPropertyRange value
     * @return \Gek\UyumBahce\StructType\ItemPropertyRangeType|null
     */
    public function getItemPropertyRange()
    {
        return $this->ItemPropertyRange;
    }
    /**
     * Set ItemPropertyRange value
     * @param \Gek\UyumBahce\StructType\ItemPropertyRangeType $itemPropertyRange
     * @return \Gek\UyumBahce\StructType\ItemPropertyType
     */
    public function setItemPropertyRange(\Gek\UyumBahce\StructType\ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this->ItemPropertyRange = $itemPropertyRange;
        return $this;
    }
}
