<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemInstanceType StructType
 * @subpackage Structs
 */
class ItemInstanceType extends AbstractStructBase
{
    /**
     * The ProductTraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ProductTraceID
     * @var \Gek\UyumBahce\StructType\ProductTraceIDType
     */
    public $ProductTraceID;
    /**
     * The ManufactureDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ManufactureDate
     * @var \Gek\UyumBahce\StructType\ManufactureDateType
     */
    public $ManufactureDate;
    /**
     * The ManufactureTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ManufactureTime
     * @var \Gek\UyumBahce\StructType\ManufactureTimeType
     */
    public $ManufactureTime;
    /**
     * The BestBeforeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:BestBeforeDate
     * @var \Gek\UyumBahce\StructType\BestBeforeDateType
     */
    public $BestBeforeDate;
    /**
     * The RegistrationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RegistrationID
     * @var \Gek\UyumBahce\StructType\RegistrationIDType
     */
    public $RegistrationID;
    /**
     * The SerialID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:SerialID
     * @var \Gek\UyumBahce\StructType\SerialIDType
     */
    public $SerialID;
    /**
     * The AdditionalItemProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemPropertyType[]
     */
    public $AdditionalItemProperty;
    /**
     * The LotIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\LotIdentificationType
     */
    public $LotIdentification;
    /**
     * Constructor method for ItemInstanceType
     * @uses ItemInstanceType::setProductTraceID()
     * @uses ItemInstanceType::setManufactureDate()
     * @uses ItemInstanceType::setManufactureTime()
     * @uses ItemInstanceType::setBestBeforeDate()
     * @uses ItemInstanceType::setRegistrationID()
     * @uses ItemInstanceType::setSerialID()
     * @uses ItemInstanceType::setAdditionalItemProperty()
     * @uses ItemInstanceType::setLotIdentification()
     * @param \Gek\UyumBahce\StructType\ProductTraceIDType $productTraceID
     * @param \Gek\UyumBahce\StructType\ManufactureDateType $manufactureDate
     * @param \Gek\UyumBahce\StructType\ManufactureTimeType $manufactureTime
     * @param \Gek\UyumBahce\StructType\BestBeforeDateType $bestBeforeDate
     * @param \Gek\UyumBahce\StructType\RegistrationIDType $registrationID
     * @param \Gek\UyumBahce\StructType\SerialIDType $serialID
     * @param \Gek\UyumBahce\StructType\ItemPropertyType[] $additionalItemProperty
     * @param \Gek\UyumBahce\StructType\LotIdentificationType $lotIdentification
     */
    public function __construct(\Gek\UyumBahce\StructType\ProductTraceIDType $productTraceID = null, \Gek\UyumBahce\StructType\ManufactureDateType $manufactureDate = null, \Gek\UyumBahce\StructType\ManufactureTimeType $manufactureTime = null, \Gek\UyumBahce\StructType\BestBeforeDateType $bestBeforeDate = null, \Gek\UyumBahce\StructType\RegistrationIDType $registrationID = null, \Gek\UyumBahce\StructType\SerialIDType $serialID = null, array $additionalItemProperty = array(), \Gek\UyumBahce\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this
            ->setProductTraceID($productTraceID)
            ->setManufactureDate($manufactureDate)
            ->setManufactureTime($manufactureTime)
            ->setBestBeforeDate($bestBeforeDate)
            ->setRegistrationID($registrationID)
            ->setSerialID($serialID)
            ->setAdditionalItemProperty($additionalItemProperty)
            ->setLotIdentification($lotIdentification);
    }
    /**
     * Get ProductTraceID value
     * @return \Gek\UyumBahce\StructType\ProductTraceIDType|null
     */
    public function getProductTraceID()
    {
        return $this->ProductTraceID;
    }
    /**
     * Set ProductTraceID value
     * @param \Gek\UyumBahce\StructType\ProductTraceIDType $productTraceID
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setProductTraceID(\Gek\UyumBahce\StructType\ProductTraceIDType $productTraceID = null)
    {
        $this->ProductTraceID = $productTraceID;
        return $this;
    }
    /**
     * Get ManufactureDate value
     * @return \Gek\UyumBahce\StructType\ManufactureDateType|null
     */
    public function getManufactureDate()
    {
        return $this->ManufactureDate;
    }
    /**
     * Set ManufactureDate value
     * @param \Gek\UyumBahce\StructType\ManufactureDateType $manufactureDate
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setManufactureDate(\Gek\UyumBahce\StructType\ManufactureDateType $manufactureDate = null)
    {
        $this->ManufactureDate = $manufactureDate;
        return $this;
    }
    /**
     * Get ManufactureTime value
     * @return \Gek\UyumBahce\StructType\ManufactureTimeType|null
     */
    public function getManufactureTime()
    {
        return $this->ManufactureTime;
    }
    /**
     * Set ManufactureTime value
     * @param \Gek\UyumBahce\StructType\ManufactureTimeType $manufactureTime
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setManufactureTime(\Gek\UyumBahce\StructType\ManufactureTimeType $manufactureTime = null)
    {
        $this->ManufactureTime = $manufactureTime;
        return $this;
    }
    /**
     * Get BestBeforeDate value
     * @return \Gek\UyumBahce\StructType\BestBeforeDateType|null
     */
    public function getBestBeforeDate()
    {
        return $this->BestBeforeDate;
    }
    /**
     * Set BestBeforeDate value
     * @param \Gek\UyumBahce\StructType\BestBeforeDateType $bestBeforeDate
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setBestBeforeDate(\Gek\UyumBahce\StructType\BestBeforeDateType $bestBeforeDate = null)
    {
        $this->BestBeforeDate = $bestBeforeDate;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return \Gek\UyumBahce\StructType\RegistrationIDType|null
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param \Gek\UyumBahce\StructType\RegistrationIDType $registrationID
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setRegistrationID(\Gek\UyumBahce\StructType\RegistrationIDType $registrationID = null)
    {
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get SerialID value
     * @return \Gek\UyumBahce\StructType\SerialIDType|null
     */
    public function getSerialID()
    {
        return $this->SerialID;
    }
    /**
     * Set SerialID value
     * @param \Gek\UyumBahce\StructType\SerialIDType $serialID
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setSerialID(\Gek\UyumBahce\StructType\SerialIDType $serialID = null)
    {
        $this->SerialID = $serialID;
        return $this;
    }
    /**
     * Get AdditionalItemProperty value
     * @return \Gek\UyumBahce\StructType\ItemPropertyType[]|null
     */
    public function getAdditionalItemProperty()
    {
        return $this->AdditionalItemProperty;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalItemProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalItemProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemInstanceTypeAdditionalItemPropertyItem) {
            // validation for constraint: itemType
            if (!$itemInstanceTypeAdditionalItemPropertyItem instanceof \Gek\UyumBahce\StructType\ItemPropertyType) {
                $invalidValues[] = is_object($itemInstanceTypeAdditionalItemPropertyItem) ? get_class($itemInstanceTypeAdditionalItemPropertyItem) : sprintf('%s(%s)', gettype($itemInstanceTypeAdditionalItemPropertyItem), var_export($itemInstanceTypeAdditionalItemPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalItemProperty property can only contain items of type \Gek\UyumBahce\StructType\ItemPropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemPropertyType[] $additionalItemProperty
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setAdditionalItemProperty(array $additionalItemProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalItemPropertyArrayErrorMessage = self::validateAdditionalItemPropertyForArrayConstraintsFromSetAdditionalItemProperty($additionalItemProperty))) {
            throw new \InvalidArgumentException($additionalItemPropertyArrayErrorMessage, __LINE__);
        }
        $this->AdditionalItemProperty = $additionalItemProperty;
        return $this;
    }
    /**
     * Add item to AdditionalItemProperty value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemPropertyType $item
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function addToAdditionalItemProperty(\Gek\UyumBahce\StructType\ItemPropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ItemPropertyType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalItemProperty property can only contain items of type \Gek\UyumBahce\StructType\ItemPropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalItemProperty[] = $item;
        return $this;
    }
    /**
     * Get LotIdentification value
     * @return \Gek\UyumBahce\StructType\LotIdentificationType|null
     */
    public function getLotIdentification()
    {
        return $this->LotIdentification;
    }
    /**
     * Set LotIdentification value
     * @param \Gek\UyumBahce\StructType\LotIdentificationType $lotIdentification
     * @return \Gek\UyumBahce\StructType\ItemInstanceType
     */
    public function setLotIdentification(\Gek\UyumBahce\StructType\LotIdentificationType $lotIdentification = null)
    {
        $this->LotIdentification = $lotIdentification;
        return $this;
    }
}
