<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDetailDef StructType
 * @subpackage Structs
 */
class ItemDetailDef extends TransactionalDetailFields
{
    /**
     * The ReasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReasonId;
    /**
     * The IsLotGenerate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsLotGenerate;
    /**
     * The SerialNoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\ArrayType\ArrayOfString
     */
    public $SerialNoList;
    /**
     * Constructor method for ItemDetailDef
     * @uses ItemDetailDef::setReasonId()
     * @uses ItemDetailDef::setIsLotGenerate()
     * @uses ItemDetailDef::setSerialNoList()
     * @param int $reasonId
     * @param bool $isLotGenerate
     * @param \Gek\UyumBahce\ArrayType\ArrayOfString $serialNoList
     */
    public function __construct($reasonId = null, $isLotGenerate = null, \Gek\UyumBahce\ArrayType\ArrayOfString $serialNoList = null)
    {
        $this
            ->setReasonId($reasonId)
            ->setIsLotGenerate($isLotGenerate)
            ->setSerialNoList($serialNoList);
    }
    /**
     * Get ReasonId value
     * @return int
     */
    public function getReasonId()
    {
        return $this->ReasonId;
    }
    /**
     * Set ReasonId value
     * @param int $reasonId
     * @return \Gek\UyumBahce\StructType\ItemDetailDef
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: int
        if (!is_null($reasonId) && !(is_int($reasonId) || ctype_digit($reasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reasonId, true), gettype($reasonId)), __LINE__);
        }
        $this->ReasonId = $reasonId;
        return $this;
    }
    /**
     * Get IsLotGenerate value
     * @return bool
     */
    public function getIsLotGenerate()
    {
        return $this->IsLotGenerate;
    }
    /**
     * Set IsLotGenerate value
     * @param bool $isLotGenerate
     * @return \Gek\UyumBahce\StructType\ItemDetailDef
     */
    public function setIsLotGenerate($isLotGenerate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLotGenerate) && !is_bool($isLotGenerate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLotGenerate, true), gettype($isLotGenerate)), __LINE__);
        }
        $this->IsLotGenerate = $isLotGenerate;
        return $this;
    }
    /**
     * Get SerialNoList value
     * @return \Gek\UyumBahce\ArrayType\ArrayOfString|null
     */
    public function getSerialNoList()
    {
        return $this->SerialNoList;
    }
    /**
     * Set SerialNoList value
     * @param \Gek\UyumBahce\ArrayType\ArrayOfString $serialNoList
     * @return \Gek\UyumBahce\StructType\ItemDetailDef
     */
    public function setSerialNoList(\Gek\UyumBahce\ArrayType\ArrayOfString $serialNoList = null)
    {
        $this->SerialNoList = $serialNoList;
        return $this;
    }
}
