<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceType StructType
 * @subpackage Structs
 */
class InvoiceType extends AbstractStructBase
{
    /**
     * The UBLExtensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s2:UBLExtensions
     * @var \Gek\UyumBahce\ArrayType\ArrayOfUBLExtensionType
     */
    public $UBLExtensions;
    /**
     * The UBLVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:UBLVersionID
     * @var \Gek\UyumBahce\StructType\UBLVersionIDType
     */
    public $UBLVersionID;
    /**
     * The CustomizationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomizationID
     * @var \Gek\UyumBahce\StructType\CustomizationIDType
     */
    public $CustomizationID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ProfileID
     * @var \Gek\UyumBahce\StructType\ProfileIDType
     */
    public $ProfileID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CopyIndicator
     * @var \Gek\UyumBahce\StructType\CopyIndicatorType
     */
    public $CopyIndicator;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:UUID
     * @var \Gek\UyumBahce\StructType\UUIDType
     */
    public $UUID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IssueDate
     * @var \Gek\UyumBahce\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IssueTime
     * @var \Gek\UyumBahce\StructType\IssueTimeType
     */
    public $IssueTime;
    /**
     * The InvoiceTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InvoiceTypeCode
     * @var \Gek\UyumBahce\StructType\InvoiceTypeCodeType
     */
    public $InvoiceTypeCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Note
     * @var \Gek\UyumBahce\StructType\NoteType[]
     */
    public $Note;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DocumentCurrencyCode
     * @var \Gek\UyumBahce\StructType\DocumentCurrencyCodeType
     */
    public $DocumentCurrencyCode;
    /**
     * The TaxCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxCurrencyCode
     * @var \Gek\UyumBahce\StructType\TaxCurrencyCodeType
     */
    public $TaxCurrencyCode;
    /**
     * The PricingCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PricingCurrencyCode
     * @var \Gek\UyumBahce\StructType\PricingCurrencyCodeType
     */
    public $PricingCurrencyCode;
    /**
     * The PaymentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentCurrencyCode
     * @var \Gek\UyumBahce\StructType\PaymentCurrencyCodeType
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentAlternativeCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentAlternativeCurrencyCode
     * @var \Gek\UyumBahce\StructType\PaymentAlternativeCurrencyCodeType
     */
    public $PaymentAlternativeCurrencyCode;
    /**
     * The AccountingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AccountingCost
     * @var \Gek\UyumBahce\StructType\AccountingCostType
     */
    public $AccountingCost;
    /**
     * The LineCountNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineCountNumeric
     * @var \Gek\UyumBahce\StructType\LineCountNumericType
     */
    public $LineCountNumeric;
    /**
     * The InvoicePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:InvoicePeriod
     * @var \Gek\UyumBahce\StructType\PeriodType
     */
    public $InvoicePeriod;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:OrderReference
     * @var \Gek\UyumBahce\StructType\OrderReferenceType
     */
    public $OrderReference;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:BillingReference
     * @var \Gek\UyumBahce\StructType\BillingReferenceType[]
     */
    public $BillingReference;
    /**
     * The DespatchDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:DespatchDocumentReference
     * @var \Gek\UyumBahce\StructType\DocumentReferenceType[]
     */
    public $DespatchDocumentReference;
    /**
     * The ReceiptDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:ReceiptDocumentReference
     * @var \Gek\UyumBahce\StructType\DocumentReferenceType[]
     */
    public $ReceiptDocumentReference;
    /**
     * The OriginatorDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:OriginatorDocumentReference
     * @var \Gek\UyumBahce\StructType\DocumentReferenceType[]
     */
    public $OriginatorDocumentReference;
    /**
     * The ContractDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:ContractDocumentReference
     * @var \Gek\UyumBahce\StructType\DocumentReferenceType[]
     */
    public $ContractDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:AdditionalDocumentReference
     * @var \Gek\UyumBahce\StructType\DocumentReferenceType[]
     */
    public $AdditionalDocumentReference;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:Signature
     * @var \Gek\UyumBahce\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The AccountingSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:AccountingSupplierParty
     * @var \Gek\UyumBahce\StructType\SupplierPartyType
     */
    public $AccountingSupplierParty;
    /**
     * The AccountingCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:AccountingCustomerParty
     * @var \Gek\UyumBahce\StructType\CustomerPartyType
     */
    public $AccountingCustomerParty;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:BuyerCustomerParty
     * @var \Gek\UyumBahce\StructType\CustomerPartyType
     */
    public $BuyerCustomerParty;
    /**
     * The SellerSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:SellerSupplierParty
     * @var \Gek\UyumBahce\StructType\SupplierPartyType
     */
    public $SellerSupplierParty;
    /**
     * The TaxRepresentativeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:TaxRepresentativeParty
     * @var \Gek\UyumBahce\StructType\PartyType
     */
    public $TaxRepresentativeParty;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:Delivery
     * @var \Gek\UyumBahce\StructType\DeliveryType[]
     */
    public $Delivery;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:PaymentMeans
     * @var \Gek\UyumBahce\StructType\PaymentMeansType[]
     */
    public $PaymentMeans;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PaymentTerms
     * @var \Gek\UyumBahce\StructType\PaymentTermsType
     */
    public $PaymentTerms;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:AllowanceCharge
     * @var \Gek\UyumBahce\StructType\AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:TaxExchangeRate
     * @var \Gek\UyumBahce\StructType\ExchangeRateType
     */
    public $TaxExchangeRate;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PricingExchangeRate
     * @var \Gek\UyumBahce\StructType\ExchangeRateType
     */
    public $PricingExchangeRate;
    /**
     * The PaymentExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PaymentExchangeRate
     * @var \Gek\UyumBahce\StructType\ExchangeRateType
     */
    public $PaymentExchangeRate;
    /**
     * The PaymentAlternativeExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PaymentAlternativeExchangeRate
     * @var \Gek\UyumBahce\StructType\ExchangeRateType
     */
    public $PaymentAlternativeExchangeRate;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:TaxTotal
     * @var \Gek\UyumBahce\StructType\TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:WithholdingTaxTotal
     * @var \Gek\UyumBahce\StructType\TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The LegalMonetaryTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:LegalMonetaryTotal
     * @var \Gek\UyumBahce\StructType\MonetaryTotalType
     */
    public $LegalMonetaryTotal;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:InvoiceLine
     * @var \Gek\UyumBahce\StructType\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The schemaLocation
     * @var string
     */
    public $schemaLocation;
    /**
     * Constructor method for InvoiceType
     * @uses InvoiceType::setUBLExtensions()
     * @uses InvoiceType::setUBLVersionID()
     * @uses InvoiceType::setCustomizationID()
     * @uses InvoiceType::setProfileID()
     * @uses InvoiceType::setID()
     * @uses InvoiceType::setCopyIndicator()
     * @uses InvoiceType::setUUID()
     * @uses InvoiceType::setIssueDate()
     * @uses InvoiceType::setIssueTime()
     * @uses InvoiceType::setInvoiceTypeCode()
     * @uses InvoiceType::setNote()
     * @uses InvoiceType::setDocumentCurrencyCode()
     * @uses InvoiceType::setTaxCurrencyCode()
     * @uses InvoiceType::setPricingCurrencyCode()
     * @uses InvoiceType::setPaymentCurrencyCode()
     * @uses InvoiceType::setPaymentAlternativeCurrencyCode()
     * @uses InvoiceType::setAccountingCost()
     * @uses InvoiceType::setLineCountNumeric()
     * @uses InvoiceType::setInvoicePeriod()
     * @uses InvoiceType::setOrderReference()
     * @uses InvoiceType::setBillingReference()
     * @uses InvoiceType::setDespatchDocumentReference()
     * @uses InvoiceType::setReceiptDocumentReference()
     * @uses InvoiceType::setOriginatorDocumentReference()
     * @uses InvoiceType::setContractDocumentReference()
     * @uses InvoiceType::setAdditionalDocumentReference()
     * @uses InvoiceType::setSignature()
     * @uses InvoiceType::setAccountingSupplierParty()
     * @uses InvoiceType::setAccountingCustomerParty()
     * @uses InvoiceType::setBuyerCustomerParty()
     * @uses InvoiceType::setSellerSupplierParty()
     * @uses InvoiceType::setTaxRepresentativeParty()
     * @uses InvoiceType::setDelivery()
     * @uses InvoiceType::setPaymentMeans()
     * @uses InvoiceType::setPaymentTerms()
     * @uses InvoiceType::setAllowanceCharge()
     * @uses InvoiceType::setTaxExchangeRate()
     * @uses InvoiceType::setPricingExchangeRate()
     * @uses InvoiceType::setPaymentExchangeRate()
     * @uses InvoiceType::setPaymentAlternativeExchangeRate()
     * @uses InvoiceType::setTaxTotal()
     * @uses InvoiceType::setWithholdingTaxTotal()
     * @uses InvoiceType::setLegalMonetaryTotal()
     * @uses InvoiceType::setInvoiceLine()
     * @uses InvoiceType::setSchemaLocation()
     * @param \Gek\UyumBahce\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @param \Gek\UyumBahce\StructType\UBLVersionIDType $uBLVersionID
     * @param \Gek\UyumBahce\StructType\CustomizationIDType $customizationID
     * @param \Gek\UyumBahce\StructType\ProfileIDType $profileID
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\CopyIndicatorType $copyIndicator
     * @param \Gek\UyumBahce\StructType\UUIDType $uUID
     * @param \Gek\UyumBahce\StructType\IssueDateType $issueDate
     * @param \Gek\UyumBahce\StructType\IssueTimeType $issueTime
     * @param \Gek\UyumBahce\StructType\InvoiceTypeCodeType $invoiceTypeCode
     * @param \Gek\UyumBahce\StructType\NoteType[] $note
     * @param \Gek\UyumBahce\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @param \Gek\UyumBahce\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @param \Gek\UyumBahce\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @param \Gek\UyumBahce\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @param \Gek\UyumBahce\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @param \Gek\UyumBahce\StructType\AccountingCostType $accountingCost
     * @param \Gek\UyumBahce\StructType\LineCountNumericType $lineCountNumeric
     * @param \Gek\UyumBahce\StructType\PeriodType $invoicePeriod
     * @param \Gek\UyumBahce\StructType\OrderReferenceType $orderReference
     * @param \Gek\UyumBahce\StructType\BillingReferenceType[] $billingReference
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $contractDocumentReference
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @param \Gek\UyumBahce\StructType\SignatureType[] $signature
     * @param \Gek\UyumBahce\StructType\SupplierPartyType $accountingSupplierParty
     * @param \Gek\UyumBahce\StructType\CustomerPartyType $accountingCustomerParty
     * @param \Gek\UyumBahce\StructType\CustomerPartyType $buyerCustomerParty
     * @param \Gek\UyumBahce\StructType\SupplierPartyType $sellerSupplierParty
     * @param \Gek\UyumBahce\StructType\PartyType $taxRepresentativeParty
     * @param \Gek\UyumBahce\StructType\DeliveryType[] $delivery
     * @param \Gek\UyumBahce\StructType\PaymentMeansType[] $paymentMeans
     * @param \Gek\UyumBahce\StructType\PaymentTermsType $paymentTerms
     * @param \Gek\UyumBahce\StructType\AllowanceChargeType[] $allowanceCharge
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $taxExchangeRate
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $pricingExchangeRate
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $paymentExchangeRate
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @param \Gek\UyumBahce\StructType\TaxTotalType[] $taxTotal
     * @param \Gek\UyumBahce\StructType\TaxTotalType[] $withholdingTaxTotal
     * @param \Gek\UyumBahce\StructType\MonetaryTotalType $legalMonetaryTotal
     * @param \Gek\UyumBahce\StructType\InvoiceLineType[] $invoiceLine
     * @param string $schemaLocation
     */
    public function __construct(\Gek\UyumBahce\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null, \Gek\UyumBahce\StructType\UBLVersionIDType $uBLVersionID = null, \Gek\UyumBahce\StructType\CustomizationIDType $customizationID = null, \Gek\UyumBahce\StructType\ProfileIDType $profileID = null, \Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\CopyIndicatorType $copyIndicator = null, \Gek\UyumBahce\StructType\UUIDType $uUID = null, \Gek\UyumBahce\StructType\IssueDateType $issueDate = null, \Gek\UyumBahce\StructType\IssueTimeType $issueTime = null, \Gek\UyumBahce\StructType\InvoiceTypeCodeType $invoiceTypeCode = null, array $note = array(), \Gek\UyumBahce\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null, \Gek\UyumBahce\StructType\TaxCurrencyCodeType $taxCurrencyCode = null, \Gek\UyumBahce\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null, \Gek\UyumBahce\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null, \Gek\UyumBahce\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null, \Gek\UyumBahce\StructType\AccountingCostType $accountingCost = null, \Gek\UyumBahce\StructType\LineCountNumericType $lineCountNumeric = null, \Gek\UyumBahce\StructType\PeriodType $invoicePeriod = null, \Gek\UyumBahce\StructType\OrderReferenceType $orderReference = null, array $billingReference = array(), array $despatchDocumentReference = array(), array $receiptDocumentReference = array(), array $originatorDocumentReference = array(), array $contractDocumentReference = array(), array $additionalDocumentReference = array(), array $signature = array(), \Gek\UyumBahce\StructType\SupplierPartyType $accountingSupplierParty = null, \Gek\UyumBahce\StructType\CustomerPartyType $accountingCustomerParty = null, \Gek\UyumBahce\StructType\CustomerPartyType $buyerCustomerParty = null, \Gek\UyumBahce\StructType\SupplierPartyType $sellerSupplierParty = null, \Gek\UyumBahce\StructType\PartyType $taxRepresentativeParty = null, array $delivery = array(), array $paymentMeans = array(), \Gek\UyumBahce\StructType\PaymentTermsType $paymentTerms = null, array $allowanceCharge = array(), \Gek\UyumBahce\StructType\ExchangeRateType $taxExchangeRate = null, \Gek\UyumBahce\StructType\ExchangeRateType $pricingExchangeRate = null, \Gek\UyumBahce\StructType\ExchangeRateType $paymentExchangeRate = null, \Gek\UyumBahce\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null, array $taxTotal = array(), array $withholdingTaxTotal = array(), \Gek\UyumBahce\StructType\MonetaryTotalType $legalMonetaryTotal = null, array $invoiceLine = array(), $schemaLocation = null)
    {
        $this
            ->setUBLExtensions($uBLExtensions)
            ->setUBLVersionID($uBLVersionID)
            ->setCustomizationID($customizationID)
            ->setProfileID($profileID)
            ->setID($iD)
            ->setCopyIndicator($copyIndicator)
            ->setUUID($uUID)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setNote($note)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setPricingCurrencyCode($pricingCurrencyCode)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode)
            ->setAccountingCost($accountingCost)
            ->setLineCountNumeric($lineCountNumeric)
            ->setInvoicePeriod($invoicePeriod)
            ->setOrderReference($orderReference)
            ->setBillingReference($billingReference)
            ->setDespatchDocumentReference($despatchDocumentReference)
            ->setReceiptDocumentReference($receiptDocumentReference)
            ->setOriginatorDocumentReference($originatorDocumentReference)
            ->setContractDocumentReference($contractDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setSignature($signature)
            ->setAccountingSupplierParty($accountingSupplierParty)
            ->setAccountingCustomerParty($accountingCustomerParty)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setSellerSupplierParty($sellerSupplierParty)
            ->setTaxRepresentativeParty($taxRepresentativeParty)
            ->setDelivery($delivery)
            ->setPaymentMeans($paymentMeans)
            ->setPaymentTerms($paymentTerms)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxExchangeRate($taxExchangeRate)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setPaymentExchangeRate($paymentExchangeRate)
            ->setPaymentAlternativeExchangeRate($paymentAlternativeExchangeRate)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setLegalMonetaryTotal($legalMonetaryTotal)
            ->setInvoiceLine($invoiceLine)
            ->setSchemaLocation($schemaLocation);
    }
    /**
     * Get UBLExtensions value
     * @return \Gek\UyumBahce\ArrayType\ArrayOfUBLExtensionType|null
     */
    public function getUBLExtensions()
    {
        return $this->UBLExtensions;
    }
    /**
     * Set UBLExtensions value
     * @param \Gek\UyumBahce\ArrayType\ArrayOfUBLExtensionType $uBLExtensions
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setUBLExtensions(\Gek\UyumBahce\ArrayType\ArrayOfUBLExtensionType $uBLExtensions = null)
    {
        $this->UBLExtensions = $uBLExtensions;
        return $this;
    }
    /**
     * Get UBLVersionID value
     * @return \Gek\UyumBahce\StructType\UBLVersionIDType|null
     */
    public function getUBLVersionID()
    {
        return $this->UBLVersionID;
    }
    /**
     * Set UBLVersionID value
     * @param \Gek\UyumBahce\StructType\UBLVersionIDType $uBLVersionID
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setUBLVersionID(\Gek\UyumBahce\StructType\UBLVersionIDType $uBLVersionID = null)
    {
        $this->UBLVersionID = $uBLVersionID;
        return $this;
    }
    /**
     * Get CustomizationID value
     * @return \Gek\UyumBahce\StructType\CustomizationIDType|null
     */
    public function getCustomizationID()
    {
        return $this->CustomizationID;
    }
    /**
     * Set CustomizationID value
     * @param \Gek\UyumBahce\StructType\CustomizationIDType $customizationID
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setCustomizationID(\Gek\UyumBahce\StructType\CustomizationIDType $customizationID = null)
    {
        $this->CustomizationID = $customizationID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return \Gek\UyumBahce\StructType\ProfileIDType|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param \Gek\UyumBahce\StructType\ProfileIDType $profileID
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setProfileID(\Gek\UyumBahce\StructType\ProfileIDType $profileID = null)
    {
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return \Gek\UyumBahce\StructType\CopyIndicatorType|null
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param \Gek\UyumBahce\StructType\CopyIndicatorType $copyIndicator
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setCopyIndicator(\Gek\UyumBahce\StructType\CopyIndicatorType $copyIndicator = null)
    {
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get UUID value
     * @return \Gek\UyumBahce\StructType\UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \Gek\UyumBahce\StructType\UUIDType $uUID
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setUUID(\Gek\UyumBahce\StructType\UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Gek\UyumBahce\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Gek\UyumBahce\StructType\IssueDateType $issueDate
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setIssueDate(\Gek\UyumBahce\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return \Gek\UyumBahce\StructType\IssueTimeType|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param \Gek\UyumBahce\StructType\IssueTimeType $issueTime
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setIssueTime(\Gek\UyumBahce\StructType\IssueTimeType $issueTime = null)
    {
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return \Gek\UyumBahce\StructType\InvoiceTypeCodeType|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param \Gek\UyumBahce\StructType\InvoiceTypeCodeType $invoiceTypeCode
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setInvoiceTypeCode(\Gek\UyumBahce\StructType\InvoiceTypeCodeType $invoiceTypeCode = null)
    {
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get Note value
     * @return \Gek\UyumBahce\StructType\NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeNoteItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeNoteItem instanceof \Gek\UyumBahce\StructType\NoteType) {
                $invalidValues[] = is_object($invoiceTypeNoteItem) ? get_class($invoiceTypeNoteItem) : sprintf('%s(%s)', gettype($invoiceTypeNoteItem), var_export($invoiceTypeNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \Gek\UyumBahce\StructType\NoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\NoteType[] $note
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new \InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\NoteType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToNote(\Gek\UyumBahce\StructType\NoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\NoteType) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of type \Gek\UyumBahce\StructType\NoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Get DocumentCurrencyCode value
     * @return \Gek\UyumBahce\StructType\DocumentCurrencyCodeType|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }
    /**
     * Set DocumentCurrencyCode value
     * @param \Gek\UyumBahce\StructType\DocumentCurrencyCodeType $documentCurrencyCode
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setDocumentCurrencyCode(\Gek\UyumBahce\StructType\DocumentCurrencyCodeType $documentCurrencyCode = null)
    {
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }
    /**
     * Get TaxCurrencyCode value
     * @return \Gek\UyumBahce\StructType\TaxCurrencyCodeType|null
     */
    public function getTaxCurrencyCode()
    {
        return $this->TaxCurrencyCode;
    }
    /**
     * Set TaxCurrencyCode value
     * @param \Gek\UyumBahce\StructType\TaxCurrencyCodeType $taxCurrencyCode
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setTaxCurrencyCode(\Gek\UyumBahce\StructType\TaxCurrencyCodeType $taxCurrencyCode = null)
    {
        $this->TaxCurrencyCode = $taxCurrencyCode;
        return $this;
    }
    /**
     * Get PricingCurrencyCode value
     * @return \Gek\UyumBahce\StructType\PricingCurrencyCodeType|null
     */
    public function getPricingCurrencyCode()
    {
        return $this->PricingCurrencyCode;
    }
    /**
     * Set PricingCurrencyCode value
     * @param \Gek\UyumBahce\StructType\PricingCurrencyCodeType $pricingCurrencyCode
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPricingCurrencyCode(\Gek\UyumBahce\StructType\PricingCurrencyCodeType $pricingCurrencyCode = null)
    {
        $this->PricingCurrencyCode = $pricingCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentCurrencyCode value
     * @return \Gek\UyumBahce\StructType\PaymentCurrencyCodeType|null
     */
    public function getPaymentCurrencyCode()
    {
        return $this->PaymentCurrencyCode;
    }
    /**
     * Set PaymentCurrencyCode value
     * @param \Gek\UyumBahce\StructType\PaymentCurrencyCodeType $paymentCurrencyCode
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPaymentCurrencyCode(\Gek\UyumBahce\StructType\PaymentCurrencyCodeType $paymentCurrencyCode = null)
    {
        $this->PaymentCurrencyCode = $paymentCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentAlternativeCurrencyCode value
     * @return \Gek\UyumBahce\StructType\PaymentAlternativeCurrencyCodeType|null
     */
    public function getPaymentAlternativeCurrencyCode()
    {
        return $this->PaymentAlternativeCurrencyCode;
    }
    /**
     * Set PaymentAlternativeCurrencyCode value
     * @param \Gek\UyumBahce\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPaymentAlternativeCurrencyCode(\Gek\UyumBahce\StructType\PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null)
    {
        $this->PaymentAlternativeCurrencyCode = $paymentAlternativeCurrencyCode;
        return $this;
    }
    /**
     * Get AccountingCost value
     * @return \Gek\UyumBahce\StructType\AccountingCostType|null
     */
    public function getAccountingCost()
    {
        return $this->AccountingCost;
    }
    /**
     * Set AccountingCost value
     * @param \Gek\UyumBahce\StructType\AccountingCostType $accountingCost
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setAccountingCost(\Gek\UyumBahce\StructType\AccountingCostType $accountingCost = null)
    {
        $this->AccountingCost = $accountingCost;
        return $this;
    }
    /**
     * Get LineCountNumeric value
     * @return \Gek\UyumBahce\StructType\LineCountNumericType|null
     */
    public function getLineCountNumeric()
    {
        return $this->LineCountNumeric;
    }
    /**
     * Set LineCountNumeric value
     * @param \Gek\UyumBahce\StructType\LineCountNumericType $lineCountNumeric
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setLineCountNumeric(\Gek\UyumBahce\StructType\LineCountNumericType $lineCountNumeric = null)
    {
        $this->LineCountNumeric = $lineCountNumeric;
        return $this;
    }
    /**
     * Get InvoicePeriod value
     * @return \Gek\UyumBahce\StructType\PeriodType|null
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }
    /**
     * Set InvoicePeriod value
     * @param \Gek\UyumBahce\StructType\PeriodType $invoicePeriod
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setInvoicePeriod(\Gek\UyumBahce\StructType\PeriodType $invoicePeriod = null)
    {
        $this->InvoicePeriod = $invoicePeriod;
        return $this;
    }
    /**
     * Get OrderReference value
     * @return \Gek\UyumBahce\StructType\OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }
    /**
     * Set OrderReference value
     * @param \Gek\UyumBahce\StructType\OrderReferenceType $orderReference
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setOrderReference(\Gek\UyumBahce\StructType\OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
    /**
     * Get BillingReference value
     * @return \Gek\UyumBahce\StructType\BillingReferenceType[]|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingReferenceForArrayConstraintsFromSetBillingReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeBillingReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeBillingReferenceItem instanceof \Gek\UyumBahce\StructType\BillingReferenceType) {
                $invalidValues[] = is_object($invoiceTypeBillingReferenceItem) ? get_class($invoiceTypeBillingReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeBillingReferenceItem), var_export($invoiceTypeBillingReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillingReference property can only contain items of type \Gek\UyumBahce\StructType\BillingReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillingReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\BillingReferenceType[] $billingReference
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setBillingReference(array $billingReference = array())
    {
        // validation for constraint: array
        if ('' !== ($billingReferenceArrayErrorMessage = self::validateBillingReferenceForArrayConstraintsFromSetBillingReference($billingReference))) {
            throw new \InvalidArgumentException($billingReferenceArrayErrorMessage, __LINE__);
        }
        $this->BillingReference = $billingReference;
        return $this;
    }
    /**
     * Add item to BillingReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\BillingReferenceType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToBillingReference(\Gek\UyumBahce\StructType\BillingReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\BillingReferenceType) {
            throw new \InvalidArgumentException(sprintf('The BillingReference property can only contain items of type \Gek\UyumBahce\StructType\BillingReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillingReference[] = $item;
        return $this;
    }
    /**
     * Get DespatchDocumentReference value
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType[]|null
     */
    public function getDespatchDocumentReference()
    {
        return $this->DespatchDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setDespatchDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeDespatchDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeDespatchDocumentReferenceItem instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeDespatchDocumentReferenceItem) ? get_class($invoiceTypeDespatchDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeDespatchDocumentReferenceItem), var_export($invoiceTypeDespatchDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $despatchDocumentReference
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setDespatchDocumentReference(array $despatchDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchDocumentReferenceArrayErrorMessage = self::validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference($despatchDocumentReference))) {
            throw new \InvalidArgumentException($despatchDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->DespatchDocumentReference = $despatchDocumentReference;
        return $this;
    }
    /**
     * Add item to DespatchDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToDespatchDocumentReference(\Gek\UyumBahce\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The DespatchDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ReceiptDocumentReference value
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType[]|null
     */
    public function getReceiptDocumentReference()
    {
        return $this->ReceiptDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiptDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeReceiptDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeReceiptDocumentReferenceItem instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeReceiptDocumentReferenceItem) ? get_class($invoiceTypeReceiptDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeReceiptDocumentReferenceItem), var_export($invoiceTypeReceiptDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiptDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $receiptDocumentReference
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setReceiptDocumentReference(array $receiptDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptDocumentReferenceArrayErrorMessage = self::validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference($receiptDocumentReference))) {
            throw new \InvalidArgumentException($receiptDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ReceiptDocumentReference = $receiptDocumentReference;
        return $this;
    }
    /**
     * Add item to ReceiptDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToReceiptDocumentReference(\Gek\UyumBahce\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ReceiptDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiptDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get OriginatorDocumentReference value
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType[]|null
     */
    public function getOriginatorDocumentReference()
    {
        return $this->OriginatorDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginatorDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginatorDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeOriginatorDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeOriginatorDocumentReferenceItem instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeOriginatorDocumentReferenceItem) ? get_class($invoiceTypeOriginatorDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeOriginatorDocumentReferenceItem), var_export($invoiceTypeOriginatorDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginatorDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $originatorDocumentReference
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setOriginatorDocumentReference(array $originatorDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($originatorDocumentReferenceArrayErrorMessage = self::validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference($originatorDocumentReference))) {
            throw new \InvalidArgumentException($originatorDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->OriginatorDocumentReference = $originatorDocumentReference;
        return $this;
    }
    /**
     * Add item to OriginatorDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToOriginatorDocumentReference(\Gek\UyumBahce\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The OriginatorDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginatorDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get ContractDocumentReference value
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType[]|null
     */
    public function getContractDocumentReference()
    {
        return $this->ContractDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setContractDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeContractDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeContractDocumentReferenceItem instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeContractDocumentReferenceItem) ? get_class($invoiceTypeContractDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeContractDocumentReferenceItem), var_export($invoiceTypeContractDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContractDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $contractDocumentReference
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setContractDocumentReference(array $contractDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($contractDocumentReferenceArrayErrorMessage = self::validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference($contractDocumentReference))) {
            throw new \InvalidArgumentException($contractDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ContractDocumentReference = $contractDocumentReference;
        return $this;
    }
    /**
     * Add item to ContractDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToContractDocumentReference(\Gek\UyumBahce\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The ContractDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContractDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType[]|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeAdditionalDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeAdditionalDocumentReferenceItem instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeAdditionalDocumentReferenceItem) ? get_class($invoiceTypeAdditionalDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeAdditionalDocumentReferenceItem), var_export($invoiceTypeAdditionalDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType[] $additionalDocumentReference
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setAdditionalDocumentReference(array $additionalDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalDocumentReferenceArrayErrorMessage = self::validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference($additionalDocumentReference))) {
            throw new \InvalidArgumentException($additionalDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }
    /**
     * Add item to AdditionalDocumentReference value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentReferenceType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToAdditionalDocumentReference(\Gek\UyumBahce\StructType\DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DocumentReferenceType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalDocumentReference[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \Gek\UyumBahce\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * This method is responsible for validating the values passed to the setSignature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignatureForArrayConstraintsFromSetSignature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeSignatureItem instanceof \Gek\UyumBahce\StructType\SignatureType) {
                $invalidValues[] = is_object($invoiceTypeSignatureItem) ? get_class($invoiceTypeSignatureItem) : sprintf('%s(%s)', gettype($invoiceTypeSignatureItem), var_export($invoiceTypeSignatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Signature property can only contain items of type \Gek\UyumBahce\StructType\SignatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\SignatureType[] $signature
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setSignature(array $signature = array())
    {
        // validation for constraint: array
        if ('' !== ($signatureArrayErrorMessage = self::validateSignatureForArrayConstraintsFromSetSignature($signature))) {
            throw new \InvalidArgumentException($signatureArrayErrorMessage, __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\SignatureType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToSignature(\Gek\UyumBahce\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of type \Gek\UyumBahce\StructType\SignatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get AccountingSupplierParty value
     * @return \Gek\UyumBahce\StructType\SupplierPartyType|null
     */
    public function getAccountingSupplierParty()
    {
        return $this->AccountingSupplierParty;
    }
    /**
     * Set AccountingSupplierParty value
     * @param \Gek\UyumBahce\StructType\SupplierPartyType $accountingSupplierParty
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setAccountingSupplierParty(\Gek\UyumBahce\StructType\SupplierPartyType $accountingSupplierParty = null)
    {
        $this->AccountingSupplierParty = $accountingSupplierParty;
        return $this;
    }
    /**
     * Get AccountingCustomerParty value
     * @return \Gek\UyumBahce\StructType\CustomerPartyType|null
     */
    public function getAccountingCustomerParty()
    {
        return $this->AccountingCustomerParty;
    }
    /**
     * Set AccountingCustomerParty value
     * @param \Gek\UyumBahce\StructType\CustomerPartyType $accountingCustomerParty
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setAccountingCustomerParty(\Gek\UyumBahce\StructType\CustomerPartyType $accountingCustomerParty = null)
    {
        $this->AccountingCustomerParty = $accountingCustomerParty;
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * @return \Gek\UyumBahce\StructType\CustomerPartyType|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }
    /**
     * Set BuyerCustomerParty value
     * @param \Gek\UyumBahce\StructType\CustomerPartyType $buyerCustomerParty
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setBuyerCustomerParty(\Gek\UyumBahce\StructType\CustomerPartyType $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }
    /**
     * Get SellerSupplierParty value
     * @return \Gek\UyumBahce\StructType\SupplierPartyType|null
     */
    public function getSellerSupplierParty()
    {
        return $this->SellerSupplierParty;
    }
    /**
     * Set SellerSupplierParty value
     * @param \Gek\UyumBahce\StructType\SupplierPartyType $sellerSupplierParty
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setSellerSupplierParty(\Gek\UyumBahce\StructType\SupplierPartyType $sellerSupplierParty = null)
    {
        $this->SellerSupplierParty = $sellerSupplierParty;
        return $this;
    }
    /**
     * Get TaxRepresentativeParty value
     * @return \Gek\UyumBahce\StructType\PartyType|null
     */
    public function getTaxRepresentativeParty()
    {
        return $this->TaxRepresentativeParty;
    }
    /**
     * Set TaxRepresentativeParty value
     * @param \Gek\UyumBahce\StructType\PartyType $taxRepresentativeParty
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setTaxRepresentativeParty(\Gek\UyumBahce\StructType\PartyType $taxRepresentativeParty = null)
    {
        $this->TaxRepresentativeParty = $taxRepresentativeParty;
        return $this;
    }
    /**
     * Get Delivery value
     * @return \Gek\UyumBahce\StructType\DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeDeliveryItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeDeliveryItem instanceof \Gek\UyumBahce\StructType\DeliveryType) {
                $invalidValues[] = is_object($invoiceTypeDeliveryItem) ? get_class($invoiceTypeDeliveryItem) : sprintf('%s(%s)', gettype($invoiceTypeDeliveryItem), var_export($invoiceTypeDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \Gek\UyumBahce\StructType\DeliveryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Delivery value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DeliveryType[] $delivery
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new \InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Add item to Delivery value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DeliveryType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToDelivery(\Gek\UyumBahce\StructType\DeliveryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DeliveryType) {
            throw new \InvalidArgumentException(sprintf('The Delivery property can only contain items of type \Gek\UyumBahce\StructType\DeliveryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \Gek\UyumBahce\StructType\PaymentMeansType[]|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMeansForArrayConstraintsFromSetPaymentMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypePaymentMeansItem) {
            // validation for constraint: itemType
            if (!$invoiceTypePaymentMeansItem instanceof \Gek\UyumBahce\StructType\PaymentMeansType) {
                $invalidValues[] = is_object($invoiceTypePaymentMeansItem) ? get_class($invoiceTypePaymentMeansItem) : sprintf('%s(%s)', gettype($invoiceTypePaymentMeansItem), var_export($invoiceTypePaymentMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMeans property can only contain items of type \Gek\UyumBahce\StructType\PaymentMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PaymentMeansType[] $paymentMeans
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPaymentMeans(array $paymentMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMeansArrayErrorMessage = self::validatePaymentMeansForArrayConstraintsFromSetPaymentMeans($paymentMeans))) {
            throw new \InvalidArgumentException($paymentMeansArrayErrorMessage, __LINE__);
        }
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Add item to PaymentMeans value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\PaymentMeansType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToPaymentMeans(\Gek\UyumBahce\StructType\PaymentMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\PaymentMeansType) {
            throw new \InvalidArgumentException(sprintf('The PaymentMeans property can only contain items of type \Gek\UyumBahce\StructType\PaymentMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMeans[] = $item;
        return $this;
    }
    /**
     * Get PaymentTerms value
     * @return \Gek\UyumBahce\StructType\PaymentTermsType|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }
    /**
     * Set PaymentTerms value
     * @param \Gek\UyumBahce\StructType\PaymentTermsType $paymentTerms
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPaymentTerms(\Gek\UyumBahce\StructType\PaymentTermsType $paymentTerms = null)
    {
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * @return \Gek\UyumBahce\StructType\AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeAllowanceChargeItem instanceof \Gek\UyumBahce\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($invoiceTypeAllowanceChargeItem) ? get_class($invoiceTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($invoiceTypeAllowanceChargeItem), var_export($invoiceTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahce\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\AllowanceChargeType[] $allowanceCharge
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to AllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\AllowanceChargeType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToAllowanceCharge(\Gek\UyumBahce\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahce\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get TaxExchangeRate value
     * @return \Gek\UyumBahce\StructType\ExchangeRateType|null
     */
    public function getTaxExchangeRate()
    {
        return $this->TaxExchangeRate;
    }
    /**
     * Set TaxExchangeRate value
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $taxExchangeRate
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setTaxExchangeRate(\Gek\UyumBahce\StructType\ExchangeRateType $taxExchangeRate = null)
    {
        $this->TaxExchangeRate = $taxExchangeRate;
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * @return \Gek\UyumBahce\StructType\ExchangeRateType|null
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }
    /**
     * Set PricingExchangeRate value
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $pricingExchangeRate
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPricingExchangeRate(\Gek\UyumBahce\StructType\ExchangeRateType $pricingExchangeRate = null)
    {
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }
    /**
     * Get PaymentExchangeRate value
     * @return \Gek\UyumBahce\StructType\ExchangeRateType|null
     */
    public function getPaymentExchangeRate()
    {
        return $this->PaymentExchangeRate;
    }
    /**
     * Set PaymentExchangeRate value
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $paymentExchangeRate
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPaymentExchangeRate(\Gek\UyumBahce\StructType\ExchangeRateType $paymentExchangeRate = null)
    {
        $this->PaymentExchangeRate = $paymentExchangeRate;
        return $this;
    }
    /**
     * Get PaymentAlternativeExchangeRate value
     * @return \Gek\UyumBahce\StructType\ExchangeRateType|null
     */
    public function getPaymentAlternativeExchangeRate()
    {
        return $this->PaymentAlternativeExchangeRate;
    }
    /**
     * Set PaymentAlternativeExchangeRate value
     * @param \Gek\UyumBahce\StructType\ExchangeRateType $paymentAlternativeExchangeRate
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setPaymentAlternativeExchangeRate(\Gek\UyumBahce\StructType\ExchangeRateType $paymentAlternativeExchangeRate = null)
    {
        $this->PaymentAlternativeExchangeRate = $paymentAlternativeExchangeRate;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return \Gek\UyumBahce\StructType\TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTotalForArrayConstraintsFromSetTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeTaxTotalItem instanceof \Gek\UyumBahce\StructType\TaxTotalType) {
                $invalidValues[] = is_object($invoiceTypeTaxTotalItem) ? get_class($invoiceTypeTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceTypeTaxTotalItem), var_export($invoiceTypeTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxTotal value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TaxTotalType[] $taxTotal
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTotalArrayErrorMessage = self::validateTaxTotalForArrayConstraintsFromSetTaxTotal($taxTotal))) {
            throw new \InvalidArgumentException($taxTotalArrayErrorMessage, __LINE__);
        }
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Add item to TaxTotal value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TaxTotalType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToTaxTotal(\Gek\UyumBahce\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The TaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxTotal[] = $item;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * @return \Gek\UyumBahce\StructType\TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholdingTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholdingTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeWithholdingTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeWithholdingTaxTotalItem instanceof \Gek\UyumBahce\StructType\TaxTotalType) {
                $invalidValues[] = is_object($invoiceTypeWithholdingTaxTotalItem) ? get_class($invoiceTypeWithholdingTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceTypeWithholdingTaxTotalItem), var_export($invoiceTypeWithholdingTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithholdingTaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TaxTotalType[] $withholdingTaxTotal
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($withholdingTaxTotalArrayErrorMessage = self::validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal($withholdingTaxTotal))) {
            throw new \InvalidArgumentException($withholdingTaxTotalArrayErrorMessage, __LINE__);
        }
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }
    /**
     * Add item to WithholdingTaxTotal value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TaxTotalType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToWithholdingTaxTotal(\Gek\UyumBahce\StructType\TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\TaxTotalType) {
            throw new \InvalidArgumentException(sprintf('The WithholdingTaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }
    /**
     * Get LegalMonetaryTotal value
     * @return \Gek\UyumBahce\StructType\MonetaryTotalType|null
     */
    public function getLegalMonetaryTotal()
    {
        return $this->LegalMonetaryTotal;
    }
    /**
     * Set LegalMonetaryTotal value
     * @param \Gek\UyumBahce\StructType\MonetaryTotalType $legalMonetaryTotal
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setLegalMonetaryTotal(\Gek\UyumBahce\StructType\MonetaryTotalType $legalMonetaryTotal = null)
    {
        $this->LegalMonetaryTotal = $legalMonetaryTotal;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Gek\UyumBahce\StructType\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeInvoiceLineItem instanceof \Gek\UyumBahce\StructType\InvoiceLineType) {
                $invalidValues[] = is_object($invoiceTypeInvoiceLineItem) ? get_class($invoiceTypeInvoiceLineItem) : sprintf('%s(%s)', gettype($invoiceTypeInvoiceLineItem), var_export($invoiceTypeInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahce\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\InvoiceLineType[] $invoiceLine
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new \InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\InvoiceLineType $item
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function addToInvoiceLine(\Gek\UyumBahce\StructType\InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\InvoiceLineType) {
            throw new \InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahce\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get schemaLocation value
     * @return string|null
     */
    public function getSchemaLocation()
    {
        return $this->schemaLocation;
    }
    /**
     * Set schemaLocation value
     * @param string $schemaLocation
     * @return \Gek\UyumBahce\StructType\InvoiceType
     */
    public function setSchemaLocation($schemaLocation = null)
    {
        // validation for constraint: string
        if (!is_null($schemaLocation) && !is_string($schemaLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaLocation, true), gettype($schemaLocation)), __LINE__);
        }
        $this->schemaLocation = $schemaLocation;
        return $this;
    }
}
