<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfo StructType
 * @subpackage Structs
 */
class InvoiceInfo extends AbstractStructBase
{
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Scenario;
    /**
     * The CreateDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateUtc;
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\InvoiceType
     */
    public $Invoice;
    /**
     * The TargetCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\CustomerInfo
     */
    public $TargetCustomer;
    /**
     * The EArchiveInvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\EArchiveInvoiceInformation
     */
    public $EArchiveInvoiceInfo;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\NotificationInformation
     */
    public $Notification;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;
    /**
     * Constructor method for InvoiceInfo
     * @uses InvoiceInfo::setScenario()
     * @uses InvoiceInfo::setCreateDateUtc()
     * @uses InvoiceInfo::setInvoice()
     * @uses InvoiceInfo::setTargetCustomer()
     * @uses InvoiceInfo::setEArchiveInvoiceInfo()
     * @uses InvoiceInfo::setNotification()
     * @uses InvoiceInfo::setExtraInformation()
     * @uses InvoiceInfo::setLocalDocumentId()
     * @param string $scenario
     * @param string $createDateUtc
     * @param \Gek\UyumBahce\StructType\InvoiceType $invoice
     * @param \Gek\UyumBahce\StructType\CustomerInfo $targetCustomer
     * @param \Gek\UyumBahce\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @param \Gek\UyumBahce\StructType\NotificationInformation $notification
     * @param string $extraInformation
     * @param string $localDocumentId
     */
    public function __construct($scenario = null, $createDateUtc = null, \Gek\UyumBahce\StructType\InvoiceType $invoice = null, \Gek\UyumBahce\StructType\CustomerInfo $targetCustomer = null, \Gek\UyumBahce\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null, \Gek\UyumBahce\StructType\NotificationInformation $notification = null, $extraInformation = null, $localDocumentId = null)
    {
        $this
            ->setScenario($scenario)
            ->setCreateDateUtc($createDateUtc)
            ->setInvoice($invoice)
            ->setTargetCustomer($targetCustomer)
            ->setEArchiveInvoiceInfo($eArchiveInvoiceInfo)
            ->setNotification($notification)
            ->setExtraInformation($extraInformation)
            ->setLocalDocumentId($localDocumentId);
    }
    /**
     * Get Scenario value
     * @return string
     */
    public function getScenario()
    {
        return $this->Scenario;
    }
    /**
     * Set Scenario value
     * @uses \Gek\UyumBahce\EnumType\InvoiceScenarioChoosen::valueIsValid()
     * @uses \Gek\UyumBahce\EnumType\InvoiceScenarioChoosen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scenario
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: enumeration
        if (!\Gek\UyumBahce\EnumType\InvoiceScenarioChoosen::valueIsValid($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\InvoiceScenarioChoosen', is_array($scenario) ? implode(', ', $scenario) : var_export($scenario, true), implode(', ', \Gek\UyumBahce\EnumType\InvoiceScenarioChoosen::getValidValues())), __LINE__);
        }
        $this->Scenario = $scenario;
        return $this;
    }
    /**
     * Get CreateDateUtc value
     * @return string
     */
    public function getCreateDateUtc()
    {
        return $this->CreateDateUtc;
    }
    /**
     * Set CreateDateUtc value
     * @param string|GekDateTime $createDateUtc
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setCreateDateUtc($createDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($createDateUtc) && !is_string($createDateUtc) && !($createDateUtc instanceof GekDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateUtc, true), gettype($createDateUtc)), __LINE__);
        }
        if($createDateUtc instanceof GekDateTime){
            $createDateUtc = $createDateUtc->toServiceString();
        }
        $this->CreateDateUtc = $createDateUtc;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Gek\UyumBahce\StructType\InvoiceType|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Gek\UyumBahce\StructType\InvoiceType $invoice
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setInvoice(\Gek\UyumBahce\StructType\InvoiceType $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get TargetCustomer value
     * @return \Gek\UyumBahce\StructType\CustomerInfo|null
     */
    public function getTargetCustomer()
    {
        return $this->TargetCustomer;
    }
    /**
     * Set TargetCustomer value
     * @param \Gek\UyumBahce\StructType\CustomerInfo $targetCustomer
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setTargetCustomer(\Gek\UyumBahce\StructType\CustomerInfo $targetCustomer = null)
    {
        $this->TargetCustomer = $targetCustomer;
        return $this;
    }
    /**
     * Get EArchiveInvoiceInfo value
     * @return \Gek\UyumBahce\StructType\EArchiveInvoiceInformation|null
     */
    public function getEArchiveInvoiceInfo()
    {
        return $this->EArchiveInvoiceInfo;
    }
    /**
     * Set EArchiveInvoiceInfo value
     * @param \Gek\UyumBahce\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setEArchiveInvoiceInfo(\Gek\UyumBahce\StructType\EArchiveInvoiceInformation $eArchiveInvoiceInfo = null)
    {
        $this->EArchiveInvoiceInfo = $eArchiveInvoiceInfo;
        return $this;
    }
    /**
     * Get Notification value
     * @return \Gek\UyumBahce\StructType\NotificationInformation|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \Gek\UyumBahce\StructType\NotificationInformation $notification
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setNotification(\Gek\UyumBahce\StructType\NotificationInformation $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }
    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setExtraInformation($extraInformation = null)
    {
        // validation for constraint: string
        if (!is_null($extraInformation) && !is_string($extraInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInformation, true), gettype($extraInformation)), __LINE__);
        }
        $this->ExtraInformation = $extraInformation;
        return $this;
    }
    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }
    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return \Gek\UyumBahce\StructType\InvoiceInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
}
