<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternetSalesInformation StructType
 * @subpackage Structs
 */
class InternetSalesInformation extends AbstractStructBase
{
    /**
     * The PaymentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentDate;
    /**
     * The WebAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddress;
    /**
     * The PaymentMidierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMidierName;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The ShipmentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ShipmentInformation
     */
    public $ShipmentInfo;
    /**
     * Constructor method for InternetSalesInformation
     * @uses InternetSalesInformation::setPaymentDate()
     * @uses InternetSalesInformation::setWebAddress()
     * @uses InternetSalesInformation::setPaymentMidierName()
     * @uses InternetSalesInformation::setPaymentType()
     * @uses InternetSalesInformation::setShipmentInfo()
     * @param string|GekDateTime $paymentDate
     * @param string $webAddress
     * @param string $paymentMidierName
     * @param string $paymentType
     * @param \Gek\UyumBahce\StructType\ShipmentInformation $shipmentInfo
     */
    public function __construct($paymentDate = null, $webAddress = null, $paymentMidierName = null, $paymentType = null, \Gek\UyumBahce\StructType\ShipmentInformation $shipmentInfo = null)
    {
        $this
            ->setPaymentDate($paymentDate)
            ->setWebAddress($webAddress)
            ->setPaymentMidierName($paymentMidierName)
            ->setPaymentType($paymentType)
            ->setShipmentInfo($shipmentInfo);
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string|GekDateTime $paymentDate
     * @return \Gek\UyumBahce\StructType\InternetSalesInformation
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate) && !($paymentDate instanceof GekDateTime) ) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        if($paymentDate instanceof GekDateTime){
            $paymentDate = $paymentDate->toServiceString();
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get WebAddress value
     * @return string|null
     */
    public function getWebAddress()
    {
        return $this->WebAddress;
    }
    /**
     * Set WebAddress value
     * @param string $webAddress
     * @return \Gek\UyumBahce\StructType\InternetSalesInformation
     */
    public function setWebAddress($webAddress = null)
    {
        // validation for constraint: string
        if (!is_null($webAddress) && !is_string($webAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddress, true), gettype($webAddress)), __LINE__);
        }
        $this->WebAddress = $webAddress;
        return $this;
    }
    /**
     * Get PaymentMidierName value
     * @return string|null
     */
    public function getPaymentMidierName()
    {
        return $this->PaymentMidierName;
    }
    /**
     * Set PaymentMidierName value
     * @param string $paymentMidierName
     * @return \Gek\UyumBahce\StructType\InternetSalesInformation
     */
    public function setPaymentMidierName($paymentMidierName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMidierName) && !is_string($paymentMidierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMidierName, true), gettype($paymentMidierName)), __LINE__);
        }
        $this->PaymentMidierName = $paymentMidierName;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \Gek\UyumBahce\StructType\InternetSalesInformation
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get ShipmentInfo value
     * @return \Gek\UyumBahce\StructType\ShipmentInformation|null
     */
    public function getShipmentInfo()
    {
        return $this->ShipmentInfo;
    }
    /**
     * Set ShipmentInfo value
     * @param \Gek\UyumBahce\StructType\ShipmentInformation $shipmentInfo
     * @return \Gek\UyumBahce\StructType\InternetSalesInformation
     */
    public function setShipmentInfo(\Gek\UyumBahce\StructType\ShipmentInformation $shipmentInfo = null)
    {
        $this->ShipmentInfo = $shipmentInfo;
        return $this;
    }
}
