<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGoodsTransitType StructType
 * @subpackage Structs
 */
class HazardousGoodsTransitType extends AbstractStructBase
{
    /**
     * The TransportEmergencyCardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportEmergencyCardCode
     * @var \Gek\UyumBahce\StructType\TransportEmergencyCardCodeType
     */
    public $TransportEmergencyCardCode;
    /**
     * The PackingCriteriaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PackingCriteriaCode
     * @var \Gek\UyumBahce\StructType\PackingCriteriaCodeType
     */
    public $PackingCriteriaCode;
    /**
     * The HazardousRegulationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HazardousRegulationCode
     * @var \Gek\UyumBahce\StructType\HazardousRegulationCodeType
     */
    public $HazardousRegulationCode;
    /**
     * The InhalationToxicityZoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InhalationToxicityZoneCode
     * @var \Gek\UyumBahce\StructType\InhalationToxicityZoneCodeType
     */
    public $InhalationToxicityZoneCode;
    /**
     * The TransportAuthorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportAuthorizationCode
     * @var \Gek\UyumBahce\StructType\TransportAuthorizationCodeType
     */
    public $TransportAuthorizationCode;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TemperatureType
     */
    public $MinimumTemperature;
    /**
     * Constructor method for HazardousGoodsTransitType
     * @uses HazardousGoodsTransitType::setTransportEmergencyCardCode()
     * @uses HazardousGoodsTransitType::setPackingCriteriaCode()
     * @uses HazardousGoodsTransitType::setHazardousRegulationCode()
     * @uses HazardousGoodsTransitType::setInhalationToxicityZoneCode()
     * @uses HazardousGoodsTransitType::setTransportAuthorizationCode()
     * @uses HazardousGoodsTransitType::setMaximumTemperature()
     * @uses HazardousGoodsTransitType::setMinimumTemperature()
     * @param \Gek\UyumBahce\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @param \Gek\UyumBahce\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @param \Gek\UyumBahce\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @param \Gek\UyumBahce\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @param \Gek\UyumBahce\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @param \Gek\UyumBahce\StructType\TemperatureType $maximumTemperature
     * @param \Gek\UyumBahce\StructType\TemperatureType $minimumTemperature
     */
    public function __construct(\Gek\UyumBahce\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null, \Gek\UyumBahce\StructType\PackingCriteriaCodeType $packingCriteriaCode = null, \Gek\UyumBahce\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null, \Gek\UyumBahce\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null, \Gek\UyumBahce\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null, \Gek\UyumBahce\StructType\TemperatureType $maximumTemperature = null, \Gek\UyumBahce\StructType\TemperatureType $minimumTemperature = null)
    {
        $this
            ->setTransportEmergencyCardCode($transportEmergencyCardCode)
            ->setPackingCriteriaCode($packingCriteriaCode)
            ->setHazardousRegulationCode($hazardousRegulationCode)
            ->setInhalationToxicityZoneCode($inhalationToxicityZoneCode)
            ->setTransportAuthorizationCode($transportAuthorizationCode)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature);
    }
    /**
     * Get TransportEmergencyCardCode value
     * @return \Gek\UyumBahce\StructType\TransportEmergencyCardCodeType|null
     */
    public function getTransportEmergencyCardCode()
    {
        return $this->TransportEmergencyCardCode;
    }
    /**
     * Set TransportEmergencyCardCode value
     * @param \Gek\UyumBahce\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType
     */
    public function setTransportEmergencyCardCode(\Gek\UyumBahce\StructType\TransportEmergencyCardCodeType $transportEmergencyCardCode = null)
    {
        $this->TransportEmergencyCardCode = $transportEmergencyCardCode;
        return $this;
    }
    /**
     * Get PackingCriteriaCode value
     * @return \Gek\UyumBahce\StructType\PackingCriteriaCodeType|null
     */
    public function getPackingCriteriaCode()
    {
        return $this->PackingCriteriaCode;
    }
    /**
     * Set PackingCriteriaCode value
     * @param \Gek\UyumBahce\StructType\PackingCriteriaCodeType $packingCriteriaCode
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType
     */
    public function setPackingCriteriaCode(\Gek\UyumBahce\StructType\PackingCriteriaCodeType $packingCriteriaCode = null)
    {
        $this->PackingCriteriaCode = $packingCriteriaCode;
        return $this;
    }
    /**
     * Get HazardousRegulationCode value
     * @return \Gek\UyumBahce\StructType\HazardousRegulationCodeType|null
     */
    public function getHazardousRegulationCode()
    {
        return $this->HazardousRegulationCode;
    }
    /**
     * Set HazardousRegulationCode value
     * @param \Gek\UyumBahce\StructType\HazardousRegulationCodeType $hazardousRegulationCode
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType
     */
    public function setHazardousRegulationCode(\Gek\UyumBahce\StructType\HazardousRegulationCodeType $hazardousRegulationCode = null)
    {
        $this->HazardousRegulationCode = $hazardousRegulationCode;
        return $this;
    }
    /**
     * Get InhalationToxicityZoneCode value
     * @return \Gek\UyumBahce\StructType\InhalationToxicityZoneCodeType|null
     */
    public function getInhalationToxicityZoneCode()
    {
        return $this->InhalationToxicityZoneCode;
    }
    /**
     * Set InhalationToxicityZoneCode value
     * @param \Gek\UyumBahce\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType
     */
    public function setInhalationToxicityZoneCode(\Gek\UyumBahce\StructType\InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null)
    {
        $this->InhalationToxicityZoneCode = $inhalationToxicityZoneCode;
        return $this;
    }
    /**
     * Get TransportAuthorizationCode value
     * @return \Gek\UyumBahce\StructType\TransportAuthorizationCodeType|null
     */
    public function getTransportAuthorizationCode()
    {
        return $this->TransportAuthorizationCode;
    }
    /**
     * Set TransportAuthorizationCode value
     * @param \Gek\UyumBahce\StructType\TransportAuthorizationCodeType $transportAuthorizationCode
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType
     */
    public function setTransportAuthorizationCode(\Gek\UyumBahce\StructType\TransportAuthorizationCodeType $transportAuthorizationCode = null)
    {
        $this->TransportAuthorizationCode = $transportAuthorizationCode;
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * @return \Gek\UyumBahce\StructType\TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }
    /**
     * Set MaximumTemperature value
     * @param \Gek\UyumBahce\StructType\TemperatureType $maximumTemperature
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType
     */
    public function setMaximumTemperature(\Gek\UyumBahce\StructType\TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * @return \Gek\UyumBahce\StructType\TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }
    /**
     * Set MinimumTemperature value
     * @param \Gek\UyumBahce\StructType\TemperatureType $minimumTemperature
     * @return \Gek\UyumBahce\StructType\HazardousGoodsTransitType
     */
    public function setMinimumTemperature(\Gek\UyumBahce\StructType\TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
}
