<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItemType StructType
 * @subpackage Structs
 */
class GoodsItemType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Description
     * @var \Gek\UyumBahce\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HazardousRiskIndicator
     * @var \Gek\UyumBahce\StructType\HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredCustomsValueAmount
     * @var \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredForCarriageValueAmount
     * @var \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredStatisticsValueAmount
     * @var \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:FreeOnBoardValueAmount
     * @var \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InsuranceValueAmount
     * @var \Gek\UyumBahce\StructType\InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The ValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ValueAmount
     * @var \Gek\UyumBahce\StructType\ValueAmountType
     */
    public $ValueAmount;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossWeightMeasure
     * @var \Gek\UyumBahce\StructType\GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetWeightMeasure
     * @var \Gek\UyumBahce\StructType\NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The ChargeableWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ChargeableWeightMeasure
     * @var \Gek\UyumBahce\StructType\ChargeableWeightMeasureType
     */
    public $ChargeableWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossVolumeMeasure
     * @var \Gek\UyumBahce\StructType\GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetVolumeMeasure
     * @var \Gek\UyumBahce\StructType\NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Quantity
     * @var \Gek\UyumBahce\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The RequiredCustomsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RequiredCustomsID
     * @var \Gek\UyumBahce\StructType\RequiredCustomsIDType
     */
    public $RequiredCustomsID;
    /**
     * The CustomsStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomsStatusCode
     * @var \Gek\UyumBahce\StructType\CustomsStatusCodeType
     */
    public $CustomsStatusCode;
    /**
     * The CustomsTariffQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomsTariffQuantity
     * @var \Gek\UyumBahce\StructType\CustomsTariffQuantityType
     */
    public $CustomsTariffQuantity;
    /**
     * The CustomsImportClassifiedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomsImportClassifiedIndicator
     * @var \Gek\UyumBahce\StructType\CustomsImportClassifiedIndicatorType
     */
    public $CustomsImportClassifiedIndicator;
    /**
     * The ChargeableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ChargeableQuantity
     * @var \Gek\UyumBahce\StructType\ChargeableQuantityType
     */
    public $ChargeableQuantity;
    /**
     * The ReturnableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ReturnableQuantity
     * @var \Gek\UyumBahce\StructType\ReturnableQuantityType
     */
    public $ReturnableQuantity;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TraceID
     * @var \Gek\UyumBahce\StructType\TraceIDType
     */
    public $TraceID;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ItemType[]
     */
    public $Item;
    /**
     * The FreightAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\AllowanceChargeType[]
     */
    public $FreightAllowanceCharge;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TemperatureType[]
     */
    public $Temperature;
    /**
     * The OriginAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\AddressType
     */
    public $OriginAddress;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * Constructor method for GoodsItemType
     * @uses GoodsItemType::setID()
     * @uses GoodsItemType::setDescription()
     * @uses GoodsItemType::setHazardousRiskIndicator()
     * @uses GoodsItemType::setDeclaredCustomsValueAmount()
     * @uses GoodsItemType::setDeclaredForCarriageValueAmount()
     * @uses GoodsItemType::setDeclaredStatisticsValueAmount()
     * @uses GoodsItemType::setFreeOnBoardValueAmount()
     * @uses GoodsItemType::setInsuranceValueAmount()
     * @uses GoodsItemType::setValueAmount()
     * @uses GoodsItemType::setGrossWeightMeasure()
     * @uses GoodsItemType::setNetWeightMeasure()
     * @uses GoodsItemType::setChargeableWeightMeasure()
     * @uses GoodsItemType::setGrossVolumeMeasure()
     * @uses GoodsItemType::setNetVolumeMeasure()
     * @uses GoodsItemType::setQuantity()
     * @uses GoodsItemType::setRequiredCustomsID()
     * @uses GoodsItemType::setCustomsStatusCode()
     * @uses GoodsItemType::setCustomsTariffQuantity()
     * @uses GoodsItemType::setCustomsImportClassifiedIndicator()
     * @uses GoodsItemType::setChargeableQuantity()
     * @uses GoodsItemType::setReturnableQuantity()
     * @uses GoodsItemType::setTraceID()
     * @uses GoodsItemType::setItem()
     * @uses GoodsItemType::setFreightAllowanceCharge()
     * @uses GoodsItemType::setInvoiceLine()
     * @uses GoodsItemType::setTemperature()
     * @uses GoodsItemType::setOriginAddress()
     * @uses GoodsItemType::setMeasurementDimension()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\DescriptionType[] $description
     * @param \Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param \Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @param \Gek\UyumBahce\StructType\ValueAmountType $valueAmount
     * @param \Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @param \Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure
     * @param \Gek\UyumBahce\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @param \Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @param \Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @param \Gek\UyumBahce\StructType\QuantityType $quantity
     * @param \Gek\UyumBahce\StructType\RequiredCustomsIDType $requiredCustomsID
     * @param \Gek\UyumBahce\StructType\CustomsStatusCodeType $customsStatusCode
     * @param \Gek\UyumBahce\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @param \Gek\UyumBahce\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @param \Gek\UyumBahce\StructType\ChargeableQuantityType $chargeableQuantity
     * @param \Gek\UyumBahce\StructType\ReturnableQuantityType $returnableQuantity
     * @param \Gek\UyumBahce\StructType\TraceIDType $traceID
     * @param \Gek\UyumBahce\StructType\ItemType[] $item
     * @param \Gek\UyumBahce\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @param \Gek\UyumBahce\StructType\InvoiceLineType[] $invoiceLine
     * @param \Gek\UyumBahce\StructType\TemperatureType[] $temperature
     * @param \Gek\UyumBahce\StructType\AddressType $originAddress
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, array $description = array(), \Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null, \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, \Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount = null, \Gek\UyumBahce\StructType\ValueAmountType $valueAmount = null, \Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure = null, \Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure = null, \Gek\UyumBahce\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null, \Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null, \Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure = null, \Gek\UyumBahce\StructType\QuantityType $quantity = null, \Gek\UyumBahce\StructType\RequiredCustomsIDType $requiredCustomsID = null, \Gek\UyumBahce\StructType\CustomsStatusCodeType $customsStatusCode = null, \Gek\UyumBahce\StructType\CustomsTariffQuantityType $customsTariffQuantity = null, \Gek\UyumBahce\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null, \Gek\UyumBahce\StructType\ChargeableQuantityType $chargeableQuantity = null, \Gek\UyumBahce\StructType\ReturnableQuantityType $returnableQuantity = null, \Gek\UyumBahce\StructType\TraceIDType $traceID = null, array $item = array(), array $freightAllowanceCharge = array(), array $invoiceLine = array(), array $temperature = array(), \Gek\UyumBahce\StructType\AddressType $originAddress = null, array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setDescription($description)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setValueAmount($valueAmount)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setChargeableWeightMeasure($chargeableWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setQuantity($quantity)
            ->setRequiredCustomsID($requiredCustomsID)
            ->setCustomsStatusCode($customsStatusCode)
            ->setCustomsTariffQuantity($customsTariffQuantity)
            ->setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator)
            ->setChargeableQuantity($chargeableQuantity)
            ->setReturnableQuantity($returnableQuantity)
            ->setTraceID($traceID)
            ->setItem($item)
            ->setFreightAllowanceCharge($freightAllowanceCharge)
            ->setInvoiceLine($invoiceLine)
            ->setTemperature($temperature)
            ->setOriginAddress($originAddress)
            ->setMeasurementDimension($measurementDimension);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Description value
     * @return \Gek\UyumBahce\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeDescriptionItem instanceof \Gek\UyumBahce\StructType\DescriptionType) {
                $invalidValues[] = is_object($goodsItemTypeDescriptionItem) ? get_class($goodsItemTypeDescriptionItem) : sprintf('%s(%s)', gettype($goodsItemTypeDescriptionItem), var_export($goodsItemTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DescriptionType[] $description
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DescriptionType $item
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function addToDescription(\Gek\UyumBahce\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return \Gek\UyumBahce\StructType\HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param \Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setHazardousRiskIndicator(\Gek\UyumBahce\StructType\HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * @return \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * @param \Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setDeclaredCustomsValueAmount(\Gek\UyumBahce\StructType\DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * @return \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * @param \Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setDeclaredForCarriageValueAmount(\Gek\UyumBahce\StructType\DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * @return \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * @param \Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setDeclaredStatisticsValueAmount(\Gek\UyumBahce\StructType\DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * @return \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * @param \Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setFreeOnBoardValueAmount(\Gek\UyumBahce\StructType\FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * @return \Gek\UyumBahce\StructType\InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }
    /**
     * Set InsuranceValueAmount value
     * @param \Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setInsuranceValueAmount(\Gek\UyumBahce\StructType\InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }
    /**
     * Get ValueAmount value
     * @return \Gek\UyumBahce\StructType\ValueAmountType|null
     */
    public function getValueAmount()
    {
        return $this->ValueAmount;
    }
    /**
     * Set ValueAmount value
     * @param \Gek\UyumBahce\StructType\ValueAmountType $valueAmount
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setValueAmount(\Gek\UyumBahce\StructType\ValueAmountType $valueAmount = null)
    {
        $this->ValueAmount = $valueAmount;
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * @return \Gek\UyumBahce\StructType\GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }
    /**
     * Set GrossWeightMeasure value
     * @param \Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setGrossWeightMeasure(\Gek\UyumBahce\StructType\GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * @return \Gek\UyumBahce\StructType\NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }
    /**
     * Set NetWeightMeasure value
     * @param \Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setNetWeightMeasure(\Gek\UyumBahce\StructType\NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }
    /**
     * Get ChargeableWeightMeasure value
     * @return \Gek\UyumBahce\StructType\ChargeableWeightMeasureType|null
     */
    public function getChargeableWeightMeasure()
    {
        return $this->ChargeableWeightMeasure;
    }
    /**
     * Set ChargeableWeightMeasure value
     * @param \Gek\UyumBahce\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setChargeableWeightMeasure(\Gek\UyumBahce\StructType\ChargeableWeightMeasureType $chargeableWeightMeasure = null)
    {
        $this->ChargeableWeightMeasure = $chargeableWeightMeasure;
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * @return \Gek\UyumBahce\StructType\GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }
    /**
     * Set GrossVolumeMeasure value
     * @param \Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setGrossVolumeMeasure(\Gek\UyumBahce\StructType\GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * @return \Gek\UyumBahce\StructType\NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }
    /**
     * Set NetVolumeMeasure value
     * @param \Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setNetVolumeMeasure(\Gek\UyumBahce\StructType\NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Gek\UyumBahce\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Gek\UyumBahce\StructType\QuantityType $quantity
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setQuantity(\Gek\UyumBahce\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequiredCustomsID value
     * @return \Gek\UyumBahce\StructType\RequiredCustomsIDType|null
     */
    public function getRequiredCustomsID()
    {
        return $this->RequiredCustomsID;
    }
    /**
     * Set RequiredCustomsID value
     * @param \Gek\UyumBahce\StructType\RequiredCustomsIDType $requiredCustomsID
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setRequiredCustomsID(\Gek\UyumBahce\StructType\RequiredCustomsIDType $requiredCustomsID = null)
    {
        $this->RequiredCustomsID = $requiredCustomsID;
        return $this;
    }
    /**
     * Get CustomsStatusCode value
     * @return \Gek\UyumBahce\StructType\CustomsStatusCodeType|null
     */
    public function getCustomsStatusCode()
    {
        return $this->CustomsStatusCode;
    }
    /**
     * Set CustomsStatusCode value
     * @param \Gek\UyumBahce\StructType\CustomsStatusCodeType $customsStatusCode
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setCustomsStatusCode(\Gek\UyumBahce\StructType\CustomsStatusCodeType $customsStatusCode = null)
    {
        $this->CustomsStatusCode = $customsStatusCode;
        return $this;
    }
    /**
     * Get CustomsTariffQuantity value
     * @return \Gek\UyumBahce\StructType\CustomsTariffQuantityType|null
     */
    public function getCustomsTariffQuantity()
    {
        return $this->CustomsTariffQuantity;
    }
    /**
     * Set CustomsTariffQuantity value
     * @param \Gek\UyumBahce\StructType\CustomsTariffQuantityType $customsTariffQuantity
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setCustomsTariffQuantity(\Gek\UyumBahce\StructType\CustomsTariffQuantityType $customsTariffQuantity = null)
    {
        $this->CustomsTariffQuantity = $customsTariffQuantity;
        return $this;
    }
    /**
     * Get CustomsImportClassifiedIndicator value
     * @return \Gek\UyumBahce\StructType\CustomsImportClassifiedIndicatorType|null
     */
    public function getCustomsImportClassifiedIndicator()
    {
        return $this->CustomsImportClassifiedIndicator;
    }
    /**
     * Set CustomsImportClassifiedIndicator value
     * @param \Gek\UyumBahce\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setCustomsImportClassifiedIndicator(\Gek\UyumBahce\StructType\CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null)
    {
        $this->CustomsImportClassifiedIndicator = $customsImportClassifiedIndicator;
        return $this;
    }
    /**
     * Get ChargeableQuantity value
     * @return \Gek\UyumBahce\StructType\ChargeableQuantityType|null
     */
    public function getChargeableQuantity()
    {
        return $this->ChargeableQuantity;
    }
    /**
     * Set ChargeableQuantity value
     * @param \Gek\UyumBahce\StructType\ChargeableQuantityType $chargeableQuantity
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setChargeableQuantity(\Gek\UyumBahce\StructType\ChargeableQuantityType $chargeableQuantity = null)
    {
        $this->ChargeableQuantity = $chargeableQuantity;
        return $this;
    }
    /**
     * Get ReturnableQuantity value
     * @return \Gek\UyumBahce\StructType\ReturnableQuantityType|null
     */
    public function getReturnableQuantity()
    {
        return $this->ReturnableQuantity;
    }
    /**
     * Set ReturnableQuantity value
     * @param \Gek\UyumBahce\StructType\ReturnableQuantityType $returnableQuantity
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setReturnableQuantity(\Gek\UyumBahce\StructType\ReturnableQuantityType $returnableQuantity = null)
    {
        $this->ReturnableQuantity = $returnableQuantity;
        return $this;
    }
    /**
     * Get TraceID value
     * @return \Gek\UyumBahce\StructType\TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }
    /**
     * Set TraceID value
     * @param \Gek\UyumBahce\StructType\TraceIDType $traceID
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setTraceID(\Gek\UyumBahce\StructType\TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }
    /**
     * Get Item value
     * @return \Gek\UyumBahce\StructType\ItemType[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeItemItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeItemItem instanceof \Gek\UyumBahce\StructType\ItemType) {
                $invalidValues[] = is_object($goodsItemTypeItemItem) ? get_class($goodsItemTypeItemItem) : sprintf('%s(%s)', gettype($goodsItemTypeItemItem), var_export($goodsItemTypeItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \Gek\UyumBahce\StructType\ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemType[] $item
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\ItemType $item
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function addToItem(\Gek\UyumBahce\StructType\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\ItemType) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \Gek\UyumBahce\StructType\ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get FreightAllowanceCharge value
     * @return \Gek\UyumBahce\StructType\AllowanceChargeType[]|null
     */
    public function getFreightAllowanceCharge()
    {
        return $this->FreightAllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setFreightAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFreightAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeFreightAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeFreightAllowanceChargeItem instanceof \Gek\UyumBahce\StructType\AllowanceChargeType) {
                $invalidValues[] = is_object($goodsItemTypeFreightAllowanceChargeItem) ? get_class($goodsItemTypeFreightAllowanceChargeItem) : sprintf('%s(%s)', gettype($goodsItemTypeFreightAllowanceChargeItem), var_export($goodsItemTypeFreightAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FreightAllowanceCharge property can only contain items of type \Gek\UyumBahce\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\AllowanceChargeType[] $freightAllowanceCharge
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setFreightAllowanceCharge(array $freightAllowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($freightAllowanceChargeArrayErrorMessage = self::validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge($freightAllowanceCharge))) {
            throw new \InvalidArgumentException($freightAllowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->FreightAllowanceCharge = $freightAllowanceCharge;
        return $this;
    }
    /**
     * Add item to FreightAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\AllowanceChargeType $item
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function addToFreightAllowanceCharge(\Gek\UyumBahce\StructType\AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\AllowanceChargeType) {
            throw new \InvalidArgumentException(sprintf('The FreightAllowanceCharge property can only contain items of type \Gek\UyumBahce\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FreightAllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get InvoiceLine value
     * @return \Gek\UyumBahce\StructType\InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeInvoiceLineItem instanceof \Gek\UyumBahce\StructType\InvoiceLineType) {
                $invalidValues[] = is_object($goodsItemTypeInvoiceLineItem) ? get_class($goodsItemTypeInvoiceLineItem) : sprintf('%s(%s)', gettype($goodsItemTypeInvoiceLineItem), var_export($goodsItemTypeInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahce\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\InvoiceLineType[] $invoiceLine
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new \InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }
    /**
     * Add item to InvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\InvoiceLineType $item
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function addToInvoiceLine(\Gek\UyumBahce\StructType\InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\InvoiceLineType) {
            throw new \InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahce\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get Temperature value
     * @return \Gek\UyumBahce\StructType\TemperatureType[]|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }
    /**
     * This method is responsible for validating the values passed to the setTemperature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureForArrayConstraintsFromSetTemperature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeTemperatureItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeTemperatureItem instanceof \Gek\UyumBahce\StructType\TemperatureType) {
                $invalidValues[] = is_object($goodsItemTypeTemperatureItem) ? get_class($goodsItemTypeTemperatureItem) : sprintf('%s(%s)', gettype($goodsItemTypeTemperatureItem), var_export($goodsItemTypeTemperatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Temperature property can only contain items of type \Gek\UyumBahce\StructType\TemperatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Temperature value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TemperatureType[] $temperature
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setTemperature(array $temperature = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureArrayErrorMessage = self::validateTemperatureForArrayConstraintsFromSetTemperature($temperature))) {
            throw new \InvalidArgumentException($temperatureArrayErrorMessage, __LINE__);
        }
        $this->Temperature = $temperature;
        return $this;
    }
    /**
     * Add item to Temperature value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TemperatureType $item
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function addToTemperature(\Gek\UyumBahce\StructType\TemperatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\TemperatureType) {
            throw new \InvalidArgumentException(sprintf('The Temperature property can only contain items of type \Gek\UyumBahce\StructType\TemperatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Temperature[] = $item;
        return $this;
    }
    /**
     * Get OriginAddress value
     * @return \Gek\UyumBahce\StructType\AddressType|null
     */
    public function getOriginAddress()
    {
        return $this->OriginAddress;
    }
    /**
     * Set OriginAddress value
     * @param \Gek\UyumBahce\StructType\AddressType $originAddress
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setOriginAddress(\Gek\UyumBahce\StructType\AddressType $originAddress = null)
    {
        $this->OriginAddress = $originAddress;
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * @return \Gek\UyumBahce\StructType\DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }
    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeMeasurementDimensionItem instanceof \Gek\UyumBahce\StructType\DimensionType) {
                $invalidValues[] = is_object($goodsItemTypeMeasurementDimensionItem) ? get_class($goodsItemTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($goodsItemTypeMeasurementDimensionItem), var_export($goodsItemTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType[] $measurementDimension
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new \InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }
    /**
     * Add item to MeasurementDimension value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DimensionType $item
     * @return \Gek\UyumBahce\StructType\GoodsItemType
     */
    public function addToMeasurementDimension(\Gek\UyumBahce\StructType\DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DimensionType) {
            throw new \InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahce\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
