<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityContact StructType
 * @subpackage Structs
 */
class EntityContact extends AbstractStructBase
{
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ContactId;
    /**
     * The IsAuthorized
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsAuthorized;
    /**
     * The ContactFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactFirstName;
    /**
     * The ContactLastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactLastName;
    /**
     * The ContactTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactTel;
    /**
     * The ContactFax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactFax;
    /**
     * The ContactMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactMail;
    /**
     * The ContactCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactCode;
    /**
     * The Salutation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Salutation;
    /**
     * Constructor method for EntityContact
     * @uses EntityContact::setContactId()
     * @uses EntityContact::setIsAuthorized()
     * @uses EntityContact::setContactFirstName()
     * @uses EntityContact::setContactLastName()
     * @uses EntityContact::setContactTel()
     * @uses EntityContact::setContactFax()
     * @uses EntityContact::setContactMail()
     * @uses EntityContact::setContactCode()
     * @uses EntityContact::setSalutation()
     * @param int $contactId
     * @param bool $isAuthorized
     * @param string $contactFirstName
     * @param string $contactLastName
     * @param string $contactTel
     * @param string $contactFax
     * @param string $contactMail
     * @param string $contactCode
     * @param string $salutation
     */
    public function __construct($contactId = null, $isAuthorized = null, $contactFirstName = null, $contactLastName = null, $contactTel = null, $contactFax = null, $contactMail = null, $contactCode = null, $salutation = null)
    {
        $this
            ->setContactId($contactId)
            ->setIsAuthorized($isAuthorized)
            ->setContactFirstName($contactFirstName)
            ->setContactLastName($contactLastName)
            ->setContactTel($contactTel)
            ->setContactFax($contactFax)
            ->setContactMail($contactMail)
            ->setContactCode($contactCode)
            ->setSalutation($salutation);
    }
    /**
     * Get ContactId value
     * @return int
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param int $contactId
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: int
        if (!is_null($contactId) && !(is_int($contactId) || ctype_digit($contactId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get IsAuthorized value
     * @return bool
     */
    public function getIsAuthorized()
    {
        return $this->IsAuthorized;
    }
    /**
     * Set IsAuthorized value
     * @param bool $isAuthorized
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setIsAuthorized($isAuthorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthorized) && !is_bool($isAuthorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAuthorized, true), gettype($isAuthorized)), __LINE__);
        }
        $this->IsAuthorized = $isAuthorized;
        return $this;
    }
    /**
     * Get ContactFirstName value
     * @return string|null
     */
    public function getContactFirstName()
    {
        return $this->ContactFirstName;
    }
    /**
     * Set ContactFirstName value
     * @param string $contactFirstName
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setContactFirstName($contactFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($contactFirstName) && !is_string($contactFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactFirstName, true), gettype($contactFirstName)), __LINE__);
        }
        $this->ContactFirstName = $contactFirstName;
        return $this;
    }
    /**
     * Get ContactLastName value
     * @return string|null
     */
    public function getContactLastName()
    {
        return $this->ContactLastName;
    }
    /**
     * Set ContactLastName value
     * @param string $contactLastName
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setContactLastName($contactLastName = null)
    {
        // validation for constraint: string
        if (!is_null($contactLastName) && !is_string($contactLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactLastName, true), gettype($contactLastName)), __LINE__);
        }
        $this->ContactLastName = $contactLastName;
        return $this;
    }
    /**
     * Get ContactTel value
     * @return string|null
     */
    public function getContactTel()
    {
        return $this->ContactTel;
    }
    /**
     * Set ContactTel value
     * @param string $contactTel
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setContactTel($contactTel = null)
    {
        // validation for constraint: string
        if (!is_null($contactTel) && !is_string($contactTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTel, true), gettype($contactTel)), __LINE__);
        }
        $this->ContactTel = $contactTel;
        return $this;
    }
    /**
     * Get ContactFax value
     * @return string|null
     */
    public function getContactFax()
    {
        return $this->ContactFax;
    }
    /**
     * Set ContactFax value
     * @param string $contactFax
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setContactFax($contactFax = null)
    {
        // validation for constraint: string
        if (!is_null($contactFax) && !is_string($contactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactFax, true), gettype($contactFax)), __LINE__);
        }
        $this->ContactFax = $contactFax;
        return $this;
    }
    /**
     * Get ContactMail value
     * @return string|null
     */
    public function getContactMail()
    {
        return $this->ContactMail;
    }
    /**
     * Set ContactMail value
     * @param string $contactMail
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setContactMail($contactMail = null)
    {
        // validation for constraint: string
        if (!is_null($contactMail) && !is_string($contactMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactMail, true), gettype($contactMail)), __LINE__);
        }
        $this->ContactMail = $contactMail;
        return $this;
    }
    /**
     * Get ContactCode value
     * @return string|null
     */
    public function getContactCode()
    {
        return $this->ContactCode;
    }
    /**
     * Set ContactCode value
     * @param string $contactCode
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setContactCode($contactCode = null)
    {
        // validation for constraint: string
        if (!is_null($contactCode) && !is_string($contactCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactCode, true), gettype($contactCode)), __LINE__);
        }
        $this->ContactCode = $contactCode;
        return $this;
    }
    /**
     * Get Salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->Salutation;
    }
    /**
     * Set Salutation value
     * @param string $salutation
     * @return \Gek\UyumBahce\StructType\EntityContact
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->Salutation = $salutation;
        return $this;
    }
}
