<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveWithHoldingInformation StructType
 * @subpackage Structs
 */
class EArchiveWithHoldingInformation extends AbstractStructBase
{
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rate;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Total;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * Constructor method for EArchiveWithHoldingInformation
     * @uses EArchiveWithHoldingInformation::setRate()
     * @uses EArchiveWithHoldingInformation::setTotal()
     * @uses EArchiveWithHoldingInformation::setCode()
     * @param float $rate
     * @param float $total
     * @param string $code
     */
    public function __construct($rate = null, $total = null, $code = null)
    {
        $this
            ->setRate($rate)
            ->setTotal($total)
            ->setCode($code);
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Total value
     * @return float
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
