<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveInvoiceInformation StructType
 * @subpackage Structs
 */
class EArchiveInvoiceInformation extends AbstractStructBase
{
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DeliveryType;
    /**
     * The NewGenerationPamentRecorderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\NewGenerationPaymentRecorderInformation
     */
    public $NewGenerationPamentRecorderInfo;
    /**
     * The InternetSalesInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\InternetSalesInformation
     */
    public $InternetSalesInfo;
    /**
     * The WithHoldings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation[]
     */
    public $WithHoldings;
    /**
     * Constructor method for EArchiveInvoiceInformation
     * @uses EArchiveInvoiceInformation::setDeliveryType()
     * @uses EArchiveInvoiceInformation::setNewGenerationPamentRecorderInfo()
     * @uses EArchiveInvoiceInformation::setInternetSalesInfo()
     * @uses EArchiveInvoiceInformation::setWithHoldings()
     * @param string $deliveryType
     * @param \Gek\UyumBahce\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @param \Gek\UyumBahce\StructType\InternetSalesInformation $internetSalesInfo
     * @param \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation[] $withHoldings
     */
    public function __construct($deliveryType = null, \Gek\UyumBahce\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null, \Gek\UyumBahce\StructType\InternetSalesInformation $internetSalesInfo = null, array $withHoldings = array())
    {
        $this
            ->setDeliveryType($deliveryType)
            ->setNewGenerationPamentRecorderInfo($newGenerationPamentRecorderInfo)
            ->setInternetSalesInfo($internetSalesInfo)
            ->setWithHoldings($withHoldings);
    }
    /**
     * Get DeliveryType value
     * @return string
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @uses \Gek\UyumBahce\EnumType\InvoiceDeliveryType::valueIsValid()
     * @uses \Gek\UyumBahce\EnumType\InvoiceDeliveryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryType
     * @return \Gek\UyumBahce\StructType\EArchiveInvoiceInformation
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\Gek\UyumBahce\EnumType\InvoiceDeliveryType::valueIsValid($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\InvoiceDeliveryType', is_array($deliveryType) ? implode(', ', $deliveryType) : var_export($deliveryType, true), implode(', ', \Gek\UyumBahce\EnumType\InvoiceDeliveryType::getValidValues())), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get NewGenerationPamentRecorderInfo value
     * @return \Gek\UyumBahce\StructType\NewGenerationPaymentRecorderInformation|null
     */
    public function getNewGenerationPamentRecorderInfo()
    {
        return $this->NewGenerationPamentRecorderInfo;
    }
    /**
     * Set NewGenerationPamentRecorderInfo value
     * @param \Gek\UyumBahce\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo
     * @return \Gek\UyumBahce\StructType\EArchiveInvoiceInformation
     */
    public function setNewGenerationPamentRecorderInfo(\Gek\UyumBahce\StructType\NewGenerationPaymentRecorderInformation $newGenerationPamentRecorderInfo = null)
    {
        $this->NewGenerationPamentRecorderInfo = $newGenerationPamentRecorderInfo;
        return $this;
    }
    /**
     * Get InternetSalesInfo value
     * @return \Gek\UyumBahce\StructType\InternetSalesInformation|null
     */
    public function getInternetSalesInfo()
    {
        return $this->InternetSalesInfo;
    }
    /**
     * Set InternetSalesInfo value
     * @param \Gek\UyumBahce\StructType\InternetSalesInformation $internetSalesInfo
     * @return \Gek\UyumBahce\StructType\EArchiveInvoiceInformation
     */
    public function setInternetSalesInfo(\Gek\UyumBahce\StructType\InternetSalesInformation $internetSalesInfo = null)
    {
        $this->InternetSalesInfo = $internetSalesInfo;
        return $this;
    }
    /**
     * Get WithHoldings value
     * @return \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation[]|null
     */
    public function getWithHoldings()
    {
        return $this->WithHoldings;
    }
    /**
     * This method is responsible for validating the values passed to the setWithHoldings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithHoldings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithHoldingsForArrayConstraintsFromSetWithHoldings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eArchiveInvoiceInformationWithHoldingsItem) {
            // validation for constraint: itemType
            if (!$eArchiveInvoiceInformationWithHoldingsItem instanceof \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation) {
                $invalidValues[] = is_object($eArchiveInvoiceInformationWithHoldingsItem) ? get_class($eArchiveInvoiceInformationWithHoldingsItem) : sprintf('%s(%s)', gettype($eArchiveInvoiceInformationWithHoldingsItem), var_export($eArchiveInvoiceInformationWithHoldingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithHoldings property can only contain items of type \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WithHoldings value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation[] $withHoldings
     * @return \Gek\UyumBahce\StructType\EArchiveInvoiceInformation
     */
    public function setWithHoldings(array $withHoldings = array())
    {
        // validation for constraint: array
        if ('' !== ($withHoldingsArrayErrorMessage = self::validateWithHoldingsForArrayConstraintsFromSetWithHoldings($withHoldings))) {
            throw new \InvalidArgumentException($withHoldingsArrayErrorMessage, __LINE__);
        }
        $this->WithHoldings = $withHoldings;
        return $this;
    }
    /**
     * Add item to WithHoldings value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation $item
     * @return \Gek\UyumBahce\StructType\EArchiveInvoiceInformation
     */
    public function addToWithHoldings(\Gek\UyumBahce\StructType\EArchiveWithHoldingInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation) {
            throw new \InvalidArgumentException(sprintf('The WithHoldings property can only contain items of type \Gek\UyumBahce\StructType\EArchiveWithHoldingInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithHoldings[] = $item;
        return $this;
    }
}
