<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentReferenceType StructType
 * @subpackage Structs
 */
class DocumentReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IssueDate
     * @var \Gek\UyumBahce\StructType\IssueDateType
     */
    public $IssueDate;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DocumentTypeCode
     * @var \Gek\UyumBahce\StructType\DocumentTypeCodeType
     */
    public $DocumentTypeCode;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DocumentType
     * @var \Gek\UyumBahce\StructType\DocumentTypeType
     */
    public $DocumentType;
    /**
     * The DocumentDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:DocumentDescription
     * @var \Gek\UyumBahce\StructType\DocumentDescriptionType[]
     */
    public $DocumentDescription;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\AttachmentType
     */
    public $Attachment;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The IssuerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyType
     */
    public $IssuerParty;
    /**
     * Constructor method for DocumentReferenceType
     * @uses DocumentReferenceType::setID()
     * @uses DocumentReferenceType::setIssueDate()
     * @uses DocumentReferenceType::setDocumentTypeCode()
     * @uses DocumentReferenceType::setDocumentType()
     * @uses DocumentReferenceType::setDocumentDescription()
     * @uses DocumentReferenceType::setAttachment()
     * @uses DocumentReferenceType::setValidityPeriod()
     * @uses DocumentReferenceType::setIssuerParty()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\IssueDateType $issueDate
     * @param \Gek\UyumBahce\StructType\DocumentTypeCodeType $documentTypeCode
     * @param \Gek\UyumBahce\StructType\DocumentTypeType $documentType
     * @param \Gek\UyumBahce\StructType\DocumentDescriptionType[] $documentDescription
     * @param \Gek\UyumBahce\StructType\AttachmentType $attachment
     * @param \Gek\UyumBahce\StructType\PeriodType $validityPeriod
     * @param \Gek\UyumBahce\StructType\PartyType $issuerParty
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\IssueDateType $issueDate = null, \Gek\UyumBahce\StructType\DocumentTypeCodeType $documentTypeCode = null, \Gek\UyumBahce\StructType\DocumentTypeType $documentType = null, array $documentDescription = array(), \Gek\UyumBahce\StructType\AttachmentType $attachment = null, \Gek\UyumBahce\StructType\PeriodType $validityPeriod = null, \Gek\UyumBahce\StructType\PartyType $issuerParty = null)
    {
        $this
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setDocumentTypeCode($documentTypeCode)
            ->setDocumentType($documentType)
            ->setDocumentDescription($documentDescription)
            ->setAttachment($attachment)
            ->setValidityPeriod($validityPeriod)
            ->setIssuerParty($issuerParty);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return \Gek\UyumBahce\StructType\IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param \Gek\UyumBahce\StructType\IssueDateType $issueDate
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setIssueDate(\Gek\UyumBahce\StructType\IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * @return \Gek\UyumBahce\StructType\DocumentTypeCodeType|null
     */
    public function getDocumentTypeCode()
    {
        return $this->DocumentTypeCode;
    }
    /**
     * Set DocumentTypeCode value
     * @param \Gek\UyumBahce\StructType\DocumentTypeCodeType $documentTypeCode
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setDocumentTypeCode(\Gek\UyumBahce\StructType\DocumentTypeCodeType $documentTypeCode = null)
    {
        $this->DocumentTypeCode = $documentTypeCode;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return \Gek\UyumBahce\StructType\DocumentTypeType|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param \Gek\UyumBahce\StructType\DocumentTypeType $documentType
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setDocumentType(\Gek\UyumBahce\StructType\DocumentTypeType $documentType = null)
    {
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentDescription value
     * @return \Gek\UyumBahce\StructType\DocumentDescriptionType[]|null
     */
    public function getDocumentDescription()
    {
        return $this->DocumentDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentReferenceTypeDocumentDescriptionItem) {
            // validation for constraint: itemType
            if (!$documentReferenceTypeDocumentDescriptionItem instanceof \Gek\UyumBahce\StructType\DocumentDescriptionType) {
                $invalidValues[] = is_object($documentReferenceTypeDocumentDescriptionItem) ? get_class($documentReferenceTypeDocumentDescriptionItem) : sprintf('%s(%s)', gettype($documentReferenceTypeDocumentDescriptionItem), var_export($documentReferenceTypeDocumentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentDescription property can only contain items of type \Gek\UyumBahce\StructType\DocumentDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentDescriptionType[] $documentDescription
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setDocumentDescription(array $documentDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDescriptionArrayErrorMessage = self::validateDocumentDescriptionForArrayConstraintsFromSetDocumentDescription($documentDescription))) {
            throw new \InvalidArgumentException($documentDescriptionArrayErrorMessage, __LINE__);
        }
        $this->DocumentDescription = $documentDescription;
        return $this;
    }
    /**
     * Add item to DocumentDescription value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DocumentDescriptionType $item
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function addToDocumentDescription(\Gek\UyumBahce\StructType\DocumentDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DocumentDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The DocumentDescription property can only contain items of type \Gek\UyumBahce\StructType\DocumentDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentDescription[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \Gek\UyumBahce\StructType\AttachmentType|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \Gek\UyumBahce\StructType\AttachmentType $attachment
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setAttachment(\Gek\UyumBahce\StructType\AttachmentType $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \Gek\UyumBahce\StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \Gek\UyumBahce\StructType\PeriodType $validityPeriod
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setValidityPeriod(\Gek\UyumBahce\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get IssuerParty value
     * @return \Gek\UyumBahce\StructType\PartyType|null
     */
    public function getIssuerParty()
    {
        return $this->IssuerParty;
    }
    /**
     * Set IssuerParty value
     * @param \Gek\UyumBahce\StructType\PartyType $issuerParty
     * @return \Gek\UyumBahce\StructType\DocumentReferenceType
     */
    public function setIssuerParty(\Gek\UyumBahce\StructType\PartyType $issuerParty = null)
    {
        $this->IssuerParty = $issuerParty;
        return $this;
    }
}
