<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionType StructType
 * @subpackage Structs
 */
class DimensionType extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AttributeID
     * @var \Gek\UyumBahce\StructType\AttributeIDType
     */
    public $AttributeID;
    /**
     * The Measure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Measure
     * @var \Gek\UyumBahce\StructType\MeasureType
     */
    public $Measure;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Description
     * @var \Gek\UyumBahce\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The MinimumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:MinimumMeasure
     * @var \Gek\UyumBahce\StructType\MinimumMeasureType
     */
    public $MinimumMeasure;
    /**
     * The MaximumMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:MaximumMeasure
     * @var \Gek\UyumBahce\StructType\MaximumMeasureType
     */
    public $MaximumMeasure;
    /**
     * Constructor method for DimensionType
     * @uses DimensionType::setAttributeID()
     * @uses DimensionType::setMeasure()
     * @uses DimensionType::setDescription()
     * @uses DimensionType::setMinimumMeasure()
     * @uses DimensionType::setMaximumMeasure()
     * @param \Gek\UyumBahce\StructType\AttributeIDType $attributeID
     * @param \Gek\UyumBahce\StructType\MeasureType $measure
     * @param \Gek\UyumBahce\StructType\DescriptionType[] $description
     * @param \Gek\UyumBahce\StructType\MinimumMeasureType $minimumMeasure
     * @param \Gek\UyumBahce\StructType\MaximumMeasureType $maximumMeasure
     */
    public function __construct(\Gek\UyumBahce\StructType\AttributeIDType $attributeID = null, \Gek\UyumBahce\StructType\MeasureType $measure = null, array $description = array(), \Gek\UyumBahce\StructType\MinimumMeasureType $minimumMeasure = null, \Gek\UyumBahce\StructType\MaximumMeasureType $maximumMeasure = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setMeasure($measure)
            ->setDescription($description)
            ->setMinimumMeasure($minimumMeasure)
            ->setMaximumMeasure($maximumMeasure);
    }
    /**
     * Get AttributeID value
     * @return \Gek\UyumBahce\StructType\AttributeIDType|null
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param \Gek\UyumBahce\StructType\AttributeIDType $attributeID
     * @return \Gek\UyumBahce\StructType\DimensionType
     */
    public function setAttributeID(\Gek\UyumBahce\StructType\AttributeIDType $attributeID = null)
    {
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get Measure value
     * @return \Gek\UyumBahce\StructType\MeasureType|null
     */
    public function getMeasure()
    {
        return $this->Measure;
    }
    /**
     * Set Measure value
     * @param \Gek\UyumBahce\StructType\MeasureType $measure
     * @return \Gek\UyumBahce\StructType\DimensionType
     */
    public function setMeasure(\Gek\UyumBahce\StructType\MeasureType $measure = null)
    {
        $this->Measure = $measure;
        return $this;
    }
    /**
     * Get Description value
     * @return \Gek\UyumBahce\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dimensionTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$dimensionTypeDescriptionItem instanceof \Gek\UyumBahce\StructType\DescriptionType) {
                $invalidValues[] = is_object($dimensionTypeDescriptionItem) ? get_class($dimensionTypeDescriptionItem) : sprintf('%s(%s)', gettype($dimensionTypeDescriptionItem), var_export($dimensionTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DescriptionType[] $description
     * @return \Gek\UyumBahce\StructType\DimensionType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DescriptionType $item
     * @return \Gek\UyumBahce\StructType\DimensionType
     */
    public function addToDescription(\Gek\UyumBahce\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \Gek\UyumBahce\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get MinimumMeasure value
     * @return \Gek\UyumBahce\StructType\MinimumMeasureType|null
     */
    public function getMinimumMeasure()
    {
        return $this->MinimumMeasure;
    }
    /**
     * Set MinimumMeasure value
     * @param \Gek\UyumBahce\StructType\MinimumMeasureType $minimumMeasure
     * @return \Gek\UyumBahce\StructType\DimensionType
     */
    public function setMinimumMeasure(\Gek\UyumBahce\StructType\MinimumMeasureType $minimumMeasure = null)
    {
        $this->MinimumMeasure = $minimumMeasure;
        return $this;
    }
    /**
     * Get MaximumMeasure value
     * @return \Gek\UyumBahce\StructType\MaximumMeasureType|null
     */
    public function getMaximumMeasure()
    {
        return $this->MaximumMeasure;
    }
    /**
     * Set MaximumMeasure value
     * @param \Gek\UyumBahce\StructType\MaximumMeasureType $maximumMeasure
     * @return \Gek\UyumBahce\StructType\DimensionType
     */
    public function setMaximumMeasure(\Gek\UyumBahce\StructType\MaximumMeasureType $maximumMeasure = null)
    {
        $this->MaximumMeasure = $maximumMeasure;
        return $this;
    }
}
