<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryType StructType
 * @subpackage Structs
 */
class DeliveryType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var \Gek\UyumBahce\StructType\IDType
     */
    public $ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Quantity
     * @var \Gek\UyumBahce\StructType\QuantityType
     */
    public $Quantity;
    /**
     * The ActualDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ActualDeliveryDate
     * @var \Gek\UyumBahce\StructType\ActualDeliveryDateType
     */
    public $ActualDeliveryDate;
    /**
     * The ActualDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ActualDeliveryTime
     * @var \Gek\UyumBahce\StructType\ActualDeliveryTimeType
     */
    public $ActualDeliveryTime;
    /**
     * The LatestDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LatestDeliveryDate
     * @var \Gek\UyumBahce\StructType\LatestDeliveryDateType
     */
    public $LatestDeliveryDate;
    /**
     * The LatestDeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LatestDeliveryTime
     * @var \Gek\UyumBahce\StructType\LatestDeliveryTimeType
     */
    public $LatestDeliveryTime;
    /**
     * The TrackingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TrackingID
     * @var \Gek\UyumBahce\StructType\TrackingIDType
     */
    public $TrackingID;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\AddressType
     */
    public $DeliveryAddress;
    /**
     * The AlternativeDeliveryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\LocationType
     */
    public $AlternativeDeliveryLocation;
    /**
     * The EstimatedDeliveryPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PeriodType
     */
    public $EstimatedDeliveryPeriod;
    /**
     * The CarrierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyType
     */
    public $CarrierParty;
    /**
     * The DeliveryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\PartyType
     */
    public $DeliveryParty;
    /**
     * The Despatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DespatchType
     */
    public $Despatch;
    /**
     * The DeliveryTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\DeliveryTermsType[]
     */
    public $DeliveryTerms;
    /**
     * The Shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\ShipmentType
     */
    public $Shipment;
    /**
     * Constructor method for DeliveryType
     * @uses DeliveryType::setID()
     * @uses DeliveryType::setQuantity()
     * @uses DeliveryType::setActualDeliveryDate()
     * @uses DeliveryType::setActualDeliveryTime()
     * @uses DeliveryType::setLatestDeliveryDate()
     * @uses DeliveryType::setLatestDeliveryTime()
     * @uses DeliveryType::setTrackingID()
     * @uses DeliveryType::setDeliveryAddress()
     * @uses DeliveryType::setAlternativeDeliveryLocation()
     * @uses DeliveryType::setEstimatedDeliveryPeriod()
     * @uses DeliveryType::setCarrierParty()
     * @uses DeliveryType::setDeliveryParty()
     * @uses DeliveryType::setDespatch()
     * @uses DeliveryType::setDeliveryTerms()
     * @uses DeliveryType::setShipment()
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @param \Gek\UyumBahce\StructType\QuantityType $quantity
     * @param \Gek\UyumBahce\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @param \Gek\UyumBahce\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @param \Gek\UyumBahce\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @param \Gek\UyumBahce\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @param \Gek\UyumBahce\StructType\TrackingIDType $trackingID
     * @param \Gek\UyumBahce\StructType\AddressType $deliveryAddress
     * @param \Gek\UyumBahce\StructType\LocationType $alternativeDeliveryLocation
     * @param \Gek\UyumBahce\StructType\PeriodType $estimatedDeliveryPeriod
     * @param \Gek\UyumBahce\StructType\PartyType $carrierParty
     * @param \Gek\UyumBahce\StructType\PartyType $deliveryParty
     * @param \Gek\UyumBahce\StructType\DespatchType $despatch
     * @param \Gek\UyumBahce\StructType\DeliveryTermsType[] $deliveryTerms
     * @param \Gek\UyumBahce\StructType\ShipmentType $shipment
     */
    public function __construct(\Gek\UyumBahce\StructType\IDType $iD = null, \Gek\UyumBahce\StructType\QuantityType $quantity = null, \Gek\UyumBahce\StructType\ActualDeliveryDateType $actualDeliveryDate = null, \Gek\UyumBahce\StructType\ActualDeliveryTimeType $actualDeliveryTime = null, \Gek\UyumBahce\StructType\LatestDeliveryDateType $latestDeliveryDate = null, \Gek\UyumBahce\StructType\LatestDeliveryTimeType $latestDeliveryTime = null, \Gek\UyumBahce\StructType\TrackingIDType $trackingID = null, \Gek\UyumBahce\StructType\AddressType $deliveryAddress = null, \Gek\UyumBahce\StructType\LocationType $alternativeDeliveryLocation = null, \Gek\UyumBahce\StructType\PeriodType $estimatedDeliveryPeriod = null, \Gek\UyumBahce\StructType\PartyType $carrierParty = null, \Gek\UyumBahce\StructType\PartyType $deliveryParty = null, \Gek\UyumBahce\StructType\DespatchType $despatch = null, array $deliveryTerms = array(), \Gek\UyumBahce\StructType\ShipmentType $shipment = null)
    {
        $this
            ->setID($iD)
            ->setQuantity($quantity)
            ->setActualDeliveryDate($actualDeliveryDate)
            ->setActualDeliveryTime($actualDeliveryTime)
            ->setLatestDeliveryDate($latestDeliveryDate)
            ->setLatestDeliveryTime($latestDeliveryTime)
            ->setTrackingID($trackingID)
            ->setDeliveryAddress($deliveryAddress)
            ->setAlternativeDeliveryLocation($alternativeDeliveryLocation)
            ->setEstimatedDeliveryPeriod($estimatedDeliveryPeriod)
            ->setCarrierParty($carrierParty)
            ->setDeliveryParty($deliveryParty)
            ->setDespatch($despatch)
            ->setDeliveryTerms($deliveryTerms)
            ->setShipment($shipment);
    }
    /**
     * Get ID value
     * @return \Gek\UyumBahce\StructType\IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \Gek\UyumBahce\StructType\IDType $iD
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setID(\Gek\UyumBahce\StructType\IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \Gek\UyumBahce\StructType\QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \Gek\UyumBahce\StructType\QuantityType $quantity
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setQuantity(\Gek\UyumBahce\StructType\QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ActualDeliveryDate value
     * @return \Gek\UyumBahce\StructType\ActualDeliveryDateType|null
     */
    public function getActualDeliveryDate()
    {
        return $this->ActualDeliveryDate;
    }
    /**
     * Set ActualDeliveryDate value
     * @param \Gek\UyumBahce\StructType\ActualDeliveryDateType $actualDeliveryDate
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setActualDeliveryDate(\Gek\UyumBahce\StructType\ActualDeliveryDateType $actualDeliveryDate = null)
    {
        $this->ActualDeliveryDate = $actualDeliveryDate;
        return $this;
    }
    /**
     * Get ActualDeliveryTime value
     * @return \Gek\UyumBahce\StructType\ActualDeliveryTimeType|null
     */
    public function getActualDeliveryTime()
    {
        return $this->ActualDeliveryTime;
    }
    /**
     * Set ActualDeliveryTime value
     * @param \Gek\UyumBahce\StructType\ActualDeliveryTimeType $actualDeliveryTime
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setActualDeliveryTime(\Gek\UyumBahce\StructType\ActualDeliveryTimeType $actualDeliveryTime = null)
    {
        $this->ActualDeliveryTime = $actualDeliveryTime;
        return $this;
    }
    /**
     * Get LatestDeliveryDate value
     * @return \Gek\UyumBahce\StructType\LatestDeliveryDateType|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->LatestDeliveryDate;
    }
    /**
     * Set LatestDeliveryDate value
     * @param \Gek\UyumBahce\StructType\LatestDeliveryDateType $latestDeliveryDate
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setLatestDeliveryDate(\Gek\UyumBahce\StructType\LatestDeliveryDateType $latestDeliveryDate = null)
    {
        $this->LatestDeliveryDate = $latestDeliveryDate;
        return $this;
    }
    /**
     * Get LatestDeliveryTime value
     * @return \Gek\UyumBahce\StructType\LatestDeliveryTimeType|null
     */
    public function getLatestDeliveryTime()
    {
        return $this->LatestDeliveryTime;
    }
    /**
     * Set LatestDeliveryTime value
     * @param \Gek\UyumBahce\StructType\LatestDeliveryTimeType $latestDeliveryTime
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setLatestDeliveryTime(\Gek\UyumBahce\StructType\LatestDeliveryTimeType $latestDeliveryTime = null)
    {
        $this->LatestDeliveryTime = $latestDeliveryTime;
        return $this;
    }
    /**
     * Get TrackingID value
     * @return \Gek\UyumBahce\StructType\TrackingIDType|null
     */
    public function getTrackingID()
    {
        return $this->TrackingID;
    }
    /**
     * Set TrackingID value
     * @param \Gek\UyumBahce\StructType\TrackingIDType $trackingID
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setTrackingID(\Gek\UyumBahce\StructType\TrackingIDType $trackingID = null)
    {
        $this->TrackingID = $trackingID;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \Gek\UyumBahce\StructType\AddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \Gek\UyumBahce\StructType\AddressType $deliveryAddress
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setDeliveryAddress(\Gek\UyumBahce\StructType\AddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get AlternativeDeliveryLocation value
     * @return \Gek\UyumBahce\StructType\LocationType|null
     */
    public function getAlternativeDeliveryLocation()
    {
        return $this->AlternativeDeliveryLocation;
    }
    /**
     * Set AlternativeDeliveryLocation value
     * @param \Gek\UyumBahce\StructType\LocationType $alternativeDeliveryLocation
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setAlternativeDeliveryLocation(\Gek\UyumBahce\StructType\LocationType $alternativeDeliveryLocation = null)
    {
        $this->AlternativeDeliveryLocation = $alternativeDeliveryLocation;
        return $this;
    }
    /**
     * Get EstimatedDeliveryPeriod value
     * @return \Gek\UyumBahce\StructType\PeriodType|null
     */
    public function getEstimatedDeliveryPeriod()
    {
        return $this->EstimatedDeliveryPeriod;
    }
    /**
     * Set EstimatedDeliveryPeriod value
     * @param \Gek\UyumBahce\StructType\PeriodType $estimatedDeliveryPeriod
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setEstimatedDeliveryPeriod(\Gek\UyumBahce\StructType\PeriodType $estimatedDeliveryPeriod = null)
    {
        $this->EstimatedDeliveryPeriod = $estimatedDeliveryPeriod;
        return $this;
    }
    /**
     * Get CarrierParty value
     * @return \Gek\UyumBahce\StructType\PartyType|null
     */
    public function getCarrierParty()
    {
        return $this->CarrierParty;
    }
    /**
     * Set CarrierParty value
     * @param \Gek\UyumBahce\StructType\PartyType $carrierParty
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setCarrierParty(\Gek\UyumBahce\StructType\PartyType $carrierParty = null)
    {
        $this->CarrierParty = $carrierParty;
        return $this;
    }
    /**
     * Get DeliveryParty value
     * @return \Gek\UyumBahce\StructType\PartyType|null
     */
    public function getDeliveryParty()
    {
        return $this->DeliveryParty;
    }
    /**
     * Set DeliveryParty value
     * @param \Gek\UyumBahce\StructType\PartyType $deliveryParty
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setDeliveryParty(\Gek\UyumBahce\StructType\PartyType $deliveryParty = null)
    {
        $this->DeliveryParty = $deliveryParty;
        return $this;
    }
    /**
     * Get Despatch value
     * @return \Gek\UyumBahce\StructType\DespatchType|null
     */
    public function getDespatch()
    {
        return $this->Despatch;
    }
    /**
     * Set Despatch value
     * @param \Gek\UyumBahce\StructType\DespatchType $despatch
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setDespatch(\Gek\UyumBahce\StructType\DespatchType $despatch = null)
    {
        $this->Despatch = $despatch;
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * @return \Gek\UyumBahce\StructType\DeliveryTermsType[]|null
     */
    public function getDeliveryTerms()
    {
        return $this->DeliveryTerms;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliveryTerms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliveryTerms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deliveryTypeDeliveryTermsItem) {
            // validation for constraint: itemType
            if (!$deliveryTypeDeliveryTermsItem instanceof \Gek\UyumBahce\StructType\DeliveryTermsType) {
                $invalidValues[] = is_object($deliveryTypeDeliveryTermsItem) ? get_class($deliveryTypeDeliveryTermsItem) : sprintf('%s(%s)', gettype($deliveryTypeDeliveryTermsItem), var_export($deliveryTypeDeliveryTermsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeliveryTerms property can only contain items of type \Gek\UyumBahce\StructType\DeliveryTermsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DeliveryTermsType[] $deliveryTerms
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setDeliveryTerms(array $deliveryTerms = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryTermsArrayErrorMessage = self::validateDeliveryTermsForArrayConstraintsFromSetDeliveryTerms($deliveryTerms))) {
            throw new \InvalidArgumentException($deliveryTermsArrayErrorMessage, __LINE__);
        }
        $this->DeliveryTerms = $deliveryTerms;
        return $this;
    }
    /**
     * Add item to DeliveryTerms value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\DeliveryTermsType $item
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function addToDeliveryTerms(\Gek\UyumBahce\StructType\DeliveryTermsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\DeliveryTermsType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryTerms property can only contain items of type \Gek\UyumBahce\StructType\DeliveryTermsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeliveryTerms[] = $item;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \Gek\UyumBahce\StructType\ShipmentType|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \Gek\UyumBahce\StructType\ShipmentType $shipment
     * @return \Gek\UyumBahce\StructType\DeliveryType
     */
    public function setShipment(\Gek\UyumBahce\StructType\ShipmentType $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
}
