<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountMMDef StructType
 * @subpackage Structs
 */
class AccountMMDef extends AbstractStructBase
{
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxRate;
    /**
     * The AccCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccCode;
    /**
     * The AccDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccDesc;
    /**
     * The CoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoCode;
    /**
     * The AccCodeVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccCodeVat;
    /**
     * The AccDescVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccDescVat;
    /**
     * The TaxNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxNo;
    /**
     * The IdentifyNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdentifyNo;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The DeclarationAdressNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeclarationAdressNo;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Familyname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Familyname;
    /**
     * The Firstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Firstname;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The MobileTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobileTel;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The TownName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TownName;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The FinancialCountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FinancialCountryCode;
    /**
     * The TaxOfficeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxOfficeCode;
    /**
     * The Tel1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tel1;
    /**
     * Constructor method for AccountMMDef
     * @uses AccountMMDef::setTaxRate()
     * @uses AccountMMDef::setAccCode()
     * @uses AccountMMDef::setAccDesc()
     * @uses AccountMMDef::setCoCode()
     * @uses AccountMMDef::setAccCodeVat()
     * @uses AccountMMDef::setAccDescVat()
     * @uses AccountMMDef::setTaxNo()
     * @uses AccountMMDef::setIdentifyNo()
     * @uses AccountMMDef::setAddress()
     * @uses AccountMMDef::setDeclarationAdressNo()
     * @uses AccountMMDef::setEmail()
     * @uses AccountMMDef::setFamilyname()
     * @uses AccountMMDef::setFirstname()
     * @uses AccountMMDef::setFax()
     * @uses AccountMMDef::setMobileTel()
     * @uses AccountMMDef::setZipCode()
     * @uses AccountMMDef::setCityName()
     * @uses AccountMMDef::setTownName()
     * @uses AccountMMDef::setCountryName()
     * @uses AccountMMDef::setFinancialCountryCode()
     * @uses AccountMMDef::setTaxOfficeCode()
     * @uses AccountMMDef::setTel1()
     * @param float $taxRate
     * @param string $accCode
     * @param string $accDesc
     * @param string $coCode
     * @param string $accCodeVat
     * @param string $accDescVat
     * @param string $taxNo
     * @param string $identifyNo
     * @param string $address
     * @param string $declarationAdressNo
     * @param string $email
     * @param string $familyname
     * @param string $firstname
     * @param string $fax
     * @param string $mobileTel
     * @param string $zipCode
     * @param string $cityName
     * @param string $townName
     * @param string $countryName
     * @param string $financialCountryCode
     * @param string $taxOfficeCode
     * @param string $tel1
     */
    public function __construct($taxRate = null, $accCode = null, $accDesc = null, $coCode = null, $accCodeVat = null, $accDescVat = null, $taxNo = null, $identifyNo = null, $address = null, $declarationAdressNo = null, $email = null, $familyname = null, $firstname = null, $fax = null, $mobileTel = null, $zipCode = null, $cityName = null, $townName = null, $countryName = null, $financialCountryCode = null, $taxOfficeCode = null, $tel1 = null)
    {
        $this
            ->setTaxRate($taxRate)
            ->setAccCode($accCode)
            ->setAccDesc($accDesc)
            ->setCoCode($coCode)
            ->setAccCodeVat($accCodeVat)
            ->setAccDescVat($accDescVat)
            ->setTaxNo($taxNo)
            ->setIdentifyNo($identifyNo)
            ->setAddress($address)
            ->setDeclarationAdressNo($declarationAdressNo)
            ->setEmail($email)
            ->setFamilyname($familyname)
            ->setFirstname($firstname)
            ->setFax($fax)
            ->setMobileTel($mobileTel)
            ->setZipCode($zipCode)
            ->setCityName($cityName)
            ->setTownName($townName)
            ->setCountryName($countryName)
            ->setFinancialCountryCode($financialCountryCode)
            ->setTaxOfficeCode($taxOfficeCode)
            ->setTel1($tel1);
    }
    /**
     * Get TaxRate value
     * @return float
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get AccCode value
     * @return string|null
     */
    public function getAccCode()
    {
        return $this->AccCode;
    }
    /**
     * Set AccCode value
     * @param string $accCode
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setAccCode($accCode = null)
    {
        // validation for constraint: string
        if (!is_null($accCode) && !is_string($accCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accCode, true), gettype($accCode)), __LINE__);
        }
        $this->AccCode = $accCode;
        return $this;
    }
    /**
     * Get AccDesc value
     * @return string|null
     */
    public function getAccDesc()
    {
        return $this->AccDesc;
    }
    /**
     * Set AccDesc value
     * @param string $accDesc
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setAccDesc($accDesc = null)
    {
        // validation for constraint: string
        if (!is_null($accDesc) && !is_string($accDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accDesc, true), gettype($accDesc)), __LINE__);
        }
        $this->AccDesc = $accDesc;
        return $this;
    }
    /**
     * Get CoCode value
     * @return string|null
     */
    public function getCoCode()
    {
        return $this->CoCode;
    }
    /**
     * Set CoCode value
     * @param string $coCode
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setCoCode($coCode = null)
    {
        // validation for constraint: string
        if (!is_null($coCode) && !is_string($coCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coCode, true), gettype($coCode)), __LINE__);
        }
        $this->CoCode = $coCode;
        return $this;
    }
    /**
     * Get AccCodeVat value
     * @return string|null
     */
    public function getAccCodeVat()
    {
        return $this->AccCodeVat;
    }
    /**
     * Set AccCodeVat value
     * @param string $accCodeVat
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setAccCodeVat($accCodeVat = null)
    {
        // validation for constraint: string
        if (!is_null($accCodeVat) && !is_string($accCodeVat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accCodeVat, true), gettype($accCodeVat)), __LINE__);
        }
        $this->AccCodeVat = $accCodeVat;
        return $this;
    }
    /**
     * Get AccDescVat value
     * @return string|null
     */
    public function getAccDescVat()
    {
        return $this->AccDescVat;
    }
    /**
     * Set AccDescVat value
     * @param string $accDescVat
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setAccDescVat($accDescVat = null)
    {
        // validation for constraint: string
        if (!is_null($accDescVat) && !is_string($accDescVat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accDescVat, true), gettype($accDescVat)), __LINE__);
        }
        $this->AccDescVat = $accDescVat;
        return $this;
    }
    /**
     * Get TaxNo value
     * @return string|null
     */
    public function getTaxNo()
    {
        return $this->TaxNo;
    }
    /**
     * Set TaxNo value
     * @param string $taxNo
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setTaxNo($taxNo = null)
    {
        // validation for constraint: string
        if (!is_null($taxNo) && !is_string($taxNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNo, true), gettype($taxNo)), __LINE__);
        }
        $this->TaxNo = $taxNo;
        return $this;
    }
    /**
     * Get IdentifyNo value
     * @return string|null
     */
    public function getIdentifyNo()
    {
        return $this->IdentifyNo;
    }
    /**
     * Set IdentifyNo value
     * @param string $identifyNo
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setIdentifyNo($identifyNo = null)
    {
        // validation for constraint: string
        if (!is_null($identifyNo) && !is_string($identifyNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifyNo, true), gettype($identifyNo)), __LINE__);
        }
        $this->IdentifyNo = $identifyNo;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get DeclarationAdressNo value
     * @return string|null
     */
    public function getDeclarationAdressNo()
    {
        return $this->DeclarationAdressNo;
    }
    /**
     * Set DeclarationAdressNo value
     * @param string $declarationAdressNo
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setDeclarationAdressNo($declarationAdressNo = null)
    {
        // validation for constraint: string
        if (!is_null($declarationAdressNo) && !is_string($declarationAdressNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declarationAdressNo, true), gettype($declarationAdressNo)), __LINE__);
        }
        $this->DeclarationAdressNo = $declarationAdressNo;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Familyname value
     * @return string|null
     */
    public function getFamilyname()
    {
        return $this->Familyname;
    }
    /**
     * Set Familyname value
     * @param string $familyname
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setFamilyname($familyname = null)
    {
        // validation for constraint: string
        if (!is_null($familyname) && !is_string($familyname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familyname, true), gettype($familyname)), __LINE__);
        }
        $this->Familyname = $familyname;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get MobileTel value
     * @return string|null
     */
    public function getMobileTel()
    {
        return $this->MobileTel;
    }
    /**
     * Set MobileTel value
     * @param string $mobileTel
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setMobileTel($mobileTel = null)
    {
        // validation for constraint: string
        if (!is_null($mobileTel) && !is_string($mobileTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileTel, true), gettype($mobileTel)), __LINE__);
        }
        $this->MobileTel = $mobileTel;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get TownName value
     * @return string|null
     */
    public function getTownName()
    {
        return $this->TownName;
    }
    /**
     * Set TownName value
     * @param string $townName
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setTownName($townName = null)
    {
        // validation for constraint: string
        if (!is_null($townName) && !is_string($townName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($townName, true), gettype($townName)), __LINE__);
        }
        $this->TownName = $townName;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get FinancialCountryCode value
     * @return string|null
     */
    public function getFinancialCountryCode()
    {
        return $this->FinancialCountryCode;
    }
    /**
     * Set FinancialCountryCode value
     * @param string $financialCountryCode
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setFinancialCountryCode($financialCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($financialCountryCode) && !is_string($financialCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialCountryCode, true), gettype($financialCountryCode)), __LINE__);
        }
        $this->FinancialCountryCode = $financialCountryCode;
        return $this;
    }
    /**
     * Get TaxOfficeCode value
     * @return string|null
     */
    public function getTaxOfficeCode()
    {
        return $this->TaxOfficeCode;
    }
    /**
     * Set TaxOfficeCode value
     * @param string $taxOfficeCode
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setTaxOfficeCode($taxOfficeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxOfficeCode) && !is_string($taxOfficeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOfficeCode, true), gettype($taxOfficeCode)), __LINE__);
        }
        $this->TaxOfficeCode = $taxOfficeCode;
        return $this;
    }
    /**
     * Get Tel1 value
     * @return string|null
     */
    public function getTel1()
    {
        return $this->Tel1;
    }
    /**
     * Set Tel1 value
     * @param string $tel1
     * @return \Gek\UyumBahce\StructType\AccountMMDef
     */
    public function setTel1($tel1 = null)
    {
        // validation for constraint: string
        if (!is_null($tel1) && !is_string($tel1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tel1, true), gettype($tel1)), __LINE__);
        }
        $this->Tel1 = $tel1;
        return $this;
    }
}
