<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccDetailDef StructType
 * @subpackage Structs
 */
class AccDetailDef extends DetailFields
{
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreateDate;
    /**
     * The AccId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AccId;
    /**
     * The Amt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amt;
    /**
     * The AmtTra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmtTra;
    /**
     * The AmtDebit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtDebit;
    /**
     * The AmtCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtCredit;
    /**
     * The TraTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TraTypeId;
    /**
     * The EbookDocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EbookDocumentType;
    /**
     * The EbookPaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EbookPaymentMethod;
    /**
     * The AccCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccCode;
    /**
     * The AccDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccDesc;
    /**
     * The TaxNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxNo;
    /**
     * The IdentifyNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdentifyNo;
    /**
     * The TraTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TraTypeCode;
    /**
     * Constructor method for AccDetailDef
     * @uses AccDetailDef::setCreateDate()
     * @uses AccDetailDef::setAccId()
     * @uses AccDetailDef::setAmt()
     * @uses AccDetailDef::setAmtTra()
     * @uses AccDetailDef::setAmtDebit()
     * @uses AccDetailDef::setAmtCredit()
     * @uses AccDetailDef::setTraTypeId()
     * @uses AccDetailDef::setEbookDocumentType()
     * @uses AccDetailDef::setEbookPaymentMethod()
     * @uses AccDetailDef::setAccCode()
     * @uses AccDetailDef::setAccDesc()
     * @uses AccDetailDef::setTaxNo()
     * @uses AccDetailDef::setIdentifyNo()
     * @uses AccDetailDef::setTraTypeCode()
     * @param string|GekDateTime $createDate
     * @param int $accId
     * @param float $amt
     * @param float $amtTra
     * @param float $amtDebit
     * @param float $amtCredit
     * @param int $traTypeId
     * @param int $ebookDocumentType
     * @param int $ebookPaymentMethod
     * @param string $accCode
     * @param string $accDesc
     * @param string $taxNo
     * @param string $identifyNo
     * @param string $traTypeCode
     */
    public function __construct($createDate = null, $accId = null, $amt = null, $amtTra = null, $amtDebit = null, $amtCredit = null, $traTypeId = null, $ebookDocumentType = null, $ebookPaymentMethod = null, $accCode = null, $accDesc = null, $taxNo = null, $identifyNo = null, $traTypeCode = null)
    {
        $this
            ->setCreateDate($createDate)
            ->setAccId($accId)
            ->setAmt($amt)
            ->setAmtTra($amtTra)
            ->setAmtDebit($amtDebit)
            ->setAmtCredit($amtCredit)
            ->setTraTypeId($traTypeId)
            ->setEbookDocumentType($ebookDocumentType)
            ->setEbookPaymentMethod($ebookPaymentMethod)
            ->setAccCode($accCode)
            ->setAccDesc($accDesc)
            ->setTaxNo($taxNo)
            ->setIdentifyNo($identifyNo)
            ->setTraTypeCode($traTypeCode);
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string|GekDateTime $createDate
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate) && !($createDate instanceof GekDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        if($createDate instanceof GekDateTime){
            $createDate = $createDate->toServiceString();
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get AccId value
     * @return int
     */
    public function getAccId()
    {
        return $this->AccId;
    }
    /**
     * Set AccId value
     * @param int $accId
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setAccId($accId = null)
    {
        // validation for constraint: int
        if (!is_null($accId) && !(is_int($accId) || ctype_digit($accId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accId, true), gettype($accId)), __LINE__);
        }
        $this->AccId = $accId;
        return $this;
    }
    /**
     * Get Amt value
     * @return float
     */
    public function getAmt()
    {
        return $this->Amt;
    }
    /**
     * Set Amt value
     * @param float $amt
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setAmt($amt = null)
    {
        // validation for constraint: float
        if (!is_null($amt) && !(is_float($amt) || is_numeric($amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amt, true), gettype($amt)), __LINE__);
        }
        $this->Amt = $amt;
        return $this;
    }
    /**
     * Get AmtTra value
     * @return float
     */
    public function getAmtTra()
    {
        return $this->AmtTra;
    }
    /**
     * Set AmtTra value
     * @param float $amtTra
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setAmtTra($amtTra = null)
    {
        // validation for constraint: float
        if (!is_null($amtTra) && !(is_float($amtTra) || is_numeric($amtTra))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtTra, true), gettype($amtTra)), __LINE__);
        }
        $this->AmtTra = $amtTra;
        return $this;
    }
    /**
     * Get AmtDebit value
     * @return float
     */
    public function getAmtDebit()
    {
        return $this->AmtDebit;
    }
    /**
     * Set AmtDebit value
     * @param float $amtDebit
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setAmtDebit($amtDebit = null)
    {
        // validation for constraint: float
        if (!is_null($amtDebit) && !(is_float($amtDebit) || is_numeric($amtDebit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDebit, true), gettype($amtDebit)), __LINE__);
        }
        $this->AmtDebit = $amtDebit;
        return $this;
    }
    /**
     * Get AmtCredit value
     * @return float
     */
    public function getAmtCredit()
    {
        return $this->AmtCredit;
    }
    /**
     * Set AmtCredit value
     * @param float $amtCredit
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setAmtCredit($amtCredit = null)
    {
        // validation for constraint: float
        if (!is_null($amtCredit) && !(is_float($amtCredit) || is_numeric($amtCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtCredit, true), gettype($amtCredit)), __LINE__);
        }
        $this->AmtCredit = $amtCredit;
        return $this;
    }
    /**
     * Get TraTypeId value
     * @return int
     */
    public function getTraTypeId()
    {
        return $this->TraTypeId;
    }
    /**
     * Set TraTypeId value
     * @param int $traTypeId
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setTraTypeId($traTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($traTypeId) && !(is_int($traTypeId) || ctype_digit($traTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($traTypeId, true), gettype($traTypeId)), __LINE__);
        }
        $this->TraTypeId = $traTypeId;
        return $this;
    }
    /**
     * Get EbookDocumentType value
     * @return int
     */
    public function getEbookDocumentType()
    {
        return $this->EbookDocumentType;
    }
    /**
     * Set EbookDocumentType value
     * @param int $ebookDocumentType
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setEbookDocumentType($ebookDocumentType = null)
    {
        // validation for constraint: int
        if (!is_null($ebookDocumentType) && !(is_int($ebookDocumentType) || ctype_digit($ebookDocumentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ebookDocumentType, true), gettype($ebookDocumentType)), __LINE__);
        }
        $this->EbookDocumentType = $ebookDocumentType;
        return $this;
    }
    /**
     * Get EbookPaymentMethod value
     * @return int
     */
    public function getEbookPaymentMethod()
    {
        return $this->EbookPaymentMethod;
    }
    /**
     * Set EbookPaymentMethod value
     * @param int $ebookPaymentMethod
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setEbookPaymentMethod($ebookPaymentMethod = null)
    {
        // validation for constraint: int
        if (!is_null($ebookPaymentMethod) && !(is_int($ebookPaymentMethod) || ctype_digit($ebookPaymentMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ebookPaymentMethod, true), gettype($ebookPaymentMethod)), __LINE__);
        }
        $this->EbookPaymentMethod = $ebookPaymentMethod;
        return $this;
    }
    /**
     * Get AccCode value
     * @return string|null
     */
    public function getAccCode()
    {
        return $this->AccCode;
    }
    /**
     * Set AccCode value
     * @param string $accCode
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setAccCode($accCode = null)
    {
        // validation for constraint: string
        if (!is_null($accCode) && !is_string($accCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accCode, true), gettype($accCode)), __LINE__);
        }
        $this->AccCode = $accCode;
        return $this;
    }
    /**
     * Get AccDesc value
     * @return string|null
     */
    public function getAccDesc()
    {
        return $this->AccDesc;
    }
    /**
     * Set AccDesc value
     * @param string $accDesc
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setAccDesc($accDesc = null)
    {
        // validation for constraint: string
        if (!is_null($accDesc) && !is_string($accDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accDesc, true), gettype($accDesc)), __LINE__);
        }
        $this->AccDesc = $accDesc;
        return $this;
    }
    /**
     * Get TaxNo value
     * @return string|null
     */
    public function getTaxNo()
    {
        return $this->TaxNo;
    }
    /**
     * Set TaxNo value
     * @param string $taxNo
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setTaxNo($taxNo = null)
    {
        // validation for constraint: string
        if (!is_null($taxNo) && !is_string($taxNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNo, true), gettype($taxNo)), __LINE__);
        }
        $this->TaxNo = $taxNo;
        return $this;
    }
    /**
     * Get IdentifyNo value
     * @return string|null
     */
    public function getIdentifyNo()
    {
        return $this->IdentifyNo;
    }
    /**
     * Set IdentifyNo value
     * @param string $identifyNo
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setIdentifyNo($identifyNo = null)
    {
        // validation for constraint: string
        if (!is_null($identifyNo) && !is_string($identifyNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifyNo, true), gettype($identifyNo)), __LINE__);
        }
        $this->IdentifyNo = $identifyNo;
        return $this;
    }
    /**
     * Get TraTypeCode value
     * @return string|null
     */
    public function getTraTypeCode()
    {
        return $this->TraTypeCode;
    }
    /**
     * Set TraTypeCode value
     * @param string $traTypeCode
     * @return \Gek\UyumBahce\StructType\AccDetailDef
     */
    public function setTraTypeCode($traTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($traTypeCode) && !is_string($traTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traTypeCode, true), gettype($traTypeCode)), __LINE__);
        }
        $this->TraTypeCode = $traTypeCode;
        return $this;
    }
}
