<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccDefMM StructType
 * @subpackage Structs
 */
class AccDefMM extends AbstractStructBase
{
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CreateUserId;
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CoId;
    /**
     * The DocDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DocDate;
    /**
     * The CatCode1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CatCode1Id;
    /**
     * The CatCode2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CatCode2Id;
    /**
     * The SourceMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SourceMId;
    /**
     * The AccReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AccReceipt;
    /**
     * The AccItemNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AccItemNo;
    /**
     * The CoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoCode;
    /**
     * The DocNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocNo;
    /**
     * The CatCode1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CatCode1;
    /**
     * The CatCode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CatCode2;
    /**
     * The Note1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note1;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDefMM
     */
    public $Details;
    /**
     * Constructor method for AccDefMM
     * @uses AccDefMM::setCreateUserId()
     * @uses AccDefMM::setCoId()
     * @uses AccDefMM::setDocDate()
     * @uses AccDefMM::setCatCode1Id()
     * @uses AccDefMM::setCatCode2Id()
     * @uses AccDefMM::setSourceMId()
     * @uses AccDefMM::setAccReceipt()
     * @uses AccDefMM::setAccItemNo()
     * @uses AccDefMM::setCoCode()
     * @uses AccDefMM::setDocNo()
     * @uses AccDefMM::setCatCode1()
     * @uses AccDefMM::setCatCode2()
     * @uses AccDefMM::setNote1()
     * @uses AccDefMM::setDetails()
     * @param int $createUserId
     * @param int $coId
     * @param string|GekDateTime $docDate
     * @param int $catCode1Id
     * @param int $catCode2Id
     * @param int $sourceMId
     * @param string $accReceipt
     * @param int $accItemNo
     * @param string $coCode
     * @param string $docNo
     * @param string $catCode1
     * @param string $catCode2
     * @param string $note1
     * @param \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDefMM $details
     */
    public function __construct($createUserId = null, $coId = null, $docDate = null, $catCode1Id = null, $catCode2Id = null, $sourceMId = null, $accReceipt = null, $accItemNo = null, $coCode = null, $docNo = null, $catCode1 = null, $catCode2 = null, $note1 = null, \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDefMM $details = null)
    {
        $this
            ->setCreateUserId($createUserId)
            ->setCoId($coId)
            ->setDocDate($docDate)
            ->setCatCode1Id($catCode1Id)
            ->setCatCode2Id($catCode2Id)
            ->setSourceMId($sourceMId)
            ->setAccReceipt($accReceipt)
            ->setAccItemNo($accItemNo)
            ->setCoCode($coCode)
            ->setDocNo($docNo)
            ->setCatCode1($catCode1)
            ->setCatCode2($catCode2)
            ->setNote1($note1)
            ->setDetails($details);
    }
    /**
     * Get CreateUserId value
     * @return int
     */
    public function getCreateUserId()
    {
        return $this->CreateUserId;
    }
    /**
     * Set CreateUserId value
     * @param int $createUserId
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: int
        if (!is_null($createUserId) && !(is_int($createUserId) || ctype_digit($createUserId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        $this->CreateUserId = $createUserId;
        return $this;
    }
    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }
    /**
     * Set CoId value
     * @param int $coId
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string|GekDateTime $docDate
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate) && !($docDate instanceof GekDateTime) ) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docDate, true), gettype($docDate)), __LINE__);
        }
        if($docDate instanceof GekDateTime){
            $docDate = $docDate->toServiceString();
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get CatCode1Id value
     * @return int
     */
    public function getCatCode1Id()
    {
        return $this->CatCode1Id;
    }
    /**
     * Set CatCode1Id value
     * @param int $catCode1Id
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setCatCode1Id($catCode1Id = null)
    {
        // validation for constraint: int
        if (!is_null($catCode1Id) && !(is_int($catCode1Id) || ctype_digit($catCode1Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catCode1Id, true), gettype($catCode1Id)), __LINE__);
        }
        $this->CatCode1Id = $catCode1Id;
        return $this;
    }
    /**
     * Get CatCode2Id value
     * @return int
     */
    public function getCatCode2Id()
    {
        return $this->CatCode2Id;
    }
    /**
     * Set CatCode2Id value
     * @param int $catCode2Id
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setCatCode2Id($catCode2Id = null)
    {
        // validation for constraint: int
        if (!is_null($catCode2Id) && !(is_int($catCode2Id) || ctype_digit($catCode2Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catCode2Id, true), gettype($catCode2Id)), __LINE__);
        }
        $this->CatCode2Id = $catCode2Id;
        return $this;
    }
    /**
     * Get SourceMId value
     * @return int
     */
    public function getSourceMId()
    {
        return $this->SourceMId;
    }
    /**
     * Set SourceMId value
     * @param int $sourceMId
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setSourceMId($sourceMId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceMId) && !(is_int($sourceMId) || ctype_digit($sourceMId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceMId, true), gettype($sourceMId)), __LINE__);
        }
        $this->SourceMId = $sourceMId;
        return $this;
    }
    /**
     * Get AccReceipt value
     * @return string
     */
    public function getAccReceipt()
    {
        return $this->AccReceipt;
    }
    /**
     * Set AccReceipt value
     * @uses \Gek\UyumBahce\EnumType\AccReceipt::valueIsValid()
     * @uses \Gek\UyumBahce\EnumType\AccReceipt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accReceipt
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setAccReceipt($accReceipt = null)
    {
        // validation for constraint: enumeration
        if (!\Gek\UyumBahce\EnumType\AccReceipt::valueIsValid($accReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\AccReceipt', is_array($accReceipt) ? implode(', ', $accReceipt) : var_export($accReceipt, true), implode(', ', \Gek\UyumBahce\EnumType\AccReceipt::getValidValues())), __LINE__);
        }
        $this->AccReceipt = $accReceipt;
        return $this;
    }
    /**
     * Get AccItemNo value
     * @return int
     */
    public function getAccItemNo()
    {
        return $this->AccItemNo;
    }
    /**
     * Set AccItemNo value
     * @param int $accItemNo
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setAccItemNo($accItemNo = null)
    {
        // validation for constraint: int
        if (!is_null($accItemNo) && !(is_int($accItemNo) || ctype_digit($accItemNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accItemNo, true), gettype($accItemNo)), __LINE__);
        }
        $this->AccItemNo = $accItemNo;
        return $this;
    }
    /**
     * Get CoCode value
     * @return string|null
     */
    public function getCoCode()
    {
        return $this->CoCode;
    }
    /**
     * Set CoCode value
     * @param string $coCode
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setCoCode($coCode = null)
    {
        // validation for constraint: string
        if (!is_null($coCode) && !is_string($coCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coCode, true), gettype($coCode)), __LINE__);
        }
        $this->CoCode = $coCode;
        return $this;
    }
    /**
     * Get DocNo value
     * @return string|null
     */
    public function getDocNo()
    {
        return $this->DocNo;
    }
    /**
     * Set DocNo value
     * @param string $docNo
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setDocNo($docNo = null)
    {
        // validation for constraint: string
        if (!is_null($docNo) && !is_string($docNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNo, true), gettype($docNo)), __LINE__);
        }
        $this->DocNo = $docNo;
        return $this;
    }
    /**
     * Get CatCode1 value
     * @return string|null
     */
    public function getCatCode1()
    {
        return $this->CatCode1;
    }
    /**
     * Set CatCode1 value
     * @param string $catCode1
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setCatCode1($catCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($catCode1) && !is_string($catCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode1, true), gettype($catCode1)), __LINE__);
        }
        $this->CatCode1 = $catCode1;
        return $this;
    }
    /**
     * Get CatCode2 value
     * @return string|null
     */
    public function getCatCode2()
    {
        return $this->CatCode2;
    }
    /**
     * Set CatCode2 value
     * @param string $catCode2
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setCatCode2($catCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($catCode2) && !is_string($catCode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode2, true), gettype($catCode2)), __LINE__);
        }
        $this->CatCode2 = $catCode2;
        return $this;
    }
    /**
     * Get Note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->Note1;
    }
    /**
     * Set Note1 value
     * @param string $note1
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        $this->Note1 = $note1;
        return $this;
    }
    /**
     * Get Details value
     * @return \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDefMM|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDefMM $details
     * @return \Gek\UyumBahce\StructType\AccDefMM
     */
    public function setDetails(\Gek\UyumBahce\ArrayType\ArrayOfAccDetailDefMM $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
