<?php

namespace Gek\UyumBahce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccDef StructType
 * @subpackage Structs
 */
class AccDef extends MasterFields
{
    /**
     * The AccMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AccMId;
    /**
     * The AccReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AccReceipt;
    /**
     * The AmtCredit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtCredit;
    /**
     * The AmtDebit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmtDebit;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDef
     */
    public $Details;
    /**
     * Constructor method for AccDef
     * @uses AccDef::setAccMId()
     * @uses AccDef::setAccReceipt()
     * @uses AccDef::setAmtCredit()
     * @uses AccDef::setAmtDebit()
     * @uses AccDef::setDetails()
     * @param int $accMId
     * @param string $accReceipt
     * @param float $amtCredit
     * @param float $amtDebit
     * @param \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDef $details
     */
    public function __construct($accMId = null, $accReceipt = null, $amtCredit = null, $amtDebit = null, \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDef $details = null)
    {
        $this
            ->setAccMId($accMId)
            ->setAccReceipt($accReceipt)
            ->setAmtCredit($amtCredit)
            ->setAmtDebit($amtDebit)
            ->setDetails($details);
    }
    /**
     * Get AccMId value
     * @return int
     */
    public function getAccMId()
    {
        return $this->AccMId;
    }
    /**
     * Set AccMId value
     * @param int $accMId
     * @return \Gek\UyumBahce\StructType\AccDef
     */
    public function setAccMId($accMId = null)
    {
        // validation for constraint: int
        if (!is_null($accMId) && !(is_int($accMId) || ctype_digit($accMId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accMId, true), gettype($accMId)), __LINE__);
        }
        $this->AccMId = $accMId;
        return $this;
    }
    /**
     * Get AccReceipt value
     * @return string
     */
    public function getAccReceipt()
    {
        return $this->AccReceipt;
    }
    /**
     * Set AccReceipt value
     * @uses \Gek\UyumBahce\EnumType\AccReceipt::valueIsValid()
     * @uses \Gek\UyumBahce\EnumType\AccReceipt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accReceipt
     * @return \Gek\UyumBahce\StructType\AccDef
     */
    public function setAccReceipt($accReceipt = null)
    {
        // validation for constraint: enumeration
        if (!\Gek\UyumBahce\EnumType\AccReceipt::valueIsValid($accReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\AccReceipt', is_array($accReceipt) ? implode(', ', $accReceipt) : var_export($accReceipt, true), implode(', ', \Gek\UyumBahce\EnumType\AccReceipt::getValidValues())), __LINE__);
        }
        $this->AccReceipt = $accReceipt;
        return $this;
    }
    /**
     * Get AmtCredit value
     * @return float
     */
    public function getAmtCredit()
    {
        return $this->AmtCredit;
    }
    /**
     * Set AmtCredit value
     * @param float $amtCredit
     * @return \Gek\UyumBahce\StructType\AccDef
     */
    public function setAmtCredit($amtCredit = null)
    {
        // validation for constraint: float
        if (!is_null($amtCredit) && !(is_float($amtCredit) || is_numeric($amtCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtCredit, true), gettype($amtCredit)), __LINE__);
        }
        $this->AmtCredit = $amtCredit;
        return $this;
    }
    /**
     * Get AmtDebit value
     * @return float
     */
    public function getAmtDebit()
    {
        return $this->AmtDebit;
    }
    /**
     * Set AmtDebit value
     * @param float $amtDebit
     * @return \Gek\UyumBahce\StructType\AccDef
     */
    public function setAmtDebit($amtDebit = null)
    {
        // validation for constraint: float
        if (!is_null($amtDebit) && !(is_float($amtDebit) || is_numeric($amtDebit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amtDebit, true), gettype($amtDebit)), __LINE__);
        }
        $this->AmtDebit = $amtDebit;
        return $this;
    }
    /**
     * Get Details value
     * @return \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDef|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \Gek\UyumBahce\ArrayType\ArrayOfAccDetailDef $details
     * @return \Gek\UyumBahce\StructType\AccDef
     */
    public function setDetails(\Gek\UyumBahce\ArrayType\ArrayOfAccDetailDef $details = null)
    {
        $this->Details = $details;
        return $this;
    }
}
