<?php

namespace Gek\UyumBahce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendEInvoice
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen ETTN numarasına ait Fatura Kaydını Gib ortamına gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SendEInvoice $parameters
     * @return \Gek\UyumBahce\StructType\SendEInvoiceResponse|bool
     */
    public function SendEInvoice(\Gek\UyumBahce\StructType\SendEInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SendEInvoice', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendEDespatch
     * Meta information extracted from the WSDL
     * - documentation: Gönderilen ETTN numarasına ait İrsaliye Kaydını Gib ortamına gönderir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SendEDespatch $parameters
     * @return \Gek\UyumBahce\StructType\SendEDespatchResponse|bool
     */
    public function SendEDespatch(\Gek\UyumBahce\StructType\SendEDespatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SendEDespatch', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Gek\UyumBahce\StructType\SendEDespatchResponse|\Gek\UyumBahce\StructType\SendEInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
