<?php

namespace Gek\UyumBahce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveOrderM
     * Meta information extracted from the WSDL
     * - documentation: Sipariş Kaydı Oluşturur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveOrderM $parameters
     * @return \Gek\UyumBahce\StructType\SaveOrderMResponse|bool
     */
    public function SaveOrderM(\Gek\UyumBahce\StructType\SaveOrderM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveOrderM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveOrderMMulti
     * Meta information extracted from the WSDL
     * - documentation: Birden Fazla Sipariş Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveOrderMMulti $parameters
     * @return \Gek\UyumBahce\StructType\SaveOrderMMultiResponse|bool
     */
    public function SaveOrderMMulti(\Gek\UyumBahce\StructType\SaveOrderMMulti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveOrderMMulti', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveInvoice
     * Meta information extracted from the WSDL
     * - documentation: Fatura Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveInvoice $parameters
     * @return \Gek\UyumBahce\StructType\SaveInvoiceResponse|bool
     */
    public function SaveInvoice(\Gek\UyumBahce\StructType\SaveInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveInvoice', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveEInvoice
     * Meta information extracted from the WSDL
     * - documentation: E-Fatura Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveEInvoice $parameters
     * @return \Gek\UyumBahce\StructType\SaveEInvoiceResponse|bool
     */
    public function SaveEInvoice(\Gek\UyumBahce\StructType\SaveEInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveEInvoice', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveInvoiceMulti
     * Meta information extracted from the WSDL
     * - documentation: Birden Fazla Fatura Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveInvoiceMulti $parameters
     * @return \Gek\UyumBahce\StructType\SaveInvoiceMultiResponse|bool
     */
    public function SaveInvoiceMulti(\Gek\UyumBahce\StructType\SaveInvoiceMulti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveInvoiceMulti', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveOffer
     * Meta information extracted from the WSDL
     * - documentation: Teklif Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveOffer $parameters
     * @return \Gek\UyumBahce\StructType\SaveOfferResponse|bool
     */
    public function SaveOffer(\Gek\UyumBahce\StructType\SaveOffer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveOffer', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveRequest
     * Meta information extracted from the WSDL
     * - documentation: Talep Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveRequest $parameters
     * @return \Gek\UyumBahce\StructType\SaveRequestResponse|bool
     */
    public function SaveRequest(\Gek\UyumBahce\StructType\SaveRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveRequest', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveFinance
     * Meta information extracted from the WSDL
     * - documentation: Finans Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveFinance $parameters
     * @return \Gek\UyumBahce\StructType\SaveFinanceResponse|bool
     */
    public function SaveFinance(\Gek\UyumBahce\StructType\SaveFinance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveFinance', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveFinanceMulti
     * Meta information extracted from the WSDL
     * - documentation: Birden Fazla Finans Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveFinanceMulti $parameters
     * @return \Gek\UyumBahce\StructType\SaveFinanceMultiResponse|bool
     */
    public function SaveFinanceMulti(\Gek\UyumBahce\StructType\SaveFinanceMulti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveFinanceMulti', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAcc
     * Meta information extracted from the WSDL
     * - documentation: Muhasebe Fişi Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveAcc $parameters
     * @return \Gek\UyumBahce\StructType\SaveAccResponse|bool
     */
    public function SaveAcc(\Gek\UyumBahce\StructType\SaveAcc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveAcc', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAccMM
     * Meta information extracted from the WSDL
     * - documentation: Mali Müşavir Muhasebe Fişi Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveAccMM $parameters
     * @return \Gek\UyumBahce\StructType\SaveAccMMResponse|bool
     */
    public function SaveAccMM(\Gek\UyumBahce\StructType\SaveAccMM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveAccMM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAccMulti
     * Meta information extracted from the WSDL
     * - documentation: Birden Fazla Muhasebe Fişi Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveAccMulti $parameters
     * @return \Gek\UyumBahce\StructType\SaveAccMultiResponse|bool
     */
    public function SaveAccMulti(\Gek\UyumBahce\StructType\SaveAccMulti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveAccMulti', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveBankAccType
     * Meta information extracted from the WSDL
     * - documentation: Hesap Plan Tipi Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveBankAccType $parameters
     * @return \Gek\UyumBahce\StructType\SaveBankAccTypeResponse|bool
     */
    public function SaveBankAccType(\Gek\UyumBahce\StructType\SaveBankAccType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveBankAccType', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveBankAcc
     * Meta information extracted from the WSDL
     * - documentation: Banka Hesap Planı Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveBankAcc $parameters
     * @return \Gek\UyumBahce\StructType\SaveBankAccResponse|bool
     */
    public function SaveBankAcc(\Gek\UyumBahce\StructType\SaveBankAcc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveBankAcc', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAcccountMM
     * Meta information extracted from the WSDL
     * - documentation: Hesap planı kaydı oluşurulur.Gerekli bilgiler gönderilirse cari kaydıda oluşturulur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveAcccountMM $parameters
     * @return \Gek\UyumBahce\StructType\SaveAcccountMMResponse|bool
     */
    public function SaveAcccountMM(\Gek\UyumBahce\StructType\SaveAcccountMM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveAcccountMM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveEntityMM
     * Meta information extracted from the WSDL
     * - documentation: Cari kaydı oluşturulur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveEntityMM $parameters
     * @return \Gek\UyumBahce\StructType\SaveEntityMMResponse|bool
     */
    public function SaveEntityMM(\Gek\UyumBahce\StructType\SaveEntityMM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveEntityMM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAccGainlossM
     * Meta information extracted from the WSDL
     * - documentation: Mali Müşavir Gelir Gider Fişi Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveAccGainlossM $parameters
     * @return \Gek\UyumBahce\StructType\SaveAccGainlossMResponse|bool
     */
    public function SaveAccGainlossM(\Gek\UyumBahce\StructType\SaveAccGainlossM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveAccGainlossM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveEntity
     * Meta information extracted from the WSDL
     * - documentation: Cari Kart ve Firma Cari Kart Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveEntity $parameters
     * @return \Gek\UyumBahce\StructType\SaveEntityResponse|bool
     */
    public function SaveEntity(\Gek\UyumBahce\StructType\SaveEntity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveEntity', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveItemM
     * Meta information extracted from the WSDL
     * - documentation: Stok Hareket Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveItemM $parameters
     * @return \Gek\UyumBahce\StructType\SaveItemMResponse|bool
     */
    public function SaveItemM(\Gek\UyumBahce\StructType\SaveItemM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveItemM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveItemMMulti
     * Meta information extracted from the WSDL
     * - documentation: Birden Fazla Stok Hareket Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveItemMMulti $parameters
     * @return \Gek\UyumBahce\StructType\SaveItemMMultiResponse|bool
     */
    public function SaveItemMMulti(\Gek\UyumBahce\StructType\SaveItemMMulti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveItemMMulti', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveWaybill
     * Meta information extracted from the WSDL
     * - documentation: İrsaliye Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveWaybill $parameters
     * @return \Gek\UyumBahce\StructType\SaveWaybillResponse|bool
     */
    public function SaveWaybill(\Gek\UyumBahce\StructType\SaveWaybill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveWaybill', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveWaybillByReferral
     * Meta information extracted from the WSDL
     * - documentation: Sevk emri üzerinden irsaliye kaydı oluşturur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveWaybillByReferral $parameters
     * @return \Gek\UyumBahce\StructType\SaveWaybillByReferralResponse|bool
     */
    public function SaveWaybillByReferral(\Gek\UyumBahce\StructType\SaveWaybillByReferral $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveWaybillByReferral', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveWaybillMulti
     * Meta information extracted from the WSDL
     * - documentation: Birden Fazla İrsaliye Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveWaybillMulti $parameters
     * @return \Gek\UyumBahce\StructType\SaveWaybillMultiResponse|bool
     */
    public function SaveWaybillMulti(\Gek\UyumBahce\StructType\SaveWaybillMulti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveWaybillMulti', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveItem
     * Meta information extracted from the WSDL
     * - documentation: Stok Kartı Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveItem $parameters
     * @return \Gek\UyumBahce\StructType\SaveItemResponse|bool
     */
    public function SaveItem(\Gek\UyumBahce\StructType\SaveItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveItem', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveExpense
     * Meta information extracted from the WSDL
     * - documentation: Hizmet Kartı Kaydı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveExpense $parameters
     * @return \Gek\UyumBahce\StructType\SaveExpenseResponse|bool
     */
    public function SaveExpense(\Gek\UyumBahce\StructType\SaveExpense $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveExpense', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveItemBarcode
     * Meta information extracted from the WSDL
     * - documentation: Stok Kartı Barkod Tanımı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveItemBarcode $parameters
     * @return \Gek\UyumBahce\StructType\SaveItemBarcodeResponse|bool
     */
    public function SaveItemBarcode(\Gek\UyumBahce\StructType\SaveItemBarcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveItemBarcode', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveCrmPriceList
     * Meta information extracted from the WSDL
     * - documentation: Crm Fiyat Listesi Tanımı Oluşturulur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveCrmPriceList $parameters
     * @return \Gek\UyumBahce\StructType\SaveCrmPriceListResponse|bool
     */
    public function SaveCrmPriceList(\Gek\UyumBahce\StructType\SaveCrmPriceList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveCrmPriceList', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SavePrdWorderAcOp
     * Meta information extracted from the WSDL
     * - documentation: Üretim Kaydı Oluşturulur.[Üretim Yönetimi]
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SavePrdWorderAcOp $parameters
     * @return \Gek\UyumBahce\StructType\SavePrdWorderAcOpResponse|bool
     */
    public function SavePrdWorderAcOp(\Gek\UyumBahce\StructType\SavePrdWorderAcOp $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SavePrdWorderAcOp', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SavePrdWorderM
     * Meta information extracted from the WSDL
     * - documentation: İş Emri Oluşturulur.[Üretim Yönetimi]
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SavePrdWorderM $parameters
     * @return \Gek\UyumBahce\StructType\SavePrdWorderMResponse|bool
     */
    public function SavePrdWorderM(\Gek\UyumBahce\StructType\SavePrdWorderM $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SavePrdWorderM', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUyumObjectFromXML
     * Meta information extracted from the WSDL
     * - documentation: Tipi belirtilen object nin kaydının oluşturulması.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\SaveUyumObjectFromXML $parameters
     * @return \Gek\UyumBahce\StructType\SaveUyumObjectFromXMLResponse|bool
     */
    public function SaveUyumObjectFromXML(\Gek\UyumBahce\StructType\SaveUyumObjectFromXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('SaveUyumObjectFromXML', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Gek\UyumBahce\StructType\SaveAcccountMMResponse|\Gek\UyumBahce\StructType\SaveAccGainlossMResponse|\Gek\UyumBahce\StructType\SaveAccMMResponse|\Gek\UyumBahce\StructType\SaveAccMultiResponse|\Gek\UyumBahce\StructType\SaveAccResponse|\Gek\UyumBahce\StructType\SaveBankAccResponse|\Gek\UyumBahce\StructType\SaveBankAccTypeResponse|\Gek\UyumBahce\StructType\SaveCrmPriceListResponse|\Gek\UyumBahce\StructType\SaveEInvoiceResponse|\Gek\UyumBahce\StructType\SaveEntityMMResponse|\Gek\UyumBahce\StructType\SaveEntityResponse|\Gek\UyumBahce\StructType\SaveExpenseResponse|\Gek\UyumBahce\StructType\SaveFinanceMultiResponse|\Gek\UyumBahce\StructType\SaveFinanceResponse|\Gek\UyumBahce\StructType\SaveInvoiceMultiResponse|\Gek\UyumBahce\StructType\SaveInvoiceResponse|\Gek\UyumBahce\StructType\SaveItemBarcodeResponse|\Gek\UyumBahce\StructType\SaveItemMMultiResponse|\Gek\UyumBahce\StructType\SaveItemMResponse|\Gek\UyumBahce\StructType\SaveItemResponse|\Gek\UyumBahce\StructType\SaveOfferResponse|\Gek\UyumBahce\StructType\SaveOrderMMultiResponse|\Gek\UyumBahce\StructType\SaveOrderMResponse|\Gek\UyumBahce\StructType\SavePrdWorderAcOpResponse|\Gek\UyumBahce\StructType\SavePrdWorderMResponse|\Gek\UyumBahce\StructType\SaveRequestResponse|\Gek\UyumBahce\StructType\SaveUyumObjectFromXMLResponse|\Gek\UyumBahce\StructType\SaveWaybillByReferralResponse|\Gek\UyumBahce\StructType\SaveWaybillMultiResponse|\Gek\UyumBahce\StructType\SaveWaybillResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
