<?php

namespace Gek\UyumBahce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteInvoice
     * Meta information extracted from the WSDL
     * - documentation: Fatura Kaydı Siler.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\DeleteInvoice $parameters
     * @return \Gek\UyumBahce\StructType\DeleteInvoiceResponse|bool
     */
    public function DeleteInvoice(\Gek\UyumBahce\StructType\DeleteInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteInvoice', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteFinance
     * Meta information extracted from the WSDL
     * - documentation: Finans Kaydı Siler.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\DeleteFinance $parameters
     * @return \Gek\UyumBahce\StructType\DeleteFinanceResponse|bool
     */
    public function DeleteFinance(\Gek\UyumBahce\StructType\DeleteFinance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteFinance', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteWaybill
     * Meta information extracted from the WSDL
     * - documentation: İrsaliye Kaydı Siler.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\DeleteWaybill $parameters
     * @return \Gek\UyumBahce\StructType\DeleteWaybillResponse|bool
     */
    public function DeleteWaybill(\Gek\UyumBahce\StructType\DeleteWaybill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteWaybill', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteUyumObjectFromXML
     * Meta information extracted from the WSDL
     * - documentation: Tipi belirtilen object nin kaydının silinmesi.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Gek\UyumBahce\StructType\DeleteUyumObjectFromXML $parameters
     * @return \Gek\UyumBahce\StructType\DeleteUyumObjectFromXMLResponse|bool
     */
    public function DeleteUyumObjectFromXML(\Gek\UyumBahce\StructType\DeleteUyumObjectFromXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('DeleteUyumObjectFromXML', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Gek\UyumBahce\StructType\DeleteFinanceResponse|\Gek\UyumBahce\StructType\DeleteInvoiceResponse|\Gek\UyumBahce\StructType\DeleteUyumObjectFromXMLResponse|\Gek\UyumBahce\StructType\DeleteWaybillResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
