<?php

namespace Gek\UyumBahce\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransformType ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransformType extends AbstractStructArrayBase
{
    /**
     * The Transform
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Gek\UyumBahce\StructType\TransformType[]
     */
    public $Transform;
    /**
     * Constructor method for ArrayOfTransformType
     * @uses ArrayOfTransformType::setTransform()
     * @param \Gek\UyumBahce\StructType\TransformType[] $transform
     */
    public function __construct(array $transform = array())
    {
        $this
            ->setTransform($transform);
    }
    /**
     * Get Transform value
     * @return \Gek\UyumBahce\StructType\TransformType[]|null
     */
    public function getTransform()
    {
        return $this->Transform;
    }
    /**
     * This method is responsible for validating the values passed to the setTransform method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransform method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransformForArrayConstraintsFromSetTransform(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTransformTypeTransformItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransformTypeTransformItem instanceof \Gek\UyumBahce\StructType\TransformType) {
                $invalidValues[] = is_object($arrayOfTransformTypeTransformItem) ? get_class($arrayOfTransformTypeTransformItem) : sprintf('%s(%s)', gettype($arrayOfTransformTypeTransformItem), var_export($arrayOfTransformTypeTransformItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transform property can only contain items of type \Gek\UyumBahce\StructType\TransformType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transform value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransformType[] $transform
     * @return \Gek\UyumBahce\ArrayType\ArrayOfTransformType
     */
    public function setTransform(array $transform = array())
    {
        // validation for constraint: array
        if ('' !== ($transformArrayErrorMessage = self::validateTransformForArrayConstraintsFromSetTransform($transform))) {
            throw new \InvalidArgumentException($transformArrayErrorMessage, __LINE__);
        }
        $this->Transform = $transform;
        return $this;
    }
    /**
     * Add item to Transform value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\TransformType $item
     * @return \Gek\UyumBahce\ArrayType\ArrayOfTransformType
     */
    public function addToTransform(\Gek\UyumBahce\StructType\TransformType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\TransformType) {
            throw new \InvalidArgumentException(sprintf('The Transform property can only contain items of type \Gek\UyumBahce\StructType\TransformType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transform[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Gek\UyumBahce\StructType\TransformType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Gek\UyumBahce\StructType\TransformType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Gek\UyumBahce\StructType\TransformType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Gek\UyumBahce\StructType\TransformType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Gek\UyumBahce\StructType\TransformType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Transform
     */
    public function getAttributeName()
    {
        return 'Transform';
    }
}
