<?php

namespace Gek\UyumBahce\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEntityContact ArrayType
 * @subpackage Arrays
 */
class ArrayOfEntityContact extends AbstractStructArrayBase
{
    /**
     * The EntityContact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Gek\UyumBahce\StructType\EntityContact[]
     */
    public $EntityContact;
    /**
     * Constructor method for ArrayOfEntityContact
     * @uses ArrayOfEntityContact::setEntityContact()
     * @param \Gek\UyumBahce\StructType\EntityContact[] $entityContact
     */
    public function __construct(array $entityContact = array())
    {
        $this
            ->setEntityContact($entityContact);
    }
    /**
     * Get EntityContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Gek\UyumBahce\StructType\EntityContact[]|null
     */
    public function getEntityContact()
    {
        return isset($this->EntityContact) ? $this->EntityContact : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEntityContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEntityContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEntityContactForArrayConstraintsFromSetEntityContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEntityContactEntityContactItem) {
            // validation for constraint: itemType
            if (!$arrayOfEntityContactEntityContactItem instanceof \Gek\UyumBahce\StructType\EntityContact) {
                $invalidValues[] = is_object($arrayOfEntityContactEntityContactItem) ? get_class($arrayOfEntityContactEntityContactItem) : sprintf('%s(%s)', gettype($arrayOfEntityContactEntityContactItem), var_export($arrayOfEntityContactEntityContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EntityContact property can only contain items of type \Gek\UyumBahce\StructType\EntityContact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EntityContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\EntityContact[] $entityContact
     * @return \Gek\UyumBahce\ArrayType\ArrayOfEntityContact
     */
    public function setEntityContact(array $entityContact = array())
    {
        // validation for constraint: array
        if ('' !== ($entityContactArrayErrorMessage = self::validateEntityContactForArrayConstraintsFromSetEntityContact($entityContact))) {
            throw new \InvalidArgumentException($entityContactArrayErrorMessage, __LINE__);
        }
        if (is_null($entityContact) || (is_array($entityContact) && empty($entityContact))) {
            unset($this->EntityContact);
        } else {
            $this->EntityContact = $entityContact;
        }
        return $this;
    }
    /**
     * Add item to EntityContact value
     * @throws \InvalidArgumentException
     * @param \Gek\UyumBahce\StructType\EntityContact $item
     * @return \Gek\UyumBahce\ArrayType\ArrayOfEntityContact
     */
    public function addToEntityContact(\Gek\UyumBahce\StructType\EntityContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Gek\UyumBahce\StructType\EntityContact) {
            throw new \InvalidArgumentException(sprintf('The EntityContact property can only contain items of type \Gek\UyumBahce\StructType\EntityContact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EntityContact[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Gek\UyumBahce\StructType\EntityContact|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Gek\UyumBahce\StructType\EntityContact|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Gek\UyumBahce\StructType\EntityContact|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Gek\UyumBahce\StructType\EntityContact|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Gek\UyumBahce\StructType\EntityContact|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EntityContact
     */
    public function getAttributeName()
    {
        return 'EntityContact';
    }
}
