<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrdWorderDef StructType
 * @subpackage Structs
 */
class PrdWorderDef extends AbstractStructBase
{
    /**
     * The WorderMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WorderMId;
    /**
     * The WorderOpDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WorderOpDId;
    /**
     * The WstationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WstationId;
    /**
     * The UnitId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitId;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Qty;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The PrdEmployeeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PrdEmployeeId;
    /**
     * The ScrapReasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ScrapReasonId;
    /**
     * The ScrapQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ScrapQty;
    /**
     * The SourceMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceMId;
    /**
     * The SourceDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceDId;
    /**
     * The SourceM2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceM2Id;
    /**
     * The SourceD2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceD2Id;

    /**
     * Constructor method for PrdWorderDef
     * @param int $worderMId
     * @param int $worderOpDId
     * @param int $wstationId
     * @param int $unitId
     * @param float $qty
     * @param string|GekDateTime $startDate
     * @param string|GekDateTime $endDate
     * @param int $prdEmployeeId
     * @param int $scrapReasonId
     * @param float $scrapQty
     * @param int $sourceMId
     * @param int $sourceDId
     * @param int $sourceM2Id
     * @param int $sourceD2Id
     * @uses PrdWorderDef::setWorderMId()
     * @uses PrdWorderDef::setWorderOpDId()
     * @uses PrdWorderDef::setWstationId()
     * @uses PrdWorderDef::setUnitId()
     * @uses PrdWorderDef::setQty()
     * @uses PrdWorderDef::setStartDate()
     * @uses PrdWorderDef::setEndDate()
     * @uses PrdWorderDef::setPrdEmployeeId()
     * @uses PrdWorderDef::setScrapReasonId()
     * @uses PrdWorderDef::setScrapQty()
     * @uses PrdWorderDef::setSourceMId()
     * @uses PrdWorderDef::setSourceDId()
     * @uses PrdWorderDef::setSourceM2Id()
     * @uses PrdWorderDef::setSourceD2Id()
     */
    public function __construct($worderMId = null, $worderOpDId = null, $wstationId = null, $unitId = null, $qty = null, $startDate = null, $endDate = null, $prdEmployeeId = null, $scrapReasonId = null, $scrapQty = null, $sourceMId = null, $sourceDId = null, $sourceM2Id = null, $sourceD2Id = null)
    {
        $this
            ->setWorderMId($worderMId)
            ->setWorderOpDId($worderOpDId)
            ->setWstationId($wstationId)
            ->setUnitId($unitId)
            ->setQty($qty)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setPrdEmployeeId($prdEmployeeId)
            ->setScrapReasonId($scrapReasonId)
            ->setScrapQty($scrapQty)
            ->setSourceMId($sourceMId)
            ->setSourceDId($sourceDId)
            ->setSourceM2Id($sourceM2Id)
            ->setSourceD2Id($sourceD2Id);
    }

    /**
     * Get WorderMId value
     * @return int
     */
    public function getWorderMId()
    {
        return $this->WorderMId;
    }

    /**
     * Set WorderMId value
     * @param int $worderMId
     * @return PrdWorderDef
     */
    public function setWorderMId($worderMId = null)
    {
        // validation for constraint: int
        if (!is_null($worderMId) && !(is_int($worderMId) || ctype_digit($worderMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($worderMId, true), gettype($worderMId)), __LINE__);
        }
        $this->WorderMId = $worderMId;
        return $this;
    }

    /**
     * Get WorderOpDId value
     * @return int
     */
    public function getWorderOpDId()
    {
        return $this->WorderOpDId;
    }

    /**
     * Set WorderOpDId value
     * @param int $worderOpDId
     * @return PrdWorderDef
     */
    public function setWorderOpDId($worderOpDId = null)
    {
        // validation for constraint: int
        if (!is_null($worderOpDId) && !(is_int($worderOpDId) || ctype_digit($worderOpDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($worderOpDId, true), gettype($worderOpDId)), __LINE__);
        }
        $this->WorderOpDId = $worderOpDId;
        return $this;
    }

    /**
     * Get WstationId value
     * @return int
     */
    public function getWstationId()
    {
        return $this->WstationId;
    }

    /**
     * Set WstationId value
     * @param int $wstationId
     * @return PrdWorderDef
     */
    public function setWstationId($wstationId = null)
    {
        // validation for constraint: int
        if (!is_null($wstationId) && !(is_int($wstationId) || ctype_digit($wstationId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wstationId, true), gettype($wstationId)), __LINE__);
        }
        $this->WstationId = $wstationId;
        return $this;
    }

    /**
     * Get UnitId value
     * @return int
     */
    public function getUnitId()
    {
        return $this->UnitId;
    }

    /**
     * Set UnitId value
     * @param int $unitId
     * @return PrdWorderDef
     */
    public function setUnitId($unitId = null)
    {
        // validation for constraint: int
        if (!is_null($unitId) && !(is_int($unitId) || ctype_digit($unitId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitId, true), gettype($unitId)), __LINE__);
        }
        $this->UnitId = $unitId;
        return $this;
    }

    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }

    /**
     * Set Qty value
     * @param float $qty
     * @return PrdWorderDef
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }

    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * Set StartDate value
     * @param string|GekDateTime $startDate
     * @return PrdWorderDef
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate) && !($startDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if ($startDate instanceof GekDateTime) {
            $startDate = $startDate->toServiceString();
        }
        $this->StartDate = $startDate;
        return $this;
    }

    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }

    /**
     * Set EndDate value
     * @param string|GekDateTime $endDate
     * @return PrdWorderDef
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate) && !($endDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if ($endDate instanceof GekDateTime) {
            $endDate = $endDate->toServiceString();
        }
        $this->EndDate = $endDate;
        return $this;
    }

    /**
     * Get PrdEmployeeId value
     * @return int
     */
    public function getPrdEmployeeId()
    {
        return $this->PrdEmployeeId;
    }

    /**
     * Set PrdEmployeeId value
     * @param int $prdEmployeeId
     * @return PrdWorderDef
     */
    public function setPrdEmployeeId($prdEmployeeId = null)
    {
        // validation for constraint: int
        if (!is_null($prdEmployeeId) && !(is_int($prdEmployeeId) || ctype_digit($prdEmployeeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prdEmployeeId, true), gettype($prdEmployeeId)), __LINE__);
        }
        $this->PrdEmployeeId = $prdEmployeeId;
        return $this;
    }

    /**
     * Get ScrapReasonId value
     * @return int
     */
    public function getScrapReasonId()
    {
        return $this->ScrapReasonId;
    }

    /**
     * Set ScrapReasonId value
     * @param int $scrapReasonId
     * @return PrdWorderDef
     */
    public function setScrapReasonId($scrapReasonId = null)
    {
        // validation for constraint: int
        if (!is_null($scrapReasonId) && !(is_int($scrapReasonId) || ctype_digit($scrapReasonId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scrapReasonId, true), gettype($scrapReasonId)), __LINE__);
        }
        $this->ScrapReasonId = $scrapReasonId;
        return $this;
    }

    /**
     * Get ScrapQty value
     * @return float
     */
    public function getScrapQty()
    {
        return $this->ScrapQty;
    }

    /**
     * Set ScrapQty value
     * @param float $scrapQty
     * @return PrdWorderDef
     */
    public function setScrapQty($scrapQty = null)
    {
        // validation for constraint: float
        if (!is_null($scrapQty) && !(is_float($scrapQty) || is_numeric($scrapQty))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scrapQty, true), gettype($scrapQty)), __LINE__);
        }
        $this->ScrapQty = $scrapQty;
        return $this;
    }

    /**
     * Get SourceMId value
     * @return int
     */
    public function getSourceMId()
    {
        return $this->SourceMId;
    }

    /**
     * Set SourceMId value
     * @param int $sourceMId
     * @return PrdWorderDef
     */
    public function setSourceMId($sourceMId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceMId) && !(is_int($sourceMId) || ctype_digit($sourceMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceMId, true), gettype($sourceMId)), __LINE__);
        }
        $this->SourceMId = $sourceMId;
        return $this;
    }

    /**
     * Get SourceDId value
     * @return int
     */
    public function getSourceDId()
    {
        return $this->SourceDId;
    }

    /**
     * Set SourceDId value
     * @param int $sourceDId
     * @return PrdWorderDef
     */
    public function setSourceDId($sourceDId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceDId) && !(is_int($sourceDId) || ctype_digit($sourceDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceDId, true), gettype($sourceDId)), __LINE__);
        }
        $this->SourceDId = $sourceDId;
        return $this;
    }

    /**
     * Get SourceM2Id value
     * @return int
     */
    public function getSourceM2Id()
    {
        return $this->SourceM2Id;
    }

    /**
     * Set SourceM2Id value
     * @param int $sourceM2Id
     * @return PrdWorderDef
     */
    public function setSourceM2Id($sourceM2Id = null)
    {
        // validation for constraint: int
        if (!is_null($sourceM2Id) && !(is_int($sourceM2Id) || ctype_digit($sourceM2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceM2Id, true), gettype($sourceM2Id)), __LINE__);
        }
        $this->SourceM2Id = $sourceM2Id;
        return $this;
    }

    /**
     * Get SourceD2Id value
     * @return int
     */
    public function getSourceD2Id()
    {
        return $this->SourceD2Id;
    }

    /**
     * Set SourceD2Id value
     * @param int $sourceD2Id
     * @return PrdWorderDef
     */
    public function setSourceD2Id($sourceD2Id = null)
    {
        // validation for constraint: int
        if (!is_null($sourceD2Id) && !(is_int($sourceD2Id) || ctype_digit($sourceD2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceD2Id, true), gettype($sourceD2Id)), __LINE__);
        }
        $this->SourceD2Id = $sourceD2Id;
        return $this;
    }
}
