<?php

namespace Gek\UyumBahce\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderLineReferenceType StructType
 * @subpackage Structs
 */
class OrderLineReferenceType extends AbstractStructBase
{
    /**
     * The LineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineID
     * @var LineIDType
     */
    public $LineID;
    /**
     * The SalesOrderLineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:SalesOrderLineID
     * @var SalesOrderLineIDType
     */
    public $SalesOrderLineID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:UUID
     * @var UUIDType
     */
    public $UUID;
    /**
     * The LineStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineStatusCode
     * @var LineStatusCodeType
     */
    public $LineStatusCode;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var OrderReferenceType
     */
    public $OrderReference;

    /**
     * Constructor method for OrderLineReferenceType
     * @param LineIDType $lineID
     * @param SalesOrderLineIDType $salesOrderLineID
     * @param UUIDType $uUID
     * @param LineStatusCodeType $lineStatusCode
     * @param OrderReferenceType $orderReference
     * @uses OrderLineReferenceType::setLineID()
     * @uses OrderLineReferenceType::setSalesOrderLineID()
     * @uses OrderLineReferenceType::setUUID()
     * @uses OrderLineReferenceType::setLineStatusCode()
     * @uses OrderLineReferenceType::setOrderReference()
     */
    public function __construct(LineIDType $lineID = null, SalesOrderLineIDType $salesOrderLineID = null, UUIDType $uUID = null, LineStatusCodeType $lineStatusCode = null, OrderReferenceType $orderReference = null)
    {
        $this
            ->setLineID($lineID)
            ->setSalesOrderLineID($salesOrderLineID)
            ->setUUID($uUID)
            ->setLineStatusCode($lineStatusCode)
            ->setOrderReference($orderReference);
    }

    /**
     * Get LineID value
     * @return LineIDType|null
     */
    public function getLineID()
    {
        return $this->LineID;
    }

    /**
     * Set LineID value
     * @param LineIDType $lineID
     * @return OrderLineReferenceType
     */
    public function setLineID(LineIDType $lineID = null)
    {
        $this->LineID = $lineID;
        return $this;
    }

    /**
     * Get SalesOrderLineID value
     * @return SalesOrderLineIDType|null
     */
    public function getSalesOrderLineID()
    {
        return $this->SalesOrderLineID;
    }

    /**
     * Set SalesOrderLineID value
     * @param SalesOrderLineIDType $salesOrderLineID
     * @return OrderLineReferenceType
     */
    public function setSalesOrderLineID(SalesOrderLineIDType $salesOrderLineID = null)
    {
        $this->SalesOrderLineID = $salesOrderLineID;
        return $this;
    }

    /**
     * Get UUID value
     * @return UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }

    /**
     * Set UUID value
     * @param UUIDType $uUID
     * @return OrderLineReferenceType
     */
    public function setUUID(UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }

    /**
     * Get LineStatusCode value
     * @return LineStatusCodeType|null
     */
    public function getLineStatusCode()
    {
        return $this->LineStatusCode;
    }

    /**
     * Set LineStatusCode value
     * @param LineStatusCodeType $lineStatusCode
     * @return OrderLineReferenceType
     */
    public function setLineStatusCode(LineStatusCodeType $lineStatusCode = null)
    {
        $this->LineStatusCode = $lineStatusCode;
        return $this;
    }

    /**
     * Get OrderReference value
     * @return OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }

    /**
     * Set OrderReference value
     * @param OrderReferenceType $orderReference
     * @return OrderLineReferenceType
     */
    public function setOrderReference(OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }
}
