<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\EnumType\CurrencyOption;
use Gek\UyumBahce\EnumType\SourceApplication;
use Gek\UyumBahce\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MasterFields StructType
 * @subpackage Structs
 */
class MasterFields extends AbstractStructBase
{
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CoId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * The DocDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumberDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DocNumberDId;
    /**
     * The CatCode1Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CatCode1Id;
    /**
     * The CatCode2Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CatCode2Id;
    /**
     * The SourceApp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SourceApp;
    /**
     * The SourceApp2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SourceApp2;
    /**
     * The SourceApp3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SourceApp3;
    /**
     * The SourceMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SourceMId;
    /**
     * The SourceDId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SourceDId;
    /**
     * The CreateUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CreateUserId;
    /**
     * The CurrencyOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CurrencyOption;
    /**
     * The EntityOrderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EntityOrderDate;
    /**
     * The CoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoCode;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCode;
    /**
     * The DocNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocNo;
    /**
     * The CatCode1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CatCode1;
    /**
     * The CatCode2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CatCode2;
    /**
     * The Controller
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocController
     */
    public $Controller;
    /**
     * The Note1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note1;
    /**
     * The Note2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note2;
    /**
     * The Note3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note3;
    /**
     * The EntityOrderNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityOrderNo;

    /**
     * Constructor method for MasterFields
     * @param int $coId
     * @param int $branchId
     * @param string|GekDateTime $docDate
     * @param int $docNumberDId
     * @param int $catCode1Id
     * @param int $catCode2Id
     * @param string $sourceApp
     * @param string $sourceApp2
     * @param string $sourceApp3
     * @param int $sourceMId
     * @param int $sourceDId
     * @param int $createUserId
     * @param string $currencyOption
     * @param string|GekDateTime $entityOrderDate
     * @param string $coCode
     * @param string $branchCode
     * @param string $docNo
     * @param string $catCode1
     * @param string $catCode2
     * @param DocController $controller
     * @param string $note1
     * @param string $note2
     * @param string $note3
     * @param string $entityOrderNo
     * @uses MasterFields::setCoId()
     * @uses MasterFields::setBranchId()
     * @uses MasterFields::setDocDate()
     * @uses MasterFields::setDocNumberDId()
     * @uses MasterFields::setCatCode1Id()
     * @uses MasterFields::setCatCode2Id()
     * @uses MasterFields::setSourceApp()
     * @uses MasterFields::setSourceApp2()
     * @uses MasterFields::setSourceApp3()
     * @uses MasterFields::setSourceMId()
     * @uses MasterFields::setSourceDId()
     * @uses MasterFields::setCreateUserId()
     * @uses MasterFields::setCurrencyOption()
     * @uses MasterFields::setEntityOrderDate()
     * @uses MasterFields::setCoCode()
     * @uses MasterFields::setBranchCode()
     * @uses MasterFields::setDocNo()
     * @uses MasterFields::setCatCode1()
     * @uses MasterFields::setCatCode2()
     * @uses MasterFields::setController()
     * @uses MasterFields::setNote1()
     * @uses MasterFields::setNote2()
     * @uses MasterFields::setNote3()
     * @uses MasterFields::setEntityOrderNo()
     */
    public function __construct($coId = null, $branchId = null, $docDate = null, $docNumberDId = null, $catCode1Id = null, $catCode2Id = null, $sourceApp = null, $sourceApp2 = null, $sourceApp3 = null, $sourceMId = null, $sourceDId = null, $createUserId = null, $currencyOption = null, $entityOrderDate = null, $coCode = null, $branchCode = null, $docNo = null, $catCode1 = null, $catCode2 = null, DocController $controller = null, $note1 = null, $note2 = null, $note3 = null, $entityOrderNo = null)
    {
        $this
            ->setCoId($coId)
            ->setBranchId($branchId)
            ->setDocDate($docDate)
            ->setDocNumberDId($docNumberDId)
            ->setCatCode1Id($catCode1Id)
            ->setCatCode2Id($catCode2Id)
            ->setSourceApp($sourceApp)
            ->setSourceApp2($sourceApp2)
            ->setSourceApp3($sourceApp3)
            ->setSourceMId($sourceMId)
            ->setSourceDId($sourceDId)
            ->setCreateUserId($createUserId)
            ->setCurrencyOption($currencyOption)
            ->setEntityOrderDate($entityOrderDate)
            ->setCoCode($coCode)
            ->setBranchCode($branchCode)
            ->setDocNo($docNo)
            ->setCatCode1($catCode1)
            ->setCatCode2($catCode2)
            ->setController($controller)
            ->setNote1($note1)
            ->setNote2($note2)
            ->setNote3($note3)
            ->setEntityOrderNo($entityOrderNo);
    }

    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }

    /**
     * Set CoId value
     * @param int $coId
     * @return MasterFields
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }

    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }

    /**
     * Set BranchId value
     * @param int $branchId
     * @return MasterFields
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }

    /**
     * Get DocDate value
     * @return string
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }

    /**
     * Set DocDate value
     * @param string|GekDateTime $docDate
     * @return MasterFields
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate) && !($docDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docDate, true), gettype($docDate)), __LINE__);
        }
        if ($docDate instanceof GekDateTime) {
            $docDate = $docDate->toServiceString();
        }
        $this->DocDate = $docDate;
        return $this;
    }

    /**
     * Get DocNumberDId value
     * @return int
     */
    public function getDocNumberDId()
    {
        return $this->DocNumberDId;
    }

    /**
     * Set DocNumberDId value
     * @param int $docNumberDId
     * @return MasterFields
     */
    public function setDocNumberDId($docNumberDId = null)
    {
        // validation for constraint: int
        if (!is_null($docNumberDId) && !(is_int($docNumberDId) || ctype_digit($docNumberDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docNumberDId, true), gettype($docNumberDId)), __LINE__);
        }
        $this->DocNumberDId = $docNumberDId;
        return $this;
    }

    /**
     * Get CatCode1Id value
     * @return int
     */
    public function getCatCode1Id()
    {
        return $this->CatCode1Id;
    }

    /**
     * Set CatCode1Id value
     * @param int $catCode1Id
     * @return MasterFields
     */
    public function setCatCode1Id($catCode1Id = null)
    {
        // validation for constraint: int
        if (!is_null($catCode1Id) && !(is_int($catCode1Id) || ctype_digit($catCode1Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catCode1Id, true), gettype($catCode1Id)), __LINE__);
        }
        $this->CatCode1Id = $catCode1Id;
        return $this;
    }

    /**
     * Get CatCode2Id value
     * @return int
     */
    public function getCatCode2Id()
    {
        return $this->CatCode2Id;
    }

    /**
     * Set CatCode2Id value
     * @param int $catCode2Id
     * @return MasterFields
     */
    public function setCatCode2Id($catCode2Id = null)
    {
        // validation for constraint: int
        if (!is_null($catCode2Id) && !(is_int($catCode2Id) || ctype_digit($catCode2Id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catCode2Id, true), gettype($catCode2Id)), __LINE__);
        }
        $this->CatCode2Id = $catCode2Id;
        return $this;
    }

    /**
     * Get SourceApp value
     * @return string
     */
    public function getSourceApp()
    {
        return $this->SourceApp;
    }

    /**
     * Set SourceApp value
     * @param string $sourceApp
     * @return MasterFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\SourceApplication::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\SourceApplication::valueIsValid()
     */
    public function setSourceApp($sourceApp = null)
    {
        // validation for constraint: enumeration
        if (!SourceApplication::valueIsValid($sourceApp)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\SourceApplication', is_array($sourceApp) ? implode(', ', $sourceApp) : var_export($sourceApp, true), implode(', ', SourceApplication::getValidValues())), __LINE__);
        }
        $this->SourceApp = $sourceApp;
        return $this;
    }

    /**
     * Get SourceApp2 value
     * @return string
     */
    public function getSourceApp2()
    {
        return $this->SourceApp2;
    }

    /**
     * Set SourceApp2 value
     * @param string $sourceApp2
     * @return MasterFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\SourceApplication::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\SourceApplication::valueIsValid()
     */
    public function setSourceApp2($sourceApp2 = null)
    {
        // validation for constraint: enumeration
        if (!SourceApplication::valueIsValid($sourceApp2)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\SourceApplication', is_array($sourceApp2) ? implode(', ', $sourceApp2) : var_export($sourceApp2, true), implode(', ', SourceApplication::getValidValues())), __LINE__);
        }
        $this->SourceApp2 = $sourceApp2;
        return $this;
    }

    /**
     * Get SourceApp3 value
     * @return string
     */
    public function getSourceApp3()
    {
        return $this->SourceApp3;
    }

    /**
     * Set SourceApp3 value
     * @param string $sourceApp3
     * @return MasterFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\SourceApplication::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\SourceApplication::valueIsValid()
     */
    public function setSourceApp3($sourceApp3 = null)
    {
        // validation for constraint: enumeration
        if (!SourceApplication::valueIsValid($sourceApp3)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\SourceApplication', is_array($sourceApp3) ? implode(', ', $sourceApp3) : var_export($sourceApp3, true), implode(', ', SourceApplication::getValidValues())), __LINE__);
        }
        $this->SourceApp3 = $sourceApp3;
        return $this;
    }

    /**
     * Get SourceMId value
     * @return int
     */
    public function getSourceMId()
    {
        return $this->SourceMId;
    }

    /**
     * Set SourceMId value
     * @param int $sourceMId
     * @return MasterFields
     */
    public function setSourceMId($sourceMId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceMId) && !(is_int($sourceMId) || ctype_digit($sourceMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceMId, true), gettype($sourceMId)), __LINE__);
        }
        $this->SourceMId = $sourceMId;
        return $this;
    }

    /**
     * Get SourceDId value
     * @return int
     */
    public function getSourceDId()
    {
        return $this->SourceDId;
    }

    /**
     * Set SourceDId value
     * @param int $sourceDId
     * @return MasterFields
     */
    public function setSourceDId($sourceDId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceDId) && !(is_int($sourceDId) || ctype_digit($sourceDId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceDId, true), gettype($sourceDId)), __LINE__);
        }
        $this->SourceDId = $sourceDId;
        return $this;
    }

    /**
     * Get CreateUserId value
     * @return int
     */
    public function getCreateUserId()
    {
        return $this->CreateUserId;
    }

    /**
     * Set CreateUserId value
     * @param int $createUserId
     * @return MasterFields
     */
    public function setCreateUserId($createUserId = null)
    {
        // validation for constraint: int
        if (!is_null($createUserId) && !(is_int($createUserId) || ctype_digit($createUserId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createUserId, true), gettype($createUserId)), __LINE__);
        }
        $this->CreateUserId = $createUserId;
        return $this;
    }

    /**
     * Get CurrencyOption value
     * @return string
     */
    public function getCurrencyOption()
    {
        return $this->CurrencyOption;
    }

    /**
     * Set CurrencyOption value
     * @param string $currencyOption
     * @return MasterFields
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahce\EnumType\CurrencyOption::getValidValues()
     * @uses \Gek\UyumBahce\EnumType\CurrencyOption::valueIsValid()
     */
    public function setCurrencyOption($currencyOption = null)
    {
        // validation for constraint: enumeration
        if (!CurrencyOption::valueIsValid($currencyOption)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahce\EnumType\CurrencyOption', is_array($currencyOption) ? implode(', ', $currencyOption) : var_export($currencyOption, true), implode(', ', CurrencyOption::getValidValues())), __LINE__);
        }
        $this->CurrencyOption = $currencyOption;
        return $this;
    }

    /**
     * Get EntityOrderDate value
     * @return string
     */
    public function getEntityOrderDate()
    {
        return $this->EntityOrderDate;
    }

    /**
     * Set EntityOrderDate value
     * @param string|GekDateTime $entityOrderDate
     * @return MasterFields
     */
    public function setEntityOrderDate($entityOrderDate = null)
    {
        // validation for constraint: string
        if (!is_null($entityOrderDate) && !is_string($entityOrderDate) && !(($entityOrderDate instanceof GekDateTime))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityOrderDate, true), gettype($entityOrderDate)), __LINE__);
        }
        if ($entityOrderDate instanceof GekDateTime) {
            $entityOrderDate = $entityOrderDate->toServiceString();
        }
        $this->EntityOrderDate = $entityOrderDate;
        return $this;
    }

    /**
     * Get CoCode value
     * @return string|null
     */
    public function getCoCode()
    {
        return $this->CoCode;
    }

    /**
     * Set CoCode value
     * @param string $coCode
     * @return MasterFields
     */
    public function setCoCode($coCode = null)
    {
        // validation for constraint: string
        if (!is_null($coCode) && !is_string($coCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coCode, true), gettype($coCode)), __LINE__);
        }
        $this->CoCode = $coCode;
        return $this;
    }

    /**
     * Get BranchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }

    /**
     * Set BranchCode value
     * @param string $branchCode
     * @return MasterFields
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }

    /**
     * Get DocNo value
     * @return string|null
     */
    public function getDocNo()
    {
        return $this->DocNo;
    }

    /**
     * Set DocNo value
     * @param string $docNo
     * @return MasterFields
     */
    public function setDocNo($docNo = null)
    {
        // validation for constraint: string
        if (!is_null($docNo) && !is_string($docNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNo, true), gettype($docNo)), __LINE__);
        }
        $this->DocNo = $docNo;
        return $this;
    }

    /**
     * Get CatCode1 value
     * @return string|null
     */
    public function getCatCode1()
    {
        return $this->CatCode1;
    }

    /**
     * Set CatCode1 value
     * @param string $catCode1
     * @return MasterFields
     */
    public function setCatCode1($catCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($catCode1) && !is_string($catCode1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode1, true), gettype($catCode1)), __LINE__);
        }
        $this->CatCode1 = $catCode1;
        return $this;
    }

    /**
     * Get CatCode2 value
     * @return string|null
     */
    public function getCatCode2()
    {
        return $this->CatCode2;
    }

    /**
     * Set CatCode2 value
     * @param string $catCode2
     * @return MasterFields
     */
    public function setCatCode2($catCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($catCode2) && !is_string($catCode2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode2, true), gettype($catCode2)), __LINE__);
        }
        $this->CatCode2 = $catCode2;
        return $this;
    }

    /**
     * Get Controller value
     * @return DocController|null
     */
    public function getController()
    {
        return $this->Controller;
    }

    /**
     * Set Controller value
     * @param DocController $controller
     * @return MasterFields
     */
    public function setController(DocController $controller = null)
    {
        $this->Controller = $controller;
        return $this;
    }

    /**
     * Get Note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->Note1;
    }

    /**
     * Set Note1 value
     * @param string $note1
     * @return MasterFields
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        $this->Note1 = $note1;
        return $this;
    }

    /**
     * Get Note2 value
     * @return string|null
     */
    public function getNote2()
    {
        return $this->Note2;
    }

    /**
     * Set Note2 value
     * @param string $note2
     * @return MasterFields
     */
    public function setNote2($note2 = null)
    {
        // validation for constraint: string
        if (!is_null($note2) && !is_string($note2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note2, true), gettype($note2)), __LINE__);
        }
        $this->Note2 = $note2;
        return $this;
    }

    /**
     * Get Note3 value
     * @return string|null
     */
    public function getNote3()
    {
        return $this->Note3;
    }

    /**
     * Set Note3 value
     * @param string $note3
     * @return MasterFields
     */
    public function setNote3($note3 = null)
    {
        // validation for constraint: string
        if (!is_null($note3) && !is_string($note3)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note3, true), gettype($note3)), __LINE__);
        }
        $this->Note3 = $note3;
        return $this;
    }

    /**
     * Get EntityOrderNo value
     * @return string|null
     */
    public function getEntityOrderNo()
    {
        return $this->EntityOrderNo;
    }

    /**
     * Set EntityOrderNo value
     * @param string $entityOrderNo
     * @return MasterFields
     */
    public function setEntityOrderNo($entityOrderNo = null)
    {
        // validation for constraint: string
        if (!is_null($entityOrderNo) && !is_string($entityOrderNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityOrderNo, true), gettype($entityOrderNo)), __LINE__);
        }
        $this->EntityOrderNo = $entityOrderNo;
        return $this;
    }
}
