<?php

namespace Gek\UyumBahce\StructType;

use Gek\UyumBahce\ArrayType\ArrayOfUBLExtensionType;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceType StructType
 * @subpackage Structs
 */
class InvoiceType extends AbstractStructBase
{
    /**
     * The UBLExtensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s2:UBLExtensions
     * @var ArrayOfUBLExtensionType
     */
    public $UBLExtensions;
    /**
     * The UBLVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:UBLVersionID
     * @var UBLVersionIDType
     */
    public $UBLVersionID;
    /**
     * The CustomizationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomizationID
     * @var CustomizationIDType
     */
    public $CustomizationID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ProfileID
     * @var ProfileIDType
     */
    public $ProfileID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The CopyIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CopyIndicator
     * @var CopyIndicatorType
     */
    public $CopyIndicator;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:UUID
     * @var UUIDType
     */
    public $UUID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IssueDate
     * @var IssueDateType
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IssueTime
     * @var IssueTimeType
     */
    public $IssueTime;
    /**
     * The InvoiceTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InvoiceTypeCode
     * @var InvoiceTypeCodeType
     */
    public $InvoiceTypeCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Note
     * @var NoteType[]
     */
    public $Note;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DocumentCurrencyCode
     * @var DocumentCurrencyCodeType
     */
    public $DocumentCurrencyCode;
    /**
     * The TaxCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxCurrencyCode
     * @var TaxCurrencyCodeType
     */
    public $TaxCurrencyCode;
    /**
     * The PricingCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PricingCurrencyCode
     * @var PricingCurrencyCodeType
     */
    public $PricingCurrencyCode;
    /**
     * The PaymentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentCurrencyCode
     * @var PaymentCurrencyCodeType
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentAlternativeCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentAlternativeCurrencyCode
     * @var PaymentAlternativeCurrencyCodeType
     */
    public $PaymentAlternativeCurrencyCode;
    /**
     * The AccountingCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:AccountingCost
     * @var AccountingCostType
     */
    public $AccountingCost;
    /**
     * The LineCountNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineCountNumeric
     * @var LineCountNumericType
     */
    public $LineCountNumeric;
    /**
     * The InvoicePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:InvoicePeriod
     * @var PeriodType
     */
    public $InvoicePeriod;
    /**
     * The OrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:OrderReference
     * @var OrderReferenceType
     */
    public $OrderReference;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:BillingReference
     * @var BillingReferenceType[]
     */
    public $BillingReference;
    /**
     * The DespatchDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:DespatchDocumentReference
     * @var DocumentReferenceType[]
     */
    public $DespatchDocumentReference;
    /**
     * The ReceiptDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:ReceiptDocumentReference
     * @var DocumentReferenceType[]
     */
    public $ReceiptDocumentReference;
    /**
     * The OriginatorDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:OriginatorDocumentReference
     * @var DocumentReferenceType[]
     */
    public $OriginatorDocumentReference;
    /**
     * The ContractDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:ContractDocumentReference
     * @var DocumentReferenceType[]
     */
    public $ContractDocumentReference;
    /**
     * The AdditionalDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:AdditionalDocumentReference
     * @var DocumentReferenceType[]
     */
    public $AdditionalDocumentReference;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:Signature
     * @var SignatureType[]
     */
    public $Signature;
    /**
     * The AccountingSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:AccountingSupplierParty
     * @var SupplierPartyType
     */
    public $AccountingSupplierParty;
    /**
     * The AccountingCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:AccountingCustomerParty
     * @var CustomerPartyType
     */
    public $AccountingCustomerParty;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:BuyerCustomerParty
     * @var CustomerPartyType
     */
    public $BuyerCustomerParty;
    /**
     * The SellerSupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:SellerSupplierParty
     * @var SupplierPartyType
     */
    public $SellerSupplierParty;
    /**
     * The TaxRepresentativeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:TaxRepresentativeParty
     * @var PartyType
     */
    public $TaxRepresentativeParty;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:Delivery
     * @var DeliveryType[]
     */
    public $Delivery;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:PaymentMeans
     * @var PaymentMeansType[]
     */
    public $PaymentMeans;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PaymentTerms
     * @var PaymentTermsType
     */
    public $PaymentTerms;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:AllowanceCharge
     * @var AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:TaxExchangeRate
     * @var ExchangeRateType
     */
    public $TaxExchangeRate;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PricingExchangeRate
     * @var ExchangeRateType
     */
    public $PricingExchangeRate;
    /**
     * The PaymentExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PaymentExchangeRate
     * @var ExchangeRateType
     */
    public $PaymentExchangeRate;
    /**
     * The PaymentAlternativeExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:PaymentAlternativeExchangeRate
     * @var ExchangeRateType
     */
    public $PaymentAlternativeExchangeRate;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:TaxTotal
     * @var TaxTotalType[]
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:WithholdingTaxTotal
     * @var TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The LegalMonetaryTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s8:LegalMonetaryTotal
     * @var MonetaryTotalType
     */
    public $LegalMonetaryTotal;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s8:InvoiceLine
     * @var InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The schemaLocation
     * @var string
     */
    public $schemaLocation;

    /**
     * Constructor method for InvoiceType
     * @param ArrayOfUBLExtensionType $uBLExtensions
     * @param UBLVersionIDType $uBLVersionID
     * @param CustomizationIDType $customizationID
     * @param ProfileIDType $profileID
     * @param IDType $iD
     * @param CopyIndicatorType $copyIndicator
     * @param UUIDType $uUID
     * @param IssueDateType $issueDate
     * @param IssueTimeType $issueTime
     * @param InvoiceTypeCodeType $invoiceTypeCode
     * @param NoteType[] $note
     * @param DocumentCurrencyCodeType $documentCurrencyCode
     * @param TaxCurrencyCodeType $taxCurrencyCode
     * @param PricingCurrencyCodeType $pricingCurrencyCode
     * @param PaymentCurrencyCodeType $paymentCurrencyCode
     * @param PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @param AccountingCostType $accountingCost
     * @param LineCountNumericType $lineCountNumeric
     * @param PeriodType $invoicePeriod
     * @param OrderReferenceType $orderReference
     * @param BillingReferenceType[] $billingReference
     * @param DocumentReferenceType[] $despatchDocumentReference
     * @param DocumentReferenceType[] $receiptDocumentReference
     * @param DocumentReferenceType[] $originatorDocumentReference
     * @param DocumentReferenceType[] $contractDocumentReference
     * @param DocumentReferenceType[] $additionalDocumentReference
     * @param SignatureType[] $signature
     * @param SupplierPartyType $accountingSupplierParty
     * @param CustomerPartyType $accountingCustomerParty
     * @param CustomerPartyType $buyerCustomerParty
     * @param SupplierPartyType $sellerSupplierParty
     * @param PartyType $taxRepresentativeParty
     * @param DeliveryType[] $delivery
     * @param PaymentMeansType[] $paymentMeans
     * @param PaymentTermsType $paymentTerms
     * @param AllowanceChargeType[] $allowanceCharge
     * @param ExchangeRateType $taxExchangeRate
     * @param ExchangeRateType $pricingExchangeRate
     * @param ExchangeRateType $paymentExchangeRate
     * @param ExchangeRateType $paymentAlternativeExchangeRate
     * @param TaxTotalType[] $taxTotal
     * @param TaxTotalType[] $withholdingTaxTotal
     * @param MonetaryTotalType $legalMonetaryTotal
     * @param InvoiceLineType[] $invoiceLine
     * @param string $schemaLocation
     * @uses InvoiceType::setUBLExtensions()
     * @uses InvoiceType::setUBLVersionID()
     * @uses InvoiceType::setCustomizationID()
     * @uses InvoiceType::setProfileID()
     * @uses InvoiceType::setID()
     * @uses InvoiceType::setCopyIndicator()
     * @uses InvoiceType::setUUID()
     * @uses InvoiceType::setIssueDate()
     * @uses InvoiceType::setIssueTime()
     * @uses InvoiceType::setInvoiceTypeCode()
     * @uses InvoiceType::setNote()
     * @uses InvoiceType::setDocumentCurrencyCode()
     * @uses InvoiceType::setTaxCurrencyCode()
     * @uses InvoiceType::setPricingCurrencyCode()
     * @uses InvoiceType::setPaymentCurrencyCode()
     * @uses InvoiceType::setPaymentAlternativeCurrencyCode()
     * @uses InvoiceType::setAccountingCost()
     * @uses InvoiceType::setLineCountNumeric()
     * @uses InvoiceType::setInvoicePeriod()
     * @uses InvoiceType::setOrderReference()
     * @uses InvoiceType::setBillingReference()
     * @uses InvoiceType::setDespatchDocumentReference()
     * @uses InvoiceType::setReceiptDocumentReference()
     * @uses InvoiceType::setOriginatorDocumentReference()
     * @uses InvoiceType::setContractDocumentReference()
     * @uses InvoiceType::setAdditionalDocumentReference()
     * @uses InvoiceType::setSignature()
     * @uses InvoiceType::setAccountingSupplierParty()
     * @uses InvoiceType::setAccountingCustomerParty()
     * @uses InvoiceType::setBuyerCustomerParty()
     * @uses InvoiceType::setSellerSupplierParty()
     * @uses InvoiceType::setTaxRepresentativeParty()
     * @uses InvoiceType::setDelivery()
     * @uses InvoiceType::setPaymentMeans()
     * @uses InvoiceType::setPaymentTerms()
     * @uses InvoiceType::setAllowanceCharge()
     * @uses InvoiceType::setTaxExchangeRate()
     * @uses InvoiceType::setPricingExchangeRate()
     * @uses InvoiceType::setPaymentExchangeRate()
     * @uses InvoiceType::setPaymentAlternativeExchangeRate()
     * @uses InvoiceType::setTaxTotal()
     * @uses InvoiceType::setWithholdingTaxTotal()
     * @uses InvoiceType::setLegalMonetaryTotal()
     * @uses InvoiceType::setInvoiceLine()
     * @uses InvoiceType::setSchemaLocation()
     */
    public function __construct(ArrayOfUBLExtensionType $uBLExtensions = null, UBLVersionIDType $uBLVersionID = null, CustomizationIDType $customizationID = null, ProfileIDType $profileID = null, IDType $iD = null, CopyIndicatorType $copyIndicator = null, UUIDType $uUID = null, IssueDateType $issueDate = null, IssueTimeType $issueTime = null, InvoiceTypeCodeType $invoiceTypeCode = null, array $note = array(), DocumentCurrencyCodeType $documentCurrencyCode = null, TaxCurrencyCodeType $taxCurrencyCode = null, PricingCurrencyCodeType $pricingCurrencyCode = null, PaymentCurrencyCodeType $paymentCurrencyCode = null, PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null, AccountingCostType $accountingCost = null, LineCountNumericType $lineCountNumeric = null, PeriodType $invoicePeriod = null, OrderReferenceType $orderReference = null, array $billingReference = array(), array $despatchDocumentReference = array(), array $receiptDocumentReference = array(), array $originatorDocumentReference = array(), array $contractDocumentReference = array(), array $additionalDocumentReference = array(), array $signature = array(), SupplierPartyType $accountingSupplierParty = null, CustomerPartyType $accountingCustomerParty = null, CustomerPartyType $buyerCustomerParty = null, SupplierPartyType $sellerSupplierParty = null, PartyType $taxRepresentativeParty = null, array $delivery = array(), array $paymentMeans = array(), PaymentTermsType $paymentTerms = null, array $allowanceCharge = array(), ExchangeRateType $taxExchangeRate = null, ExchangeRateType $pricingExchangeRate = null, ExchangeRateType $paymentExchangeRate = null, ExchangeRateType $paymentAlternativeExchangeRate = null, array $taxTotal = array(), array $withholdingTaxTotal = array(), MonetaryTotalType $legalMonetaryTotal = null, array $invoiceLine = array(), $schemaLocation = null)
    {
        $this
            ->setUBLExtensions($uBLExtensions)
            ->setUBLVersionID($uBLVersionID)
            ->setCustomizationID($customizationID)
            ->setProfileID($profileID)
            ->setID($iD)
            ->setCopyIndicator($copyIndicator)
            ->setUUID($uUID)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setNote($note)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setPricingCurrencyCode($pricingCurrencyCode)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode)
            ->setAccountingCost($accountingCost)
            ->setLineCountNumeric($lineCountNumeric)
            ->setInvoicePeriod($invoicePeriod)
            ->setOrderReference($orderReference)
            ->setBillingReference($billingReference)
            ->setDespatchDocumentReference($despatchDocumentReference)
            ->setReceiptDocumentReference($receiptDocumentReference)
            ->setOriginatorDocumentReference($originatorDocumentReference)
            ->setContractDocumentReference($contractDocumentReference)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setSignature($signature)
            ->setAccountingSupplierParty($accountingSupplierParty)
            ->setAccountingCustomerParty($accountingCustomerParty)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setSellerSupplierParty($sellerSupplierParty)
            ->setTaxRepresentativeParty($taxRepresentativeParty)
            ->setDelivery($delivery)
            ->setPaymentMeans($paymentMeans)
            ->setPaymentTerms($paymentTerms)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxExchangeRate($taxExchangeRate)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setPaymentExchangeRate($paymentExchangeRate)
            ->setPaymentAlternativeExchangeRate($paymentAlternativeExchangeRate)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setLegalMonetaryTotal($legalMonetaryTotal)
            ->setInvoiceLine($invoiceLine)
            ->setSchemaLocation($schemaLocation);
    }

    /**
     * Get UBLExtensions value
     * @return ArrayOfUBLExtensionType|null
     */
    public function getUBLExtensions()
    {
        return $this->UBLExtensions;
    }

    /**
     * Set UBLExtensions value
     * @param ArrayOfUBLExtensionType $uBLExtensions
     * @return InvoiceType
     */
    public function setUBLExtensions(ArrayOfUBLExtensionType $uBLExtensions = null)
    {
        $this->UBLExtensions = $uBLExtensions;
        return $this;
    }

    /**
     * Get UBLVersionID value
     * @return UBLVersionIDType|null
     */
    public function getUBLVersionID()
    {
        return $this->UBLVersionID;
    }

    /**
     * Set UBLVersionID value
     * @param UBLVersionIDType $uBLVersionID
     * @return InvoiceType
     */
    public function setUBLVersionID(UBLVersionIDType $uBLVersionID = null)
    {
        $this->UBLVersionID = $uBLVersionID;
        return $this;
    }

    /**
     * Get CustomizationID value
     * @return CustomizationIDType|null
     */
    public function getCustomizationID()
    {
        return $this->CustomizationID;
    }

    /**
     * Set CustomizationID value
     * @param CustomizationIDType $customizationID
     * @return InvoiceType
     */
    public function setCustomizationID(CustomizationIDType $customizationID = null)
    {
        $this->CustomizationID = $customizationID;
        return $this;
    }

    /**
     * Get ProfileID value
     * @return ProfileIDType|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }

    /**
     * Set ProfileID value
     * @param ProfileIDType $profileID
     * @return InvoiceType
     */
    public function setProfileID(ProfileIDType $profileID = null)
    {
        $this->ProfileID = $profileID;
        return $this;
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return InvoiceType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get CopyIndicator value
     * @return CopyIndicatorType|null
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }

    /**
     * Set CopyIndicator value
     * @param CopyIndicatorType $copyIndicator
     * @return InvoiceType
     */
    public function setCopyIndicator(CopyIndicatorType $copyIndicator = null)
    {
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }

    /**
     * Get UUID value
     * @return UUIDType|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }

    /**
     * Set UUID value
     * @param UUIDType $uUID
     * @return InvoiceType
     */
    public function setUUID(UUIDType $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }

    /**
     * Get IssueDate value
     * @return IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }

    /**
     * Set IssueDate value
     * @param IssueDateType $issueDate
     * @return InvoiceType
     */
    public function setIssueDate(IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }

    /**
     * Get IssueTime value
     * @return IssueTimeType|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }

    /**
     * Set IssueTime value
     * @param IssueTimeType $issueTime
     * @return InvoiceType
     */
    public function setIssueTime(IssueTimeType $issueTime = null)
    {
        $this->IssueTime = $issueTime;
        return $this;
    }

    /**
     * Get InvoiceTypeCode value
     * @return InvoiceTypeCodeType|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }

    /**
     * Set InvoiceTypeCode value
     * @param InvoiceTypeCodeType $invoiceTypeCode
     * @return InvoiceType
     */
    public function setInvoiceTypeCode(InvoiceTypeCodeType $invoiceTypeCode = null)
    {
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }

    /**
     * Get Note value
     * @return NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }

    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeNoteItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeNoteItem instanceof NoteType) {
                $invalidValues[] = is_object($invoiceTypeNoteItem) ? get_class($invoiceTypeNoteItem) : sprintf('%s(%s)', gettype($invoiceTypeNoteItem), var_export($invoiceTypeNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \Gek\UyumBahce\StructType\NoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Note value
     * @param NoteType[] $note
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }

    /**
     * Add item to Note value
     * @param NoteType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToNote(NoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof NoteType) {
            throw new InvalidArgumentException(sprintf('The Note property can only contain items of type \Gek\UyumBahce\StructType\NoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }

    /**
     * Get DocumentCurrencyCode value
     * @return DocumentCurrencyCodeType|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }

    /**
     * Set DocumentCurrencyCode value
     * @param DocumentCurrencyCodeType $documentCurrencyCode
     * @return InvoiceType
     */
    public function setDocumentCurrencyCode(DocumentCurrencyCodeType $documentCurrencyCode = null)
    {
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }

    /**
     * Get TaxCurrencyCode value
     * @return TaxCurrencyCodeType|null
     */
    public function getTaxCurrencyCode()
    {
        return $this->TaxCurrencyCode;
    }

    /**
     * Set TaxCurrencyCode value
     * @param TaxCurrencyCodeType $taxCurrencyCode
     * @return InvoiceType
     */
    public function setTaxCurrencyCode(TaxCurrencyCodeType $taxCurrencyCode = null)
    {
        $this->TaxCurrencyCode = $taxCurrencyCode;
        return $this;
    }

    /**
     * Get PricingCurrencyCode value
     * @return PricingCurrencyCodeType|null
     */
    public function getPricingCurrencyCode()
    {
        return $this->PricingCurrencyCode;
    }

    /**
     * Set PricingCurrencyCode value
     * @param PricingCurrencyCodeType $pricingCurrencyCode
     * @return InvoiceType
     */
    public function setPricingCurrencyCode(PricingCurrencyCodeType $pricingCurrencyCode = null)
    {
        $this->PricingCurrencyCode = $pricingCurrencyCode;
        return $this;
    }

    /**
     * Get PaymentCurrencyCode value
     * @return PaymentCurrencyCodeType|null
     */
    public function getPaymentCurrencyCode()
    {
        return $this->PaymentCurrencyCode;
    }

    /**
     * Set PaymentCurrencyCode value
     * @param PaymentCurrencyCodeType $paymentCurrencyCode
     * @return InvoiceType
     */
    public function setPaymentCurrencyCode(PaymentCurrencyCodeType $paymentCurrencyCode = null)
    {
        $this->PaymentCurrencyCode = $paymentCurrencyCode;
        return $this;
    }

    /**
     * Get PaymentAlternativeCurrencyCode value
     * @return PaymentAlternativeCurrencyCodeType|null
     */
    public function getPaymentAlternativeCurrencyCode()
    {
        return $this->PaymentAlternativeCurrencyCode;
    }

    /**
     * Set PaymentAlternativeCurrencyCode value
     * @param PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode
     * @return InvoiceType
     */
    public function setPaymentAlternativeCurrencyCode(PaymentAlternativeCurrencyCodeType $paymentAlternativeCurrencyCode = null)
    {
        $this->PaymentAlternativeCurrencyCode = $paymentAlternativeCurrencyCode;
        return $this;
    }

    /**
     * Get AccountingCost value
     * @return AccountingCostType|null
     */
    public function getAccountingCost()
    {
        return $this->AccountingCost;
    }

    /**
     * Set AccountingCost value
     * @param AccountingCostType $accountingCost
     * @return InvoiceType
     */
    public function setAccountingCost(AccountingCostType $accountingCost = null)
    {
        $this->AccountingCost = $accountingCost;
        return $this;
    }

    /**
     * Get LineCountNumeric value
     * @return LineCountNumericType|null
     */
    public function getLineCountNumeric()
    {
        return $this->LineCountNumeric;
    }

    /**
     * Set LineCountNumeric value
     * @param LineCountNumericType $lineCountNumeric
     * @return InvoiceType
     */
    public function setLineCountNumeric(LineCountNumericType $lineCountNumeric = null)
    {
        $this->LineCountNumeric = $lineCountNumeric;
        return $this;
    }

    /**
     * Get InvoicePeriod value
     * @return PeriodType|null
     */
    public function getInvoicePeriod()
    {
        return $this->InvoicePeriod;
    }

    /**
     * Set InvoicePeriod value
     * @param PeriodType $invoicePeriod
     * @return InvoiceType
     */
    public function setInvoicePeriod(PeriodType $invoicePeriod = null)
    {
        $this->InvoicePeriod = $invoicePeriod;
        return $this;
    }

    /**
     * Get OrderReference value
     * @return OrderReferenceType|null
     */
    public function getOrderReference()
    {
        return $this->OrderReference;
    }

    /**
     * Set OrderReference value
     * @param OrderReferenceType $orderReference
     * @return InvoiceType
     */
    public function setOrderReference(OrderReferenceType $orderReference = null)
    {
        $this->OrderReference = $orderReference;
        return $this;
    }

    /**
     * Get BillingReference value
     * @return BillingReferenceType[]|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }

    /**
     * This method is responsible for validating the values passed to the setBillingReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingReferenceForArrayConstraintsFromSetBillingReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeBillingReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeBillingReferenceItem instanceof BillingReferenceType) {
                $invalidValues[] = is_object($invoiceTypeBillingReferenceItem) ? get_class($invoiceTypeBillingReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeBillingReferenceItem), var_export($invoiceTypeBillingReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillingReference property can only contain items of type \Gek\UyumBahce\StructType\BillingReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set BillingReference value
     * @param BillingReferenceType[] $billingReference
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setBillingReference(array $billingReference = array())
    {
        // validation for constraint: array
        if ('' !== ($billingReferenceArrayErrorMessage = self::validateBillingReferenceForArrayConstraintsFromSetBillingReference($billingReference))) {
            throw new InvalidArgumentException($billingReferenceArrayErrorMessage, __LINE__);
        }
        $this->BillingReference = $billingReference;
        return $this;
    }

    /**
     * Add item to BillingReference value
     * @param BillingReferenceType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToBillingReference(BillingReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof BillingReferenceType) {
            throw new InvalidArgumentException(sprintf('The BillingReference property can only contain items of type \Gek\UyumBahce\StructType\BillingReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillingReference[] = $item;
        return $this;
    }

    /**
     * Get DespatchDocumentReference value
     * @return DocumentReferenceType[]|null
     */
    public function getDespatchDocumentReference()
    {
        return $this->DespatchDocumentReference;
    }

    /**
     * This method is responsible for validating the values passed to the setDespatchDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeDespatchDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeDespatchDocumentReferenceItem instanceof DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeDespatchDocumentReferenceItem) ? get_class($invoiceTypeDespatchDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeDespatchDocumentReferenceItem), var_export($invoiceTypeDespatchDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DespatchDocumentReference value
     * @param DocumentReferenceType[] $despatchDocumentReference
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setDespatchDocumentReference(array $despatchDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchDocumentReferenceArrayErrorMessage = self::validateDespatchDocumentReferenceForArrayConstraintsFromSetDespatchDocumentReference($despatchDocumentReference))) {
            throw new InvalidArgumentException($despatchDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->DespatchDocumentReference = $despatchDocumentReference;
        return $this;
    }

    /**
     * Add item to DespatchDocumentReference value
     * @param DocumentReferenceType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToDespatchDocumentReference(DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentReferenceType) {
            throw new InvalidArgumentException(sprintf('The DespatchDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchDocumentReference[] = $item;
        return $this;
    }

    /**
     * Get ReceiptDocumentReference value
     * @return DocumentReferenceType[]|null
     */
    public function getReceiptDocumentReference()
    {
        return $this->ReceiptDocumentReference;
    }

    /**
     * This method is responsible for validating the values passed to the setReceiptDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeReceiptDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeReceiptDocumentReferenceItem instanceof DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeReceiptDocumentReferenceItem) ? get_class($invoiceTypeReceiptDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeReceiptDocumentReferenceItem), var_export($invoiceTypeReceiptDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiptDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ReceiptDocumentReference value
     * @param DocumentReferenceType[] $receiptDocumentReference
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setReceiptDocumentReference(array $receiptDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptDocumentReferenceArrayErrorMessage = self::validateReceiptDocumentReferenceForArrayConstraintsFromSetReceiptDocumentReference($receiptDocumentReference))) {
            throw new InvalidArgumentException($receiptDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ReceiptDocumentReference = $receiptDocumentReference;
        return $this;
    }

    /**
     * Add item to ReceiptDocumentReference value
     * @param DocumentReferenceType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToReceiptDocumentReference(DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentReferenceType) {
            throw new InvalidArgumentException(sprintf('The ReceiptDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiptDocumentReference[] = $item;
        return $this;
    }

    /**
     * Get OriginatorDocumentReference value
     * @return DocumentReferenceType[]|null
     */
    public function getOriginatorDocumentReference()
    {
        return $this->OriginatorDocumentReference;
    }

    /**
     * This method is responsible for validating the values passed to the setOriginatorDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginatorDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeOriginatorDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeOriginatorDocumentReferenceItem instanceof DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeOriginatorDocumentReferenceItem) ? get_class($invoiceTypeOriginatorDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeOriginatorDocumentReferenceItem), var_export($invoiceTypeOriginatorDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginatorDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set OriginatorDocumentReference value
     * @param DocumentReferenceType[] $originatorDocumentReference
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setOriginatorDocumentReference(array $originatorDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($originatorDocumentReferenceArrayErrorMessage = self::validateOriginatorDocumentReferenceForArrayConstraintsFromSetOriginatorDocumentReference($originatorDocumentReference))) {
            throw new InvalidArgumentException($originatorDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->OriginatorDocumentReference = $originatorDocumentReference;
        return $this;
    }

    /**
     * Add item to OriginatorDocumentReference value
     * @param DocumentReferenceType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToOriginatorDocumentReference(DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentReferenceType) {
            throw new InvalidArgumentException(sprintf('The OriginatorDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginatorDocumentReference[] = $item;
        return $this;
    }

    /**
     * Get ContractDocumentReference value
     * @return DocumentReferenceType[]|null
     */
    public function getContractDocumentReference()
    {
        return $this->ContractDocumentReference;
    }

    /**
     * This method is responsible for validating the values passed to the setContractDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeContractDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeContractDocumentReferenceItem instanceof DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeContractDocumentReferenceItem) ? get_class($invoiceTypeContractDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeContractDocumentReferenceItem), var_export($invoiceTypeContractDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContractDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ContractDocumentReference value
     * @param DocumentReferenceType[] $contractDocumentReference
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setContractDocumentReference(array $contractDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($contractDocumentReferenceArrayErrorMessage = self::validateContractDocumentReferenceForArrayConstraintsFromSetContractDocumentReference($contractDocumentReference))) {
            throw new InvalidArgumentException($contractDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ContractDocumentReference = $contractDocumentReference;
        return $this;
    }

    /**
     * Add item to ContractDocumentReference value
     * @param DocumentReferenceType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToContractDocumentReference(DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentReferenceType) {
            throw new InvalidArgumentException(sprintf('The ContractDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContractDocumentReference[] = $item;
        return $this;
    }

    /**
     * Get AdditionalDocumentReference value
     * @return DocumentReferenceType[]|null
     */
    public function getAdditionalDocumentReference()
    {
        return $this->AdditionalDocumentReference;
    }

    /**
     * This method is responsible for validating the values passed to the setAdditionalDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeAdditionalDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeAdditionalDocumentReferenceItem instanceof DocumentReferenceType) {
                $invalidValues[] = is_object($invoiceTypeAdditionalDocumentReferenceItem) ? get_class($invoiceTypeAdditionalDocumentReferenceItem) : sprintf('%s(%s)', gettype($invoiceTypeAdditionalDocumentReferenceItem), var_export($invoiceTypeAdditionalDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set AdditionalDocumentReference value
     * @param DocumentReferenceType[] $additionalDocumentReference
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setAdditionalDocumentReference(array $additionalDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalDocumentReferenceArrayErrorMessage = self::validateAdditionalDocumentReferenceForArrayConstraintsFromSetAdditionalDocumentReference($additionalDocumentReference))) {
            throw new InvalidArgumentException($additionalDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->AdditionalDocumentReference = $additionalDocumentReference;
        return $this;
    }

    /**
     * Add item to AdditionalDocumentReference value
     * @param DocumentReferenceType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToAdditionalDocumentReference(DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentReferenceType) {
            throw new InvalidArgumentException(sprintf('The AdditionalDocumentReference property can only contain items of type \Gek\UyumBahce\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalDocumentReference[] = $item;
        return $this;
    }

    /**
     * Get Signature value
     * @return SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }

    /**
     * This method is responsible for validating the values passed to the setSignature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignatureForArrayConstraintsFromSetSignature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeSignatureItem instanceof SignatureType) {
                $invalidValues[] = is_object($invoiceTypeSignatureItem) ? get_class($invoiceTypeSignatureItem) : sprintf('%s(%s)', gettype($invoiceTypeSignatureItem), var_export($invoiceTypeSignatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Signature property can only contain items of type \Gek\UyumBahce\StructType\SignatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Signature value
     * @param SignatureType[] $signature
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setSignature(array $signature = array())
    {
        // validation for constraint: array
        if ('' !== ($signatureArrayErrorMessage = self::validateSignatureForArrayConstraintsFromSetSignature($signature))) {
            throw new InvalidArgumentException($signatureArrayErrorMessage, __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }

    /**
     * Add item to Signature value
     * @param SignatureType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToSignature(SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SignatureType) {
            throw new InvalidArgumentException(sprintf('The Signature property can only contain items of type \Gek\UyumBahce\StructType\SignatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }

    /**
     * Get AccountingSupplierParty value
     * @return SupplierPartyType|null
     */
    public function getAccountingSupplierParty()
    {
        return $this->AccountingSupplierParty;
    }

    /**
     * Set AccountingSupplierParty value
     * @param SupplierPartyType $accountingSupplierParty
     * @return InvoiceType
     */
    public function setAccountingSupplierParty(SupplierPartyType $accountingSupplierParty = null)
    {
        $this->AccountingSupplierParty = $accountingSupplierParty;
        return $this;
    }

    /**
     * Get AccountingCustomerParty value
     * @return CustomerPartyType|null
     */
    public function getAccountingCustomerParty()
    {
        return $this->AccountingCustomerParty;
    }

    /**
     * Set AccountingCustomerParty value
     * @param CustomerPartyType $accountingCustomerParty
     * @return InvoiceType
     */
    public function setAccountingCustomerParty(CustomerPartyType $accountingCustomerParty = null)
    {
        $this->AccountingCustomerParty = $accountingCustomerParty;
        return $this;
    }

    /**
     * Get BuyerCustomerParty value
     * @return CustomerPartyType|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }

    /**
     * Set BuyerCustomerParty value
     * @param CustomerPartyType $buyerCustomerParty
     * @return InvoiceType
     */
    public function setBuyerCustomerParty(CustomerPartyType $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }

    /**
     * Get SellerSupplierParty value
     * @return SupplierPartyType|null
     */
    public function getSellerSupplierParty()
    {
        return $this->SellerSupplierParty;
    }

    /**
     * Set SellerSupplierParty value
     * @param SupplierPartyType $sellerSupplierParty
     * @return InvoiceType
     */
    public function setSellerSupplierParty(SupplierPartyType $sellerSupplierParty = null)
    {
        $this->SellerSupplierParty = $sellerSupplierParty;
        return $this;
    }

    /**
     * Get TaxRepresentativeParty value
     * @return PartyType|null
     */
    public function getTaxRepresentativeParty()
    {
        return $this->TaxRepresentativeParty;
    }

    /**
     * Set TaxRepresentativeParty value
     * @param PartyType $taxRepresentativeParty
     * @return InvoiceType
     */
    public function setTaxRepresentativeParty(PartyType $taxRepresentativeParty = null)
    {
        $this->TaxRepresentativeParty = $taxRepresentativeParty;
        return $this;
    }

    /**
     * Get Delivery value
     * @return DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }

    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeDeliveryItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeDeliveryItem instanceof DeliveryType) {
                $invalidValues[] = is_object($invoiceTypeDeliveryItem) ? get_class($invoiceTypeDeliveryItem) : sprintf('%s(%s)', gettype($invoiceTypeDeliveryItem), var_export($invoiceTypeDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \Gek\UyumBahce\StructType\DeliveryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Delivery value
     * @param DeliveryType[] $delivery
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }

    /**
     * Add item to Delivery value
     * @param DeliveryType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToDelivery(DeliveryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DeliveryType) {
            throw new InvalidArgumentException(sprintf('The Delivery property can only contain items of type \Gek\UyumBahce\StructType\DeliveryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }

    /**
     * Get PaymentMeans value
     * @return PaymentMeansType[]|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }

    /**
     * This method is responsible for validating the values passed to the setPaymentMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMeansForArrayConstraintsFromSetPaymentMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypePaymentMeansItem) {
            // validation for constraint: itemType
            if (!$invoiceTypePaymentMeansItem instanceof PaymentMeansType) {
                $invalidValues[] = is_object($invoiceTypePaymentMeansItem) ? get_class($invoiceTypePaymentMeansItem) : sprintf('%s(%s)', gettype($invoiceTypePaymentMeansItem), var_export($invoiceTypePaymentMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMeans property can only contain items of type \Gek\UyumBahce\StructType\PaymentMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set PaymentMeans value
     * @param PaymentMeansType[] $paymentMeans
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setPaymentMeans(array $paymentMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMeansArrayErrorMessage = self::validatePaymentMeansForArrayConstraintsFromSetPaymentMeans($paymentMeans))) {
            throw new InvalidArgumentException($paymentMeansArrayErrorMessage, __LINE__);
        }
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }

    /**
     * Add item to PaymentMeans value
     * @param PaymentMeansType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToPaymentMeans(PaymentMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PaymentMeansType) {
            throw new InvalidArgumentException(sprintf('The PaymentMeans property can only contain items of type \Gek\UyumBahce\StructType\PaymentMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMeans[] = $item;
        return $this;
    }

    /**
     * Get PaymentTerms value
     * @return PaymentTermsType|null
     */
    public function getPaymentTerms()
    {
        return $this->PaymentTerms;
    }

    /**
     * Set PaymentTerms value
     * @param PaymentTermsType $paymentTerms
     * @return InvoiceType
     */
    public function setPaymentTerms(PaymentTermsType $paymentTerms = null)
    {
        $this->PaymentTerms = $paymentTerms;
        return $this;
    }

    /**
     * Get AllowanceCharge value
     * @return AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }

    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeAllowanceChargeItem instanceof AllowanceChargeType) {
                $invalidValues[] = is_object($invoiceTypeAllowanceChargeItem) ? get_class($invoiceTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($invoiceTypeAllowanceChargeItem), var_export($invoiceTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahce\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set AllowanceCharge value
     * @param AllowanceChargeType[] $allowanceCharge
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }

    /**
     * Add item to AllowanceCharge value
     * @param AllowanceChargeType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToAllowanceCharge(AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AllowanceChargeType) {
            throw new InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahce\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }

    /**
     * Get TaxExchangeRate value
     * @return ExchangeRateType|null
     */
    public function getTaxExchangeRate()
    {
        return $this->TaxExchangeRate;
    }

    /**
     * Set TaxExchangeRate value
     * @param ExchangeRateType $taxExchangeRate
     * @return InvoiceType
     */
    public function setTaxExchangeRate(ExchangeRateType $taxExchangeRate = null)
    {
        $this->TaxExchangeRate = $taxExchangeRate;
        return $this;
    }

    /**
     * Get PricingExchangeRate value
     * @return ExchangeRateType|null
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }

    /**
     * Set PricingExchangeRate value
     * @param ExchangeRateType $pricingExchangeRate
     * @return InvoiceType
     */
    public function setPricingExchangeRate(ExchangeRateType $pricingExchangeRate = null)
    {
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }

    /**
     * Get PaymentExchangeRate value
     * @return ExchangeRateType|null
     */
    public function getPaymentExchangeRate()
    {
        return $this->PaymentExchangeRate;
    }

    /**
     * Set PaymentExchangeRate value
     * @param ExchangeRateType $paymentExchangeRate
     * @return InvoiceType
     */
    public function setPaymentExchangeRate(ExchangeRateType $paymentExchangeRate = null)
    {
        $this->PaymentExchangeRate = $paymentExchangeRate;
        return $this;
    }

    /**
     * Get PaymentAlternativeExchangeRate value
     * @return ExchangeRateType|null
     */
    public function getPaymentAlternativeExchangeRate()
    {
        return $this->PaymentAlternativeExchangeRate;
    }

    /**
     * Set PaymentAlternativeExchangeRate value
     * @param ExchangeRateType $paymentAlternativeExchangeRate
     * @return InvoiceType
     */
    public function setPaymentAlternativeExchangeRate(ExchangeRateType $paymentAlternativeExchangeRate = null)
    {
        $this->PaymentAlternativeExchangeRate = $paymentAlternativeExchangeRate;
        return $this;
    }

    /**
     * Get TaxTotal value
     * @return TaxTotalType[]|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }

    /**
     * This method is responsible for validating the values passed to the setTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTotalForArrayConstraintsFromSetTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeTaxTotalItem instanceof TaxTotalType) {
                $invalidValues[] = is_object($invoiceTypeTaxTotalItem) ? get_class($invoiceTypeTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceTypeTaxTotalItem), var_export($invoiceTypeTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set TaxTotal value
     * @param TaxTotalType[] $taxTotal
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setTaxTotal(array $taxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTotalArrayErrorMessage = self::validateTaxTotalForArrayConstraintsFromSetTaxTotal($taxTotal))) {
            throw new InvalidArgumentException($taxTotalArrayErrorMessage, __LINE__);
        }
        $this->TaxTotal = $taxTotal;
        return $this;
    }

    /**
     * Add item to TaxTotal value
     * @param TaxTotalType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToTaxTotal(TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TaxTotalType) {
            throw new InvalidArgumentException(sprintf('The TaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxTotal[] = $item;
        return $this;
    }

    /**
     * Get WithholdingTaxTotal value
     * @return TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }

    /**
     * This method is responsible for validating the values passed to the setWithholdingTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholdingTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeWithholdingTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeWithholdingTaxTotalItem instanceof TaxTotalType) {
                $invalidValues[] = is_object($invoiceTypeWithholdingTaxTotalItem) ? get_class($invoiceTypeWithholdingTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceTypeWithholdingTaxTotalItem), var_export($invoiceTypeWithholdingTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithholdingTaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set WithholdingTaxTotal value
     * @param TaxTotalType[] $withholdingTaxTotal
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($withholdingTaxTotalArrayErrorMessage = self::validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal($withholdingTaxTotal))) {
            throw new InvalidArgumentException($withholdingTaxTotalArrayErrorMessage, __LINE__);
        }
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }

    /**
     * Add item to WithholdingTaxTotal value
     * @param TaxTotalType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToWithholdingTaxTotal(TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TaxTotalType) {
            throw new InvalidArgumentException(sprintf('The WithholdingTaxTotal property can only contain items of type \Gek\UyumBahce\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }

    /**
     * Get LegalMonetaryTotal value
     * @return MonetaryTotalType|null
     */
    public function getLegalMonetaryTotal()
    {
        return $this->LegalMonetaryTotal;
    }

    /**
     * Set LegalMonetaryTotal value
     * @param MonetaryTotalType $legalMonetaryTotal
     * @return InvoiceType
     */
    public function setLegalMonetaryTotal(MonetaryTotalType $legalMonetaryTotal = null)
    {
        $this->LegalMonetaryTotal = $legalMonetaryTotal;
        return $this;
    }

    /**
     * Get InvoiceLine value
     * @return InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }

    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceTypeInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$invoiceTypeInvoiceLineItem instanceof InvoiceLineType) {
                $invalidValues[] = is_object($invoiceTypeInvoiceLineItem) ? get_class($invoiceTypeInvoiceLineItem) : sprintf('%s(%s)', gettype($invoiceTypeInvoiceLineItem), var_export($invoiceTypeInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahce\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set InvoiceLine value
     * @param InvoiceLineType[] $invoiceLine
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }

    /**
     * Add item to InvoiceLine value
     * @param InvoiceLineType $item
     * @return InvoiceType
     * @throws InvalidArgumentException
     */
    public function addToInvoiceLine(InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceLineType) {
            throw new InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahce\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }

    /**
     * Get schemaLocation value
     * @return string|null
     */
    public function getSchemaLocation()
    {
        return $this->schemaLocation;
    }

    /**
     * Set schemaLocation value
     * @param string $schemaLocation
     * @return InvoiceType
     */
    public function setSchemaLocation($schemaLocation = null)
    {
        // validation for constraint: string
        if (!is_null($schemaLocation) && !is_string($schemaLocation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaLocation, true), gettype($schemaLocation)), __LINE__);
        }
        $this->schemaLocation = $schemaLocation;
        return $this;
    }
}
