<?php

namespace Gek\UyumBahce\ArrayType;

use Gek\UyumBahce\StructType\InvoiceInfo;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceInfo extends AbstractStructArrayBase
{
    /**
     * The InvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var InvoiceInfo[]
     */
    public $InvoiceInfo;

    /**
     * Constructor method for ArrayOfInvoiceInfo
     * @param InvoiceInfo[] $invoiceInfo
     * @uses ArrayOfInvoiceInfo::setInvoiceInfo()
     */
    public function __construct(array $invoiceInfo = array())
    {
        $this
            ->setInvoiceInfo($invoiceInfo);
    }

    /**
     * Get InvoiceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return InvoiceInfo[]|null
     */
    public function getInvoiceInfo()
    {
        return isset($this->InvoiceInfo) ? $this->InvoiceInfo : null;
    }

    /**
     * This method is responsible for validating the values passed to the setInvoiceInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceInfoForArrayConstraintsFromSetInvoiceInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceInfoInvoiceInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceInfoInvoiceInfoItem instanceof InvoiceInfo) {
                $invalidValues[] = is_object($arrayOfInvoiceInfoInvoiceInfoItem) ? get_class($arrayOfInvoiceInfoInvoiceInfoItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceInfoInvoiceInfoItem), var_export($arrayOfInvoiceInfoInvoiceInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceInfo property can only contain items of type \Gek\UyumBahce\StructType\InvoiceInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set InvoiceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param InvoiceInfo[] $invoiceInfo
     * @return ArrayOfInvoiceInfo
     * @throws InvalidArgumentException
     */
    public function setInvoiceInfo(array $invoiceInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceInfoArrayErrorMessage = self::validateInvoiceInfoForArrayConstraintsFromSetInvoiceInfo($invoiceInfo))) {
            throw new InvalidArgumentException($invoiceInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceInfo) || (is_array($invoiceInfo) && empty($invoiceInfo))) {
            unset($this->InvoiceInfo);
        } else {
            $this->InvoiceInfo = $invoiceInfo;
        }
        return $this;
    }

    /**
     * Add item to InvoiceInfo value
     * @param InvoiceInfo $item
     * @return ArrayOfInvoiceInfo
     * @throws InvalidArgumentException
     */
    public function addToInvoiceInfo(InvoiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceInfo) {
            throw new InvalidArgumentException(sprintf('The InvoiceInfo property can only contain items of type \Gek\UyumBahce\StructType\InvoiceInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceInfo[] = $item;
        return $this;
    }

    /**
     * Returns the current element
     * @return InvoiceInfo|null
     * @see AbstractStructArrayBase::current()
     */
    public function current()
    {
        return parent::current();
    }

    /**
     * Returns the indexed element
     * @param int $index
     * @return InvoiceInfo|null
     * @see AbstractStructArrayBase::item()
     */
    public function item($index)
    {
        return parent::item($index);
    }

    /**
     * Returns the first element
     * @return InvoiceInfo|null
     * @see AbstractStructArrayBase::first()
     */
    public function first()
    {
        return parent::first();
    }

    /**
     * Returns the last element
     * @return InvoiceInfo|null
     * @see AbstractStructArrayBase::last()
     */
    public function last()
    {
        return parent::last();
    }

    /**
     * Returns the element at the offset
     * @param int $offset
     * @return InvoiceInfo|null
     * @see AbstractStructArrayBase::offsetGet()
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }

    /**
     * Returns the attribute name
     * @return string InvoiceInfo
     * @see AbstractStructArrayBase::getAttributeName()
     */
    public function getAttributeName()
    {
        return 'InvoiceInfo';
    }
}
