<?php
namespace GekTools\Locale\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Locale\Entities\Extensions\LocalizedPropertyTrait;

class LocalizedProperty extends BaseEntity 
{

    use LocalizedPropertyTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'languageId' => null,
        'entityId' => null,
        'entityFullName' => null,
        'fieldName' => null,
        'value' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'languageId' => 0,
        'entityId' => 0,
        'entityFullName' => '',
        'fieldName' => '',
        'value' => null,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'languageId' => 'int',
        'entityId' => 'int',
        'entityFullName' => 'string',
        'fieldName' => 'string',
        'value' => '?string',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * languageId getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getLanguageId():?int {
        $_attrKey = $this->mapProperty('languageId');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * languageId setter

     * 
     * @param int $languageId
     * @return self
     */ 
    public function setLanguageId(int $languageId):self {
        $_attrKey = $this->mapProperty('languageId');
        $this->attributes[$_attrKey] = $languageId;
        return $this;
    }

    /**
     * entityId getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getEntityId():?int {
        $_attrKey = $this->mapProperty('entityId');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * entityId setter

     * 
     * @param int $entityId
     * @return self
     */ 
    public function setEntityId(int $entityId):self {
        $_attrKey = $this->mapProperty('entityId');
        $this->attributes[$_attrKey] = $entityId;
        return $this;
    }

    /**
     * entityFullName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getEntityFullName():?string {
        $_attrKey = $this->mapProperty('entityFullName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * entityFullName setter

     * 
     * @param string $entityFullName
     * @return self
     */ 
    public function setEntityFullName(string $entityFullName):self {
        $_attrKey = $this->mapProperty('entityFullName');
        $this->attributes[$_attrKey] = $entityFullName;
        return $this;
    }

    /**
     * fieldName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getFieldName():?string {
        $_attrKey = $this->mapProperty('fieldName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * fieldName setter

     * 
     * @param string $fieldName
     * @return self
     */ 
    public function setFieldName(string $fieldName):self {
        $_attrKey = $this->mapProperty('fieldName');
        $this->attributes[$_attrKey] = $fieldName;
        return $this;
    }

    /**
     * value getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getValue():?string {
        $_attrKey = $this->mapProperty('value');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * value setter

     * 
     * @param string|null $value
     * @return self
     */ 
    public function setValue(?string $value):self {
        $_attrKey = $this->mapProperty('value');
        $this->attributes[$_attrKey] = $value;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return LocalizedPropertyFieldsInfo
     */ 
    public static function getFieldsInfo():LocalizedPropertyFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new LocalizedPropertyFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class LocalizedPropertyFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $languageId = 'languageId';

    /**
     * 
     * @var string
     */ 
    public string $entityId = 'entityId';

    /**
     * 
     * @var string
     */ 
    public string $entityFullName = 'entityFullName';

    /**
     * 
     * @var string
     */ 
    public string $fieldName = 'fieldName';

    /**
     * 
     * @var string
     */ 
    public string $value = 'value';

}
