<?php
namespace GekTools\GenericAttributes\Models;

use GekTools\GenericAttributes\Entities\GenericAttribute;
use GekTools\Tools\BaseModel;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;

class GenericAttributesModel extends BaseModel 
{

    #region fields

    protected $table = 'generic_attributes';

    protected $returnType = GenericAttribute::class;

    protected $primaryKey = 'id';

    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $allowedFields = [
        'entityId',
        'entityFullName',
        'key',
        'value',
        'type',
        'nullable',
    ];

    protected $validationRules = [
        'entityId' => 'required|integer|greater_than_equal_to[0]',
        'entityFullName' => 'required|string|max_length[300]',
        'key' => 'required|string|max_length[300]',
        'type' => 'required|string|max_length[300]',
    ];

    #endregion fields

    #region ctor

    /**
     * 
     * @param ConnectionInterface $db
     * @param ValidationInterface $validation
     */ 
    public function __construct(ConnectionInterface &$db = null, ValidationInterface $validation = null){
        parent::__construct($db, $validation);
    }

    #endregion ctor

}
