<?php

namespace GekTools\Currencies\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateCurrencies extends Migration
{

    use MigrationTrait;

    protected string $tableName = 'currencies';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'Currency';
        $this->namespace = 'GekTools\\Currencies';
        $this->addPrimaryKeyField($this->pkName);

        $this->addStringField('name',50)
            ->addStringField('currencyCode',3)
            ->addFloatField('buyRate')
            ->addFloatField('saleRate')
            ->addStringField('displayLocale',50,true)
            ->addStringField('customFormatting',50,true)
            ->addDisplayOrder()
            ->addBoolField('published')
            ->addCreatedAtUtc()
            ->addUpdatedAtUtc();

        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
