<?php


namespace GekTools\Tools\Routing;


use Config\Services;
use Gek\Infrastructure\Str;

class RouteUrlHelper
{

    #region fields

    /**
     * @var array|null
     */
    protected ?array $rotes = null;

    #endregion fields

    #region ctor
    /**
     * RouteUrlHelper constructor.
     */
    public function __construct()
    {
        //$this->fillRoutes();
    }

    #endregion ctor

    #region methods

    /**
     * @return array|null
     * @throws \ReflectionException
     */
    public function getAll()
    {
        if(empty($this->rotes)){
            $this->fillRoutes();
        }
        return $this->rotes;
    }

    /**
     * @param string $controller
     * @param string $method
     * @param array $params
     * @param string $httpMethod
     * @return string|null
     * @throws \ReflectionException
     */
    public function getPath(string $controller, string $method = 'index', array $params = array(), string $httpMethod = 'auto'):?string
    {
        $rObj = $this->getRouteObject($controller,$method,$params,$httpMethod);
        if(!empty($rObj)){
            return $rObj->getUrl($params);
        }
        return null;
    }

    /**
     * @param string $controller
     * @param string $method
     * @param array $params
     * @param string $httpMethod
     * @return RouteObject|mixed|null
     * @throws \ReflectionException
     */
    public function getRouteObject(string $controller, string $method = 'index', array $params = array(), string $httpMethod = 'auto')
    {
        if(empty($this->rotes)){
            $this->fillRoutes();
        }

        if ($httpMethod != 'auto' && !isset($this->rotes[strtolower($httpMethod)])) {
            return null;
        }
        if ($httpMethod == 'auto') {
            $keys = array_keys($this->rotes);
        } else {
            $keys = array(strtolower($httpMethod));
        }

        foreach ($params as &$prm){
            if(Str::contains($prm,'(')){
                if(trim($prm) == '(:any)'){
                    $prm = '(.*)';
                }elseif(trim($prm) == '(:num)'){
                    $prm = '([0-9])';
                }
            }
        }


        if(! Str::startsWith($controller,'\\')){
            $controller = '\\' . $controller;
        }
        foreach ($keys as $ky) {
            if (isset($this->rotes[$ky][$controller][$method])) {
                foreach ($this->rotes[$ky][$controller][$method] as $rtObj) {
                    /** @var RouteObject $rtObj */
                    if ($rtObj->checkParameters($params)){
                        return  $rtObj;
                    }
                }
            }
        }
        return null;
    }

    #endregion methods

    #region utils

    /**
     * @throws \ReflectionException
     */
    protected function fillRoutes()
    {
        if (!empty($this->rotes)) {
            return;
        }
        $routes = Services::routes();
        $reflect = new \ReflectionObject($routes);
        $prp = $reflect->getProperty('routes');
        $prp->setAccessible(true);
        $rt = $prp->getValue($routes);

        $newRoutes = array();


        foreach ($rt as $ky => $val) {

            $newRoutes[$ky] = $this->fillSubRoute($val);
        }
        $this->rotes = $newRoutes;
    }

    /**
     * @param $rts
     * @return array
     */
    protected function fillSubRoute($rts): array
    {
        $res = array();
        foreach ($rts as $key => $val) {
            if (isset($val['route'])) {
                $firstKey = null;
                $firstVal = null;
                foreach ($val['route'] as $k => $v) {
                    $firstKey = $k;
                    $firstVal = $v;
                    break;
                }
                if (!empty($firstKey) && !empty($firstVal)) {
                    if (!is_string($firstVal)) {
                        continue;
                    }
                    $routeObj = new RouteObject($firstKey, $firstVal);

                    if (!isset($res[$routeObj->getController()])) {
                        $res[$routeObj->getController()] = array();
                    }
                    if (!isset($res[$routeObj->getController()][$routeObj->getMethod()])) {
                        $res[$routeObj->getController()][$routeObj->getMethod()] = array();
                    }
                    $res[$routeObj->getController()][$routeObj->getMethod()][] = $routeObj;
                }
            }
        }
        return $res;
    }

    #endregion utils

    #region static

    /**
     * @return RouteUrlHelper
     */
    public static function instance():RouteUrlHelper{
        static $instance = null;
        if($instance == null){
            $instance = new RouteUrlHelper();
        }
        return $instance;
    }

    #endregion static

}