<?php


namespace GekTools\Tools;


use Gek\Collections\Enumerable;
use Gek\Infrastructure\ClassHelper;
use Gek\Infrastructure\Reflections\DocCommentObject;
use ReflectionProperty;

class BaseModelData
{

    public function fillFromPostArray(array $postArray, ?int $index = null): void
    {
        $reflect = ClassHelper::reflectClass(get_called_class());
        $props = $reflect->getProperties(ReflectionProperty::IS_PUBLIC);

        foreach ($props as $prp) {
            $refType = $prp->getType();

            $type = null;
            $nullable = null;
            if ($refType) {
                $type = $refType->getName();
                $nullable = $refType->allowsNull();
            } else {
                $docCom = new DocCommentObject($prp->getDocComment());
                $vars = $docCom->getKey('var');
                if ($vars) {
                    $vars = Enumerable::fromArray(explode('|', $vars))
                        ->where(function ($itm) {
                            return !empty(trim($itm));
                        })
                        ->select(function ($itm) {
                            return trim($itm);
                        })
                        ->toArrayList();
                    $nullable = $vars->any(function ($itm) {
                        return strtolower($itm) == 'null';
                    });
                    $vars->removeAll(function ($itm) {
                        return strtolower($itm) == 'null';
                    });
                    if ($vars->count() == 1) {
                        $type = $vars->firstOrNull();
                    } else {
                        $type = implode('|', $vars->toArray());
                    }
                }
            }
            $isset = ($index !== null) ? isset($postArray[$prp->getName()][$index]) : isset($postArray[$prp->getName()]);
            if ($isset) {
                $postVal = ($index !== null) ? $postArray[$prp->getName()][$index] : $postArray[$prp->getName()];
                if ($type === null) {
                    $this->{$prp->getName()} = $postVal;
                } else {
                    if (strpos($type, '|') === false) {
                        switch (true) {
                            case strtolower(trim($type)) === 'bool':
                            case strtolower(trim($type)) === 'boolean':
                                $postVal = $postVal == 'on' ? true : boolval($postVal);
                                break;
                            case strtolower(trim($type)) === 'float':
                            case strtolower(trim($type)) === 'double':
                                $postVal = floatval($postVal);
                                break;
                            case strtolower(trim($type)) === 'int':
                            case strtolower(trim($type)) === 'integer':
                                $postVal = intval($postVal);
                                break;
                        }
                        $this->{$prp->getName()} = $postVal;
                    } else {
                        $this->{$prp->getName()} = $postVal;
                    }
                }
            }
        }
    }

}