<?php
namespace GekTools\Membership\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Membership\Entities\Extensions\UserRoleMapTrait;

class UserRoleMap extends BaseEntity 
{

    use UserRoleMapTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'userId' => null,
        'roleId' => null,
    ];

    protected $defaultValues = [
        'id' => 0,
        'userId' => 0,
        'roleId' => 0,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'userId' => 'int',
        'roleId' => 'int',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * userId getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getUserId():?int {
        $_attrKey = $this->mapProperty('userId');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * userId setter

     * 
     * @param int $userId
     * @return self
     */ 
    public function setUserId(int $userId):self {
        $_attrKey = $this->mapProperty('userId');
        $this->attributes[$_attrKey] = $userId;
        return $this;
    }

    /**
     * roleId getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getRoleId():?int {
        $_attrKey = $this->mapProperty('roleId');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * roleId setter

     * 
     * @param int $roleId
     * @return self
     */ 
    public function setRoleId(int $roleId):self {
        $_attrKey = $this->mapProperty('roleId');
        $this->attributes[$_attrKey] = $roleId;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return UserRoleMapFieldsInfo
     */ 
    public static function getFieldsInfo():UserRoleMapFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new UserRoleMapFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class UserRoleMapFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $userId = 'userId';

    /**
     * 
     * @var string
     */ 
    public string $roleId = 'roleId';

}
