<?php
namespace GekTools\Membership\Entities;

use GekTools\Tools\BaseEntity;
use GekTools\Tools\Contrats\ISystemName;
use GekTools\Membership\Entities\Extensions\UserRoleTrait;

class UserRole extends BaseEntity implements ISystemName 
{

    use UserRoleTrait;

    #region fields

    protected $attributes = [
        'id' => null,
        'name' => null,
        'systemName' => null,
        'active' => 0,
    ];

    protected $defaultValues = [
        'id' => 0,
        'name' => '',
        'systemName' => null,
        'active' => 0,
    ];

    protected $datamap = [];

    protected $casts = [
        'id' => 'int',
        'name' => 'string',
        'systemName' => '?string',
        'active' => 'bool',
    ];

    #endregion fields

    #region properties

    /**
     * id getter

     * 
     * @return int|null
     * @throws \Exception
     */ 
    public function getId():?int {
        $_attrKey = $this->mapProperty('id');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'int');
        return $result;
    }

    /**
     * name getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getName():?string {
        $_attrKey = $this->mapProperty('name');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'string');
        return $result;
    }

    /**
     * name setter

     * 
     * @param string $name
     * @return self
     */ 
    public function setName(string $name):self {
        $_attrKey = $this->mapProperty('name');
        $this->attributes[$_attrKey] = $name;
        return $this;
    }

    /**
     * systemName getter

     * 
     * @return string|null
     * @throws \Exception
     */ 
    public function getSystemName():?string {
        $_attrKey = $this->mapProperty('systemName');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, '?string');
        return $result;
    }

    /**
     * systemName setter

     * 
     * @param string|null $systemName
     * @return self
     */ 
    public function setSystemName(?string $systemName):self {
        $_attrKey = $this->mapProperty('systemName');
        $this->attributes[$_attrKey] = $systemName;
        return $this;
    }

    /**
     * active getter

     * 
     * @return bool|null
     * @throws \Exception
     */ 
    public function getActive():?bool {
        $_attrKey = $this->mapProperty('active');
        $result = $this->attributes[$_attrKey];
        $result = $this->castAs($result, 'bool');
        return $result;
    }

    /**
     * active setter

     * 
     * @param bool $active
     * @return self
     */ 
    public function setActive(bool $active):self {
        $_attrKey = $this->mapProperty('active');
        $this->attributes[$_attrKey] = $active;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * get db Fields info

     * 
     * @return UserRoleFieldsInfo
     */ 
    public static function getFieldsInfo():UserRoleFieldsInfo {
        static $fInfo = null;
        if($fInfo == null){
            $fInfo = new UserRoleFieldsInfo();
        }
        return $fInfo;
    }

    #endregion statics

}


class UserRoleFieldsInfo 
{

    /**
     * 
     * @var string
     */ 
    public string $id = 'id';

    /**
     * 
     * @var string
     */ 
    public string $name = 'name';

    /**
     * 
     * @var string
     */ 
    public string $systemName = 'systemName';

    /**
     * 
     * @var string
     */ 
    public string $active = 'active';

}
