<?php 

namespace GekTools\Membership\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateAuths extends Migration 
{

    use MigrationTrait;

    protected string $tableName = 'auths';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'Auth';
        $this->namespace = 'GekTools\\Membership';
        $this->addPrimaryKeyField($this->pkName);

        $this->addGuidField('userGuid',false,false)
            ->addStringField('agentString',600)
            ->addStringField('platform',100)
            ->addStringField('browser',100)
            ->addBoolField('isMobile',false)
            ->addBoolField('remember',false)
            ->addStringField('token',300)
            ->addStringField('ipAddress',100)
            ->addDateTimeField('expiredDateUtc',false)
            ->addKey('expiredDateUtc')
            ->addCreatedAtUtc()
            ->addUpdatedAtUtc();





        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
