<?php 

namespace GekTools\Locale\Database\Migrations;

use CodeIgniter\Database\Migration;
use GekTools\Tools\Traits\MigrationTrait;

class CreateLocalizedProperties extends Migration 
{

    use MigrationTrait;

    protected string $tableName = 'localized_properties';

    protected string $pkName = 'id';

    public function up(){
        $this->entityName = 'LocalizedProperty';
        $this->namespace = 'GekTools\\Locale';
        $this->addPrimaryKeyField($this->pkName);

        $this->addIntField('languageId',false,true)
            ->addIntField('entityId',false,true)
            ->addStringField('entityFullName',300)
            ->addStringField('fieldName',150)
            ->addTextField('value',true);


        $this->createTable($this->tableName);
    }

    public function down(){
        $this->forge->dropTable($this->tableName);
    }

}
