<?php


namespace GekTools\Commands;


use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use Config\Services;
use Gek\Filesystem\Filesystem;
use Gek\PhpLang\CodeFactory;
use Gek\PhpLang\PhpTypeDeclared;
use Gek\PhpLang\UseItem;
use Gek\Infrastructure\Str;
use GekTools\Controllers\BaseController;
use GekTools\Tools\BaseModelData;
use GekTools\Tools\Database\DbInfo;
use GekTools\Tools\DocComments\ModelDataTags;
use GekTools\Tools\Validations\Validation;
use GekTools\Tools\Validations\ValidationCollection;

class CreateController extends BaseCommand
{

    protected $group = 'Ci4Tools';
    protected $name = 'create:controller';
    protected $description = 'Yeni bir controller  oluşturur.';

    /**
     * the Command's usage
     *
     * @var string
     */
    protected $usage = 'create:controller [controller_name] [Options]';

    /**
     * the Command's Arguments
     *
     * @var array
     */
    protected $arguments = [
        'controller_name' => 'Controller adı'
    ];

    /**
     * the Command's Options
     *
     * @var array
     */
    protected $options = [
        '-n' => 'namespace ayarlar.',
        '-a' => 'area adı',
        '-p' => 'path'
    ];



    /**
     * Actually execute a command.
     * This has to be over-ridden in any concrete implementation.
     *
     * @param array $params
     * @throws \Gek\Infrastructure\Exceptions\GekException
     * @throws \ReflectionException
     * @throws \Throwable
     */
    public function run(array $params)
    {
        helper('inflector');

        $controllerName = array_shift($params);
        if (empty($controllerName)) {
            $controllerName = CLI::prompt('Controller adını girin');
        }
        $controllerName = ucfirst($controllerName);

        if (!Str::endsWith($controllerName, 'Controller')) {
            $controllerName .= 'Controller';
        }

        $ns = $params['-n'] ?? CLI::getOption('n');
        $homepath = APPPATH;

        if (!empty($ns)) {
            // Get all namespaces
            $namespaces = Services::autoloader()->getNamespace();

            foreach ($namespaces as $namespace => $path) {
                if ($namespace === $ns) {
                    $homepath = realpath(reset($path));
                    break;
                }
            }
        } else {
            $ns = 'App';
        }

        $areaName = $params['-a'] ?? CLI::getOption('a');

        if(!empty($areaName)){
            $areaName = trim($areaName);
        }


        $path = $params['-p'] ?? CLI::getOption('p');

        if (!empty($path)) {
            $path = str_replace(["/", "\\"], DIRECTORY_SEPARATOR, $path);
            $path = trim($path);
            $path = trim($path, DIRECTORY_SEPARATOR);
        }

        $controllerPath = $homepath . DIRECTORY_SEPARATOR . "Controllers" . DIRECTORY_SEPARATOR;
        if(!empty($areaName)){
            $controllerPath .= $areaName . DIRECTORY_SEPARATOR;
        }
        if (!empty($path)) {
            $controllerPath .= $path . DIRECTORY_SEPARATOR;
        }
        $controllerPath .= $controllerName . '.php';
        $controllerNs = $ns . '\\Controllers';
        if(!empty($areaName)){
            $controllerNs .= '\\' . $areaName;
        }
        if (!empty($path)) {
            $controllerNs .= "\\" . str_replace(DIRECTORY_SEPARATOR, "\\", $path);
        }
        $fs = new Filesystem();

        if ($fs->exists($controllerPath)) {
            CLI::error('Dosya zaten mevcut : ' . str_replace($homepath, $ns, $controllerPath));
            return;
        }

        $controller = CodeFactory::classCreate($controllerName)
            ->setExtends(BaseController::class)
            ->setNamespace($controllerNs);

        $controller->addConstructor();


        $fs->dumpFile($controllerPath, '<?php' . PHP_EOL . $controller->toIndentedString());
        CLI::write('Dosya oluşturuldu : ' . CLI::color(str_replace($homepath, $ns, $controllerPath), 'green'));
    }

}